package com.omni.ads.model.adssearchkeyword;

import com.omni.ads.anno.EnumValidation;

import java.io.Serializable;

public class AdSearchCategoryKwResultDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long kwId;
    private String kwName;
    @EnumValidation(
            clazz = KeywordSourceEnum.class,
            method = "getCode",
            message = "关键词来源类型不合法"
    )
    private Integer source;
    private Long pId;
    private Integer level;
    private Boolean isLeaf;
    private Long queryNum = 0L;
    private Integer suggestPrice = 0;
    private Long competeLevel = 0L;

    public AdSearchCategoryKwResultDTO() {
    }

    public AdSearchCategoryKwResultDTO(Long kwId, String kwName, Integer source, Long pId, Integer level, Boolean isLeaf) {
        this.kwId = kwId;
        this.kwName = kwName;
        this.source = source;
        this.pId = pId;
        this.level = level;
        this.isLeaf = isLeaf;
    }

    public Long getKwId() {
        return this.kwId;
    }

    public void setKwId(Long kwId) {
        this.kwId = kwId;
    }

    public Integer getSource() {
        return this.source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public Boolean getLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(Boolean leaf) {
        this.isLeaf = leaf;
    }

    public String getKwName() {
        return this.kwName;
    }

    public void setKwName(String kwName) {
        this.kwName = kwName;
    }

    public Long getpId() {
        return this.pId;
    }

    public void setpId(Long pId) {
        this.pId = pId;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public Long getQueryNum() {
        return this.queryNum;
    }

    public void setQueryNum(Long queryNum) {
        this.queryNum = queryNum;
    }

    public Integer getSuggestPrice() {
        return this.suggestPrice;
    }

    public void setSuggestPrice(Integer suggestPrice) {
        this.suggestPrice = suggestPrice;
    }

    public Long getCompeteLevel() {
        return this.competeLevel;
    }

    public void setCompeteLevel(Long competeLevel) {
        this.competeLevel = competeLevel;
    }
}
