package com.omni.ads.model.adssearchkeyword;

import com.omni.ads.anno.EnumValidation;
import io.swagger.annotations.ApiParam;

import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


public class AddCustomKwPkgForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "词包名称", required = true)
    @NotNull(message = "词包名称不能为空")
    @Length(min = 2, max = 20, message = "词包名称长度限制为2~20个字符")
    private String kwPackageName;

    @ApiParam(value = "词包类型，默认为1（自定义词包）", required = true)
    @EnumValidation(clazz = KeywordPackageEnum.class, method = "getCode", message = "词包类型取值范围为1（自定义词包）或2（禁推词包）")
    private Integer kwPackageType;

    @NotNull(message = "词包关键词不能为空")
    @Valid
    private List<PkgKeywordForm> pkgKeywords;


    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getKwPackageName() {
        return kwPackageName;
    }

    public void setKwPackageName(String kwPackageName) {
        this.kwPackageName = kwPackageName;
    }

    public Integer getKwPackageType() {
        return kwPackageType;
    }

    public void setKwPackageType(Integer kwPackageType) {
        this.kwPackageType = kwPackageType;
    }

    public List<PkgKeywordForm> getPkgKeywords() {
        return pkgKeywords;
    }

    public void setPkgKeywords(List<PkgKeywordForm> pkgKeywords) {
        this.pkgKeywords = pkgKeywords;
    }

    public List<PremiumCustomKw> convertToPremiumCustomKwList() {
        List<PremiumCustomKw> premiumCustomKws = new ArrayList<>();
        for (PkgKeywordForm keyword : pkgKeywords) {
            PremiumCustomKw customKw = new PremiumCustomKw();
            customKw.setKwPackageName(kwPackageName);
            customKw.setKwPackageType(kwPackageType);
            customKw.setKeyword(keyword.getKeyword());
            customKw.setSource(KeywordSourceEnum.CUSTOM_CUSTOM.getCode());
            if (keyword.getMatchType() == null) {
                customKw.setMatchType(KeywordMatchEnum.FUZZY.getCode());
            } else {
                customKw.setMatchType(keyword.getMatchType());
            }
            premiumCustomKws.add(customKw);
        }
        return premiumCustomKws;
    }
}
