package com.omni.ads.model.adssearchkeyword;

import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 广告组添加关键词、行业类目词包、自定义/禁推词包
 */
@Slf4j
public class AddGroupKwForm extends GroupKwForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "应用ID")
    private Long appId;

    /**
     * 广告组添加关键词
     */
    @Valid
    List<SearchKeyword> searchKeywords;

    /**
     * 广告组添加行业类目词包
     */
    @Valid
    List<CategoryPackage> categoryPackages;

    /**
     * 广告组添加自定义词包、禁推词包
     */
    @Valid
    List<CustomOrNoPackage> customOrNoPackages;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public List<SearchKeyword> getSearchKeywords() {
        return searchKeywords;
    }

    public void setSearchKeywords(List<SearchKeyword> searchKeywords) {
        this.searchKeywords = searchKeywords;
    }

    public List<CategoryPackage> getCategoryPackages() {
        return categoryPackages;
    }

    public void setCategoryPackages(List<CategoryPackage> categoryPackages) {
        this.categoryPackages = categoryPackages;
    }

    public List<CustomOrNoPackage> getCustomOrNoPackages() {
        return customOrNoPackages;
    }

    public void setCustomOrNoPackages(List<CustomOrNoPackage> customOrNoPackages) {
        this.customOrNoPackages = customOrNoPackages;
    }

    @Data
    public static class SearchKeyword implements Serializable {

        private static final long serialVersionUID = 1L;

        @ApiParam(value = "匹配类型 1:精准匹配 2:词组匹配 3:模糊匹配")
        @Range(min = 1, max = 3, message = "关键词匹配模式不合法，取值范围为1~3")
        private Integer matchType;

        @ApiParam(value = "出价(必须大于0)", required = true)
        @Min(value = 1, message = "出价词价格必须大于0")
        private Integer price;

        @ApiParam(value = "关键词 or 行业类目名称", required = true)
        @NotBlank(message = "关键词不能为空")
        @Length(max = 20, message = "关键词长度必须在[1,15]之间")
        private String keyword;

    }

    @Data
    public static class CategoryPackage implements Serializable {

        private static final long serialVersionUID = 1L;

        @ApiParam(value = "匹配类型 1:精准匹配 2:词组匹配 3:模糊匹配")
        @Range(min = 1, max = 3, message = "关键词匹配模式不合法，取值范围为1~3")
        private Integer matchType;

        @ApiParam(value = "出价(必须大于0)", required = true)
        @Min(value = 1, message = "出价词价格必须大于0")
        private Integer price;

        @ApiParam(value = "行业类目ID(当在添加出价类目词包时必传)", required = true)
        private Long categoryId;
    }

    @Data
    public static class CustomOrNoPackage implements Serializable {

        private static final long serialVersionUID = 1L;

        @ApiParam(value = "自定义词包或禁推词包ID", required = true)
        @NotNull(message = "自定义词包或禁推词包ID不能为空")
        private Long kwPackageId;

        @ApiParam(value = "出价(必须大于0)")
        @Min(value = 1, message = "出价词价格必须大于0")
        private Integer price;

    }
}
