package com.omni.ads.model.adssearchkeyword;

import com.omni.ads.model.material.vo.ConstantsV2;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 为禁推词包或自定义词包添加关键词
 */

@Slf4j
public class AddKwToPkgForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "自定义词包或禁推词包ID", required = true)
    @NotNull(message = "自定义词包或禁推词包ID不能为空")
    private Long kwPackageId;

    @NotNull(message = "词包关键词不能为空")
    @Valid
    private List<PkgKeywordForm> pkgKeywords;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getKwPackageId() {
        return kwPackageId;
    }

    public void setKwPackageId(Long kwPackageId) {
        this.kwPackageId = kwPackageId;
    }

    public List<PkgKeywordForm> getPkgKeywords() {
        return pkgKeywords;
    }

    public void setPkgKeywords(List<PkgKeywordForm> pkgKeywords) {
        this.pkgKeywords = pkgKeywords;
    }

    public static Logger getLog() {
        return log;
    }

    public List<PremiumCustomKw> convertToPremiumCustomKwList() {
        List<PremiumCustomKw> premiumCustomKws = new ArrayList<>();
        for (PkgKeywordForm keyword : pkgKeywords) {
            PremiumCustomKw customKw = new PremiumCustomKw();
            customKw.setKwPackageId(kwPackageId);
            customKw.setKeyword(NormalizeKeywordUtils.normalizeKeyword(keyword.getKeyword()));
            customKw.setSource(KeywordSourceEnum.CUSTOM_CUSTOM.getCode());
            if (keyword.getMatchType() == null) {
                customKw.setMatchType(KeywordMatchEnum.FUZZY.getCode());
            } else {
                customKw.setMatchType(keyword.getMatchType());
            }
            customKw.setAuditStatus(ConstantsV2.AUDIT_STATUS.NOT_AUDIT);
            customKw.setDeleteFlag(BaseDo.DELETE_FLAG_NO);
            premiumCustomKws.add(customKw);
        }
        return premiumCustomKws;
    }

}
