package com.omni.ads.model.adssearchkeyword;

import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 广告组删除关键词、行业类目词包、自定义/禁推词包
 */
@Data
@Slf4j
public class DeleteGroupKwForm extends GroupKwForm implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 广告组删除关键词
     */
    @Valid
    List<DeleteSearchKeyword> searchKeywords;

    /**
     * 广告组删除行业类目词包
     */
    @Valid
    List<DeleteCategoryPackage> categoryPackages;

    /**
     * 广告组删除自定义词包、禁推词包
     */
    @Valid
    List<DeleteCustomOrNoPackage> customOrNoPackages;

    @Data
    public static class DeleteSearchKeyword implements Serializable {

        private static final long serialVersionUID = 1L;

        @ApiParam(value = "关键词 or 行业类目名称", required = true)
        @NotBlank(message = "关键词不能为空")
        @Length(max = 15, message = "关键词长度必须在[1,15]之间")
        private String keyword;

        @ApiParam(value = "自定义词包或禁推词包ID", required = true)
        @NotNull(message = "自定义词包或禁推词包ID不能为空")
        private Long kwPackageId;
    }

    @Data
    public static class DeleteCategoryPackage implements Serializable {

        private static final long serialVersionUID = 1L;

        @ApiParam(value = "行业类目ID(当在添加出价类目词包时必传)", required = true)
        private Long categoryId;

        @ApiParam(value = "自定义词包或禁推词包ID", required = true)
        @NotNull(message = "自定义词包或禁推词包ID不能为空")
        private Long kwPackageId;
    }

    @Data
    public static class DeleteCustomOrNoPackage implements Serializable {

        private static final long serialVersionUID = 1L;

        @ApiParam(value = "自定义词包或禁推词包与广告组的绑定ID", required = true)
        @NotNull(message = "自定义词包或禁推词包与广告组的绑定ID为空")
        private Long id;

    }
}
