package com.omni.ads.model.adssearchkeyword;

import io.swagger.annotations.ApiParam;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


public class DeleteKwInPkgForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "词包ID", required = true)
    @NotNull(message = "自定义词包或禁推词包ID不能为空")
    private Long kwPackageId;

    @ApiParam(value = "词包关键词列表", required = true)
    @NotNull(message = "词包关键词不能为空")
    @Valid
    private List<PkgKeyword> keywords;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getKwPackageId() {
        return kwPackageId;
    }

    public void setKwPackageId(Long kwPackageId) {
        this.kwPackageId = kwPackageId;
    }

    public List<PkgKeyword> getKeywords() {
        return keywords;
    }

    public void setKeywords(List<PkgKeyword> keywords) {
        this.keywords = keywords;
    }

    public List<PremiumCustomKw> convertToPremiumCustomKw() {
        List<PremiumCustomKw> premiumCustomKws = new ArrayList<>();
        for (PkgKeyword keyword : keywords) {
            PremiumCustomKw customKw = new PremiumCustomKw();
            customKw.setKwPackageId(kwPackageId);
            customKw.setKeyword(NormalizeKeywordUtils.normalizeKeyword(keyword.getKeyword()));
            customKw.setDeleteFlag(BaseDo.DELETE_FLAG_YES);
            premiumCustomKws.add(customKw);
        }
        return premiumCustomKws;
    }

    public static class PkgKeyword {

        @Length(max = 20, message = "关键词长度不能超过20个字符")
        private String keyword;

        public String getKeyword() {
            return keyword;
        }

        public void setKeyword(String keyword) {
            this.keyword = keyword;
        }
    }
}
