package com.omni.ads.model.adssearchkeyword;

import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 广告组编辑关键词、行业类目词包、自定义词包出价
 */
@Slf4j
public class EditGroupKwForm extends GroupKwForm implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 广告组删除关键词
     */
    @Valid
    List<EditSearchKeyword> searchKeywords;

    /**
     * 广告组删除行业类目词包
     */
    @Valid
    List<EditCategoryPackage> categoryPackages;

    /**
     * 广告组删除自定义词包、禁推词包
     */
    @Valid
    List<EditCustomPackage> customPackages;

    public List<EditSearchKeyword> getSearchKeywords() {
        return searchKeywords;
    }

    public void setSearchKeywords(List<EditSearchKeyword> searchKeywords) {
        this.searchKeywords = searchKeywords;
    }

    public List<EditCategoryPackage> getCategoryPackages() {
        return categoryPackages;
    }

    public void setCategoryPackages(List<EditCategoryPackage> categoryPackages) {
        this.categoryPackages = categoryPackages;
    }

    public List<EditCustomPackage> getCustomPackages() {
        return customPackages;
    }

    public void setCustomPackages(List<EditCustomPackage> customPackages) {
        this.customPackages = customPackages;
    }

    public static class EditSearchKeyword implements Serializable {

        private static final long serialVersionUID = 1L;

        @ApiParam(value = "关键词 or 行业类目名称", required = true)
        @NotBlank(message = "关键词不能为空")
        @Length(max = 15, message = "关键词长度必须在[1,15]之间")
        private String keyword;

        @ApiParam(value = "自定义词包或禁推词包ID", required = true)
        @NotNull(message = "自定义词包或禁推词包ID不能为空")
        private Long kwPackageId;

        @ApiParam(value = "出价(必须大于0)", required = true)
        @Min(value = 1, message = "出价词价格必须大于0")
        private Integer price;

        @ApiParam(value = "匹配类型 1:精准匹配 2:词组匹配 3:模糊匹配")
        @Range(min = 1, max = 3, message = "关键词匹配类型不合法")
        private Integer matchType;

        public static long getSerialVersionUID() {
            return serialVersionUID;
        }

        public String getKeyword() {
            return keyword;
        }

        public void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        public Long getKwPackageId() {
            return kwPackageId;
        }

        public void setKwPackageId(Long kwPackageId) {
            this.kwPackageId = kwPackageId;
        }

        public Integer getPrice() {
            return price;
        }

        public void setPrice(Integer price) {
            this.price = price;
        }

        public Integer getMatchType() {
            return matchType;
        }

        public void setMatchType(Integer matchType) {
            this.matchType = matchType;
        }
    }

    public static class EditCategoryPackage implements Serializable {

        private static final long serialVersionUID = 1L;

        @ApiParam(value = "行业类目ID(当在添加出价类目词包时必传)", required = true)
        private Long categoryId;

        @ApiParam(value = "自定义词包或禁推词包ID", required = true)
        @NotNull(message = "自定义词包或禁推词包ID不能为空")
        private Long kwPackageId;

        @ApiParam(value = "出价(必须大于0)", required = true)
        @Min(value = 1, message = "出价词价格必须大于0")
        private Integer price;

        @ApiParam(value = "匹配类型 1:精准匹配 2:词组匹配 3:模糊匹配")
        @Range(min = 1, max = 3, message = "关键词匹配类型不合法")
        private Integer matchType;

        public static long getSerialVersionUID() {
            return serialVersionUID;
        }

        public Long getCategoryId() {
            return categoryId;
        }

        public void setCategoryId(Long categoryId) {
            this.categoryId = categoryId;
        }

        public Long getKwPackageId() {
            return kwPackageId;
        }

        public void setKwPackageId(Long kwPackageId) {
            this.kwPackageId = kwPackageId;
        }

        public Integer getPrice() {
            return price;
        }

        public void setPrice(Integer price) {
            this.price = price;
        }

        public Integer getMatchType() {
            return matchType;
        }

        public void setMatchType(Integer matchType) {
            this.matchType = matchType;
        }
    }

    public static class EditCustomPackage implements Serializable {

        private static final long serialVersionUID = 1L;

        @ApiParam(value = "自定义词包或禁推词包与广告组的绑定ID", required = true)
        @NotNull(message = "自定义词包或禁推词包与广告组的绑定ID为空")
        private Long id;

        @ApiParam(value = "出价(必须大于0)", required = true)
        @Min(value = 1, message = "出价词价格必须大于0")
        private Integer price;

        public static long getSerialVersionUID() {
            return serialVersionUID;
        }

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Integer getPrice() {
            return price;
        }

        public void setPrice(Integer price) {
            this.price = price;
        }
    }
}
