package com.omni.ads.model.adssearchkeyword;

import io.swagger.annotations.ApiParam;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.springframework.util.CollectionUtils;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EditKwPkgForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "自定义词包或禁推词包ID", required = true)
    @NotNull(message = "自定义词包或禁推词包ID不能为空")
    private Long kwPackageId;

    @ApiParam(value = "词包名称", required = true)
    @Length(min = 2, max = 20, message = "词包名称长度限制为2~20个字符")
    private String kwPackageName;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getKwPackageId() {
        return kwPackageId;
    }

    public void setKwPackageId(Long kwPackageId) {
        this.kwPackageId = kwPackageId;
    }

    public String getKwPackageName() {
        return kwPackageName;
    }

    public void setKwPackageName(String kwPackageName) {
        this.kwPackageName = kwPackageName;
    }

    public List<PkgKeywordForm> getPkgKeywords() {
        return pkgKeywords;
    }

    public void setPkgKeywords(List<PkgKeywordForm> pkgKeywords) {
        this.pkgKeywords = pkgKeywords;
    }

    @Valid
    private List<PkgKeywordForm> pkgKeywords;

    public List<PremiumCustomKw> convertToPremiumCustomKwList() {
        List<PremiumCustomKw> premiumCustomKws = new ArrayList<>();
        if (CollectionUtils.isEmpty(pkgKeywords)) {
            return premiumCustomKws;
        }
        for (PkgKeywordForm keyword : pkgKeywords) {
            PremiumCustomKw customKw = new PremiumCustomKw();
            customKw.setKwPackageId(kwPackageId);
            customKw.setKwPackageName(kwPackageName);
            customKw.setKeyword(NormalizeKeywordUtils.normalizeKeyword(keyword.getKeyword()));
            customKw.setMatchType(keyword.getMatchType());
            premiumCustomKws.add(customKw);
        }
        return premiumCustomKws;
    }
}
