package com.omni.ads.model.adssearchkeyword;

public enum KeywordSourceEnum {
    ALL(0, "0 默认查所有类型，此枚举值非关键词类型"),
    CATEGORY(2, "行业类目"),
    ALGORITHM(1, "系统推荐"),
    HOT(3, "行业热词"),
    CUSTOM(5, "广告主手动输入或手动上传"),
    ALGORITHM_CUSTOM(6, "系统推荐"),
    CUSTOM_CUSTOM(7, "广告主手动输入或手动上传");

    private final Integer code;
    private final String description;

    private KeywordSourceEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }
}
