package com.omni.ads.model.adssearchkeyword;

import com.google.common.collect.Sets;
import io.swagger.annotations.ApiParam;

import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import static com.omni.ads.model.adssearchkeyword.KeywordSourceEnum.*;


public class ListGroupKwPkgForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "广告组ID", required = true)
    @NotNull(message = "广告组id不能为空")
    @Min(value = 1, message = "广告组id必须大于0")
    private Long adGroupId;

    @ApiParam(value = "查询类型，默认为0（查询全部）")
    @Range(min = 0, max = 3, message = "查询类型非法，取值范围为0~3")
    private Integer type = 0;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public AdSearchPremiumKwQueryDTO convertToQueryDTO() {

        AdSearchPremiumKwQueryDTO queryDTO = new AdSearchPremiumKwQueryDTO();
        queryDTO.setAdGroupId(adGroupId);

        Set<Integer> sourceSet = new HashSet<>();
        switch (type) {
            case 1:
                sourceSet.addAll(Sets.newHashSet(ALGORITHM.getCode(), HOT.getCode(), CUSTOM.getCode()));
                break;
            case 2:
                sourceSet.add(CATEGORY.getCode());
                break;
            default:
                sourceSet.add(ALL.getCode());
                break;
        }
        queryDTO.setSourceSet(sourceSet);
        // 请求标识，0-送审服务(ads--content-distribution)，1-web端
        queryDTO.setCallFlag(1);
        return queryDTO;
    }
}
