package com.omni.ads.model.adssearchkeyword;

import io.swagger.annotations.ApiParam;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

public class PkgKeywordForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiParam(value = "词包关键词", required = true)
    @NotNull(message = "关键词不能为空")
    @Length(max = 20, message = "关键词长度不能超过20个字符")
    private String keyword;

    @ApiParam(value = "关键词匹配模式,1：精准匹配,2：词组匹配,3：模糊匹配")
    @Range(min = 1, max = 3, message = "关键词匹配模式不合法，取值范围为1~3")
    private Integer matchType;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Integer getMatchType() {
        return matchType;
    }

    public void setMatchType(Integer matchType) {
        this.matchType = matchType;
    }
}
