package com.omni.ads.model.adstarget;
import java.io.Serializable;

/**
 * @author 80204975
 * @date 2019/3/12 10:45
 */
public class AdsTargetForm implements Serializable{

    private static final long serialVersionUID = 6615289871559461147L;
    private Long id; // 定向id
    private Integer delStatus; // 删除标识
    private Integer bizType; // 展示类型:信息流,品牌,联盟
    private String openV2TargetId; // 外部定向id

    public TargetFilter buildFilter() {
        TargetFilter filter = new TargetFilter();
        filter.setOpenV2TargetId(openV2TargetId);
        filter.setDelStatus(delStatus);
        filter.setTargetId(id);
        filter.setSources(TargetSourceConstants.getDefaultTargetSource());
        return filter;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getDelStatus() {
        return delStatus;
    }

    public void setDelStatus(Integer delStatus) {
        this.delStatus = delStatus;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getOpenV2TargetId() {
        return openV2TargetId;
    }

    public void setOpenV2TargetId(String openV2TargetId) {
        this.openV2TargetId = openV2TargetId;
    }
}
