/**
 * Copyright (c) 2018 OPPO, All Rights Reserved.
 * 
 * Create Date:2018年6月19日
 * History:
 *   ver	date	  author		desc	
 * ────────────────────────────────────────────────────────
 *   1.0	2018年6月5日  80166776	  		
 *
 * 
*/
package com.omni.ads.model.adstarget;


import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 定向meta数据,ip,app分类,应用已安装等数据.
 * 
 * @author 80166776
 * 
 *         2018年6月19日
 */
public class AdsTargetMetadataVo {
	/**
	 * app分类.
	 */
	private List<Map<String, Object>> appCats;
	/**
	 * 兴趣标签(旧版本)
	 */
	private List<Map<String, Object>> interestedTags;

	/**
	 * 兴趣标签(新版本)
	 */
	private List<Map<String, Object>> interestedTagsV2;
	/**
	 * 联盟app
	 */
	private List<Map<String, Object>> unionApps;
	/**
	 * 手机型号属性
	 */
	private List<Map<String, Object>> mobiles;
	/**
	 * app列表
	 */
	private List<Map<String, Object>> apps;
	/**
	 * 用户权限
	 */
	private Set<Integer> permissions;
	/**
	 * 定向配置
	 */
	private TargetMgeConfig targetMgeConfig;
	/**
	 * 天气编码列表
	 */
	private List<Map<String, Object>> weatherShowList;
	/**
	 * 快应用列表
	 */
	private List<Map<String, Object>> instantList;

	/**
	 * 国家或地区定向列表
	 */
	private List<AdsCountryOrRegionVo> countryOrRegionList;

	/**
	 * 联盟应用定向媒体平台分类（媒体定向、流量定向）
	 */
	private List<Map<String, Object>> mediaPlatformList;

	/**
	 * 效果定向广告最大个数
	 */
	private Integer effectAudienceAdNumbers;

	public Integer getEffectAudienceAdNumbers() {
		return effectAudienceAdNumbers;
	}

	public void setEffectAudienceAdNumbers(Integer effectAudienceAdNumbers) {
		this.effectAudienceAdNumbers = effectAudienceAdNumbers;
	}

	public List<Map<String, Object>> getAppCats() {
		return appCats;
	}

	public void setAppCats(List<Map<String, Object>> appCats) {
		this.appCats = appCats;
	}

	public List<Map<String, Object>> getInterestedTags() {
		return interestedTags;
	}

	public void setInterestedTags(List<Map<String, Object>> interestedTags) {
		this.interestedTags = interestedTags;
	}

	public List<Map<String, Object>> getInterestedTagsV2() {
		return interestedTagsV2;
	}

	public void setInterestedTagsV2(List<Map<String, Object>> interestedTagsV2) {
		this.interestedTagsV2 = interestedTagsV2;
	}

	public List<Map<String, Object>> getUnionApps() {
		return unionApps;
	}

	public void setUnionApps(List<Map<String, Object>> unionApps) {
		this.unionApps = unionApps;
	}

	public List<Map<String, Object>> getMobiles() {
		return mobiles;
	}

	public void setMobiles(List<Map<String, Object>> mobiles) {
		this.mobiles = mobiles;
	}

	public List<Map<String, Object>> getApps() {
		return apps;
	}

	public void setApps(List<Map<String, Object>> apps) {
		this.apps = apps;
	}

	public Set<Integer> getPermissions() {
		return permissions;
	}

	public void setPermissions(Set<Integer> permissions) {
		this.permissions = permissions;
	}

	public TargetMgeConfig getTargetMgeConfig() {
		return targetMgeConfig;
	}

	public void setTargetMgeConfig(TargetMgeConfig targetMgeConfig) {
		this.targetMgeConfig = targetMgeConfig;
	}



	public List<Map<String, Object>> getWeatherShowList() {
		return weatherShowList;
	}

	public void setWeatherShowList(List<Map<String, Object>> weatherShowList) {
		this.weatherShowList = weatherShowList;
	}

	public List<Map<String, Object>> getInstantList() {
		return instantList;
	}

	public void setInstantList(List<Map<String, Object>> instantList) {
		this.instantList = instantList;
	}
	public List<AdsCountryOrRegionVo> getCountryOrRegionList() {
		return countryOrRegionList;
	}

	public void setCountryOrRegionList(List<AdsCountryOrRegionVo> countryOrRegionList) {
		this.countryOrRegionList = countryOrRegionList;
	}

	public List<Map<String, Object>> getMediaPlatformList() {
		return mediaPlatformList;
	}

	public void setMediaPlatformList(List<Map<String, Object>> mediaPlatformList) {
		this.mediaPlatformList = mediaPlatformList;
	}
}
