package com.omni.ads.model.adstarget;

import com.omni.ads.model.adscreativity.vo.Groups;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.*;
import java.io.Serializable;

/**
 * 定向vo对象.
 * 
 * @author 80166776
 * 
 *         2018年6月19日
 */

public class AdsTargetVo extends TargetBaseVo implements Serializable {

	private static final long serialVersionUID = -5666109994277945430L;
	private Long targetId; // 定向编号

	private Long openTargetId; // 第三方定向编号

	private String openV2TargetId; // 第三方定向id

	private String ownerId; // 广告主

	@NotNull(groups = {Groups.Edit.class, Groups.Add.class})
	@Size(min = 0, max = 30, groups = {Groups.Edit.class, Groups.Add.class})
	@Pattern(groups = {Groups.Add.class,
			Groups.Edit.class}, regexp = "(^[A-Za-z0-9\u4e00-\u9fa5！@#￥%……*~|!@#$^《》？ ，。：；【】”“（）——\\[\\]、{}·&()-_+=,.;:'\"<>/]*$)|(^$)")
	private String targetName; // 定向名称

	@NotNull(groups = {Groups.Edit.class, Groups.Add.class})
	@Size(min = 0, max = 300, groups = {Groups.Edit.class, Groups.Add.class})
	@Pattern(groups = {Groups.Add.class,
			Groups.Edit.class}, regexp = "(^[A-Za-z0-9\u4e00-\u9fa5！@#￥%……*~|!@#$^《》？，。：；【】”“（）——\\[\\]、{}·&()-_+=,.;:'\"<>/]*$)|(^$)")
	private String targetDesc; // 定向描述

	@Range(min = 0, max = 1, groups = {Groups.Edit.class})
	private int delStatus; // 删除状态：0, 正常；1,删除.

	private Integer createTime; // 创建时间

	private Integer updateTime; // 修改时间

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class, Groups.Query.class}, regexp = "^\\d{1,5}(?:,\\d{1,5}){0,500}|(^$)")
	private String region;// 地域

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class, Groups.Query.class}, regexp = "^\\d{1,5}(?:,\\d{1,5}){0,500}|(^$)")
	private String brandRegion;// 品牌当前地定向

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d+(,\\d+)*|(^$)")
	private String appCatActive;// app分类活跃

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^-?\\d+(,-?\\d+)*|(^$)")
	private String mobileModel;// 机型

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class, Groups.Query.class}, regexp = "[0-2]|999|(^$)")
	private String sex;// 性别

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class, Groups.Query.class}, regexp = "^([0-6][,])*[0-6]|999|(^$)")
	private String age;// 年龄段

	@Pattern(groups = {Groups.Add.class,
			Groups.Edit.class}, regexp = "^((WIFI|2G|3G|4G|5G|999)[,])*(WIFI|2G|3G|4G|5G|999)$|(^$)")
	private String network;// 网络

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^([1-4][,])*[1-4]|999|(^$)")
	private String mobilePrice;// 机型价格

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d+(,\\d+)*|(^$)")
	private String installAppList;// 应用已安装

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d+(,\\d+)*|(^$)")
	private String preInstallAppList;// 应用预安装

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d+(,\\d+)*|(^$)")
	private String unPreInstallAppList;// 应用非预安装

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d+(,\\d+)*|(^$)")
	private String notInstallAppList;// 应用未安装

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d{1,6}(?:,\\d{1,6}){0,500}|(^$)")
	private String permanentRegion;// 常驻地

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d+(,\\d+)*(\\|\\d+)*|(^$)")
	private String appActive;// 应用活跃

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d+(,\\d+)*(\\|\\d+)*|(^$)")
	private String appNotActive;// 应用非活跃

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class, Groups.Query.class}, regexp = "^\\d+(,\\d+)*|(^$)")
	private String interestTags;// 兴趣标签

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class, Groups.Query.class}, regexp = "^\\d+(,\\d+)*|(^$)")
	private String interestTagsV2;// 兴趣标签新版本

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class, Groups.Query.class}, regexp = "^\\d+(,\\d+)*|(^$)")
	private String tagsSystemRecommend;// 标签系统推荐

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d+(,\\d+)*|^(([A-Za-z0-9])+:[0-9])(,([A-Za-z0-9])+:[0-9])*|(^$)")
	private String unionAppId;// 联盟AppId

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d+(,\\d+)*|^(([A-Za-z0-9])+:[0-9])(,([A-Za-z0-9])+:[0-9])*|(^$)")
	private String unionAppIdRe;// 联盟App反向

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d+(,\\d+)*|(^$)")
	private String flowAppCatActive;// 流量类别
	@Min(value = 0, groups = {Groups.Add.class, Groups.Edit.class})
	@Max(value = 1, groups = {Groups.Add.class, Groups.Edit.class})
	private int immutable;// 是否可以修改.默认0-可修改
	@Min(groups = {Groups.Add.class, Groups.Edit.class}, value = 1)
	@Max(groups = {Groups.Add.class, Groups.Edit.class}, value = 12)
	private int type;// 定向类型,参考-TargetTypeEnum

	private String audience;// 人群定向属性

	private String oppAudience;//逆向定向人群(排除)

	private Long pTargetId;// 父类定向id，继承该父类的定向属性.

	private Long oppAudienceId;//逆向定向人群(排除)ID

	private Integer appActiveDays;// 应用活跃天数.

	private Integer appNotActiveDays;// 应用非活跃天数.

	private Long audienceCount;// 人群包受众数量
	@Min(groups = {Groups.Add.class, Groups.Edit.class}, value = 1)
	@Max(groups = {Groups.Add.class, Groups.Edit.class}, value = 2)
	private Integer version;// 1-原始版本.2-V2

	private Integer lookalikeTaskId;// lookalike任务ID.

	private Integer deleteSeed;// 删除种子包.0-不删除.1-删除.

	private Integer expansionStatus;// 拓展状态.0-默认.1-待拓展.2-拓展中.3-拓展完成.4-拓展失败

	private Long expansionCount;// 拓展数量.
	@Length(max = 64)
	private String seedFileName;// imei原文件名.

	private Integer showStatus;// 展示状态.1-可使用,2-拓展中,3-拓展异常,4-已删除
	// @Pattern(groups = { Groups.Add.class, Groups.Edit.class }, regexp =
	// "[0-9]{1}|[1-9]{1}[0-9]{1}|1[0-7]{1}[0-9]|180|999|(^$)")
	private String longitude;// 经度
	// @Pattern(groups = { Groups.Add.class, Groups.Edit.class }, regexp =
	// "[0-9]{1}|[1-8]{1}[0-9]{1}|90|999|(^$)")
	private String latitude;// 纬度

	// @Min(value = 3000, groups = { Groups.Add.class, Groups.Edit.class })
	// @Max(value = 15000, groups = { Groups.Add.class, Groups.Edit.class })
	// @Pattern(groups = { Groups.Add.class, Groups.Edit.class }, regexp =
	// "[3-9]{1}[0-9]{3}|1[0-4]{1}[0-9]{3}|15000|999|(^$)")
	private Long radius;// 半径.
	private String locationName;// 地点名称.
	private String address;// 地址
	private String mapLocations;// 地图点
	@Range(groups = {Groups.Add.class}, max = 6, min = 0)
	private Integer imeiType; // imei类型
	private String yesterdayInstalledApp;// 前一天已安装
	private Long sizeLimit;//人群包大小限制

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^[A-Z]{2}(?:,[A-Z]{2}){0,500}|999|(^$)")
	private String countryOrRegion;// 国家或地区
	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d{1,3}(?:,\\d{1,3}){0,10}|(^$)")
	private String weatherCode;//天气定向：限制10种天气类型

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d+(,\\d+)*|(^$)")
	private String instantInstallList;// 快应用已添加

	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d+(,\\d+)*|(^$)")
	private String instantNotInstallList;// 快应用未添加

	/**
	 * 种子ID列表
	 */
	@Pattern(groups = {Groups.Add.class}, regexp = "^\\d+(,\\d+)*|(^$)")
	private String seedIdList;
	/**
	 * 扩展人群类型：1lookalike 2MD5校验 3人群交集 4人群并集 5 效果人群
	 */
	@Min(groups = {Groups.Add.class}, value = 1)
	@Max(groups = {Groups.Add.class}, value = 12)
	private Integer taskType;
	/**
	 * APP已安装未激活列表
	 */
	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d+(,\\d+)*|(^$)")
	private String installedNeverActiveAppList;

	/**
	 * 是否过滤已转化的广告:1广告2广告组3广告计划4广告主5公司主体6APP
	 * 2024-04-02 前端先移除广告维度的过滤（后续再考虑后端增加上过滤）
	 */
	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "999|[2-6]")
	private String filterConvertedAd;

	/**
	 * 过滤已转化广告的过滤时间
	 * 0-当天
	 * 7-7天
	 * 30-一个月
	 * 90-3个月
	 * 180-6个月
	 */
	private Integer filterConvertedAdDays = 0;

	/**
	 * 应用未安装天数,0历史未安装
	 */
	@Range(groups = {Groups.Add.class}, max = 365)
	private Integer appUninstallDays = 0;

	/**
	 * 用户画像类型：
	 */
	private Integer portraitStatus;

	/**
	 * 用户画像更新时间
	 */
	private Integer portraitUpdateTime;


	/**
	 * 联盟流量包
	 */
	@Length(groups = {Groups.Add.class, Groups.Edit.class}, max = 4500, message = "流量包定向条件超过最大限制")
	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "999|^(([A-Za-z0-9])+(_[A-Za-z0-9]+){3})(,([A-Za-z0-9])+(_[A-Za-z0-9]+){3})*|(^$)")
	private String unionMediaFlag;


	/**
	 * 联盟流量标签
	 */
	@Length(groups = {Groups.Add.class, Groups.Edit.class}, max = 4500, message = "流量标签超过最大限制")
	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^\\d+(,\\d+)*|(^$)", message = "流量标签数据格式不正确")
	private String unionMediaTag;


	/**
	 * 关键词天数
	 */
	@Range(groups = {Groups.Add.class}, max = 180)
	private Integer keyWordDay;


	/**
	 * 行为类型:1 搜索,2 浏览
	 */
	@Pattern(groups = {Groups.Add.class}, regexp = "^\\d+(,\\d+)*|(^$)")
	private String behaviorType;


	/**
	 * 应用id
	 */
	private Long appId;

	/**
	 * 计划id
	 */
	private Long planId;

	/**
	 * 渠道id: 1:cpd，2:feeds, 3:lm
	 */
	private Integer chnId;

	/**
	 * 标签系统推荐状态：0:默认值，1:更新成功，2:更新失败，3:已失效
	 */
	private Integer recommendStatusType;

	/**
	 * 标签id结果
	 */
	private String resultTagIds;

	/**
	 * 推荐策略类型，默认值为0（该字段的枚举值由标签侧确定）
	 */
	private Integer recommendType;

	/**
	 * 标签系统推荐id
	 */
	private Long recommendId;
	/**
	 * App推荐埋点数据
	 */
	private String appActiveAndRecType;
	/**
	 * App推荐埋点数据
	 */
	private String appNotActiveAndRecType;

	/**
	 * 来源
	 */
	private Integer source;

	/**
	 * 是否可授权， 1.可授权 0.不可授权
	 */
	private Integer canShare;

	/**
	 * 推广应用安装
	 * 999=不限
	 * 1=已安装该应用
	 */
	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^(999)|1$", message = "推广应用安装不在可选范围内")
	private String promoteAppInstall;

	/**
	 * 推广应用安装-未安装应用
	 * 0=0
	 * 7=7天
	 * 15=15天
	 * 30=30天
	 * 90=90天
	 * 180=180天
	 */
	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^(999)|0|7|(15)|(30)|(90)|(180)$", message = "推广应用安装不在可选范围内")
	private String promoteAppNotInstalled;

	/**
	 * 推广应用启动-当日未启动
	 * 999=不限
	 * 1=当日未启动
	 */
	@Pattern(groups = {Groups.Add.class, Groups.Edit.class}, regexp = "^(999)|1$", message = "推广应用启动不在可选范围")
	private String promoteAppStartTodayNotStart;

	/**
	 * OPPO有数人群包id
	 * 999=无
	 */
	private String openDataAudience;

	/**
	 * OPPO有数人群包id（排除）
	 * 999=无
	 */
	private String oppOpenDataAudience;

	public Integer getFilterConvertedAdDays() {
		return filterConvertedAdDays;
	}

	public void setFilterConvertedAdDays(Integer filterConvertedAdDays) {
		this.filterConvertedAdDays = filterConvertedAdDays;
	}

	public Integer getKeyWordDay() {
		return keyWordDay;
	}

	public void setKeyWordDay(Integer keyWordDay) {
		this.keyWordDay = keyWordDay;
	}

	public String getBehaviorType() {
		return behaviorType;
	}

	public void setBehaviorType(String behaviorType) {
		this.behaviorType = behaviorType;
	}

	public Integer getSource() {
		return source;
	}

	public void setSource(Integer source) {
		this.source = source;
	}

	public Integer getCanShare() {
		return canShare;
	}

	public void setCanShare(Integer canShare) {
		this.canShare = canShare;
	}

	public String getPromoteAppInstall() {
		return promoteAppInstall;
	}

	public void setPromoteAppInstall(String promoteAppInstall) {
		this.promoteAppInstall = promoteAppInstall;
	}

	public String getPromoteAppNotInstalled() {
		return promoteAppNotInstalled;
	}

	public void setPromoteAppNotInstalled(String promoteAppNotInstalled) {
		this.promoteAppNotInstalled = promoteAppNotInstalled;
	}

	public String getPromoteAppStartTodayNotStart() {
		return promoteAppStartTodayNotStart;
	}

	public void setPromoteAppStartTodayNotStart(String promoteAppStartTodayNotStart) {
		this.promoteAppStartTodayNotStart = promoteAppStartTodayNotStart;
	}

	public String getOpenDataAudience() {
		return openDataAudience;
	}

	public void setOpenDataAudience(String openDataAudience) {
		this.openDataAudience = openDataAudience;
	}

	public String getOppOpenDataAudience() {
		return oppOpenDataAudience;
	}

	public void setOppOpenDataAudience(String oppOpenDataAudience) {
		this.oppOpenDataAudience = oppOpenDataAudience;
	}

	/**
	 * @return the pTargetId
	 */
	public Long getpTargetId() {
		return pTargetId;
	}

	public String getUnionMediaTag() {
		return unionMediaTag;
	}

	public void setUnionMediaTag(String unionMediaTag) {
		this.unionMediaTag = unionMediaTag;
	}

	/**
	 * @param pTargetId
	 *            the pTargetId to set
	 */

	public void setpTargetId(Long pTargetId) {
		this.pTargetId = pTargetId;
	}

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public Long getTargetId() {
		return targetId;
	}

	public void setTargetId(Long targetId) {
		this.targetId = targetId;
	}

	public Long getOpenTargetId() {
		return openTargetId;
	}

	public void setOpenTargetId(Long openTargetId) {
		this.openTargetId = openTargetId;
	}

	public String getOpenV2TargetId() {
		return openV2TargetId;
	}

	public void setOpenV2TargetId(String openV2TargetId) {
		this.openV2TargetId = openV2TargetId;
	}

	public String getOwnerId() {
		return ownerId;
	}

	public void setOwnerId(String ownerId) {
		this.ownerId = ownerId;
	}

	public String getTargetName() {
		return targetName;
	}

	public void setTargetName(String targetName) {
		this.targetName = targetName;
	}

	public String getTargetDesc() {
		return targetDesc;
	}

	public void setTargetDesc(String targetDesc) {
		this.targetDesc = targetDesc;
	}

	public int getDelStatus() {
		return delStatus;
	}

	public void setDelStatus(int delStatus) {
		this.delStatus = delStatus;
	}

	public Integer getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Integer createTime) {
		this.createTime = createTime;
	}

	public Integer getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Integer updateTime) {
		this.updateTime = updateTime;
	}

	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}

	public String getBrandRegion() {
		return brandRegion;
	}

	public void setBrandRegion(String brandRegion) {
		this.brandRegion = brandRegion;
	}

	public String getAppCatActive() {
		return appCatActive;
	}

	public void setAppCatActive(String appCatActive) {
		this.appCatActive = appCatActive;
	}

	public String getMobileModel() {
		return mobileModel;
	}

	public void setMobileModel(String mobileModel) {
		this.mobileModel = mobileModel;
	}

	public String getSex() {
		return sex;
	}

	public void setSex(String sex) {
		this.sex = sex;
	}

	public String getAge() {
		return age;
	}

	public void setAge(String age) {
		this.age = age;
	}

	public String getNetwork() {
		return network;
	}

	public void setNetwork(String network) {
		this.network = network;
	}

	public String getMobilePrice() {
		return mobilePrice;
	}

	public void setMobilePrice(String mobilePrice) {
		this.mobilePrice = mobilePrice;
	}

	public String getInstallAppList() {
		return installAppList;
	}

	public void setInstallAppList(String installAppList) {
		this.installAppList = installAppList;
	}

	public String getPreInstallAppList() {
		return preInstallAppList;
	}

	public void setPreInstallAppList(String preInstallAppList) {
		this.preInstallAppList = preInstallAppList;
	}

	public String getUnPreInstallAppList() {
		return unPreInstallAppList;
	}

	public void setUnPreInstallAppList(String unPreInstallAppList) {
		this.unPreInstallAppList = unPreInstallAppList;
	}

	public String getNotInstallAppList() {
		return notInstallAppList;
	}

	public void setNotInstallAppList(String notInstallAppList) {
		this.notInstallAppList = notInstallAppList;
	}

	public String getPermanentRegion() {
		return permanentRegion;
	}

	public void setPermanentRegion(String permanentRegion) {
		this.permanentRegion = permanentRegion;
	}

	public String getAppActive() {
		return appActive;
	}

	public void setAppActive(String appActive) {
		this.appActive = appActive;
	}

	public String getAppNotActive() {
		return appNotActive;
	}

	public void setAppNotActive(String appNotActive) {
		this.appNotActive = appNotActive;
	}

	public String getInterestTags() {
		return interestTags;
	}

	public void setInterestTags(String interestTags) {
		this.interestTags = interestTags;
	}

	public String getInterestTagsV2() {
		return interestTagsV2;
	}

	public void setInterestTagsV2(String interestTagsV2) {
		this.interestTagsV2 = interestTagsV2;
	}

	public String getTagsSystemRecommend() {
		return tagsSystemRecommend;
	}

	public void setTagsSystemRecommend(String tagsSystemRecommend) {
		this.tagsSystemRecommend = tagsSystemRecommend;
	}

	public String getUnionAppId() {
		return unionAppId;
	}

	public void setUnionAppId(String unionAppId) {
		this.unionAppId = unionAppId;
	}

	public String getUnionAppIdRe() {
		return unionAppIdRe;
	}

	public void setUnionAppIdRe(String unionAppIdRe) {
		this.unionAppIdRe = unionAppIdRe;
	}

	public String getFlowAppCatActive() {
		return flowAppCatActive;
	}

	public void setFlowAppCatActive(String flowAppCatActive) {
		this.flowAppCatActive = flowAppCatActive;
	}

	public int getImmutable() {
		return immutable;
	}

	public void setImmutable(int immutable) {
		this.immutable = immutable;
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}

	public String getAudience() {
		return audience;
	}

	public void setAudience(String audience) {
		this.audience = audience;
	}

	public String getOppAudience() {
		return oppAudience;
	}

	public void setOppAudience(String oppAudience) {
		this.oppAudience = oppAudience;
	}

	public Long getOppAudienceId() {
		return oppAudienceId;
	}

	public void setOppAudienceId(Long oppAudienceId) {
		this.oppAudienceId = oppAudienceId;
	}

	public Integer getAppActiveDays() {
		return appActiveDays;
	}

	public void setAppActiveDays(Integer appActiveDays) {
		this.appActiveDays = appActiveDays;
	}

	public Integer getAppNotActiveDays() {
		return appNotActiveDays;
	}

	public void setAppNotActiveDays(Integer appNotActiveDays) {
		this.appNotActiveDays = appNotActiveDays;
	}

	public Long getAudienceCount() {
		return audienceCount;
	}

	public void setAudienceCount(Long audienceCount) {
		this.audienceCount = audienceCount;
	}

	public Integer getVersion() {
		return version;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

	public Integer getLookalikeTaskId() {
		return lookalikeTaskId;
	}

	public void setLookalikeTaskId(Integer lookalikeTaskId) {
		this.lookalikeTaskId = lookalikeTaskId;
	}

	public Integer getDeleteSeed() {
		return deleteSeed;
	}

	public void setDeleteSeed(Integer deleteSeed) {
		this.deleteSeed = deleteSeed;
	}

	public Integer getExpansionStatus() {
		return expansionStatus;
	}

	public void setExpansionStatus(Integer expansionStatus) {
		this.expansionStatus = expansionStatus;
	}

	public Long getExpansionCount() {
		return expansionCount;
	}

	public void setExpansionCount(Long expansionCount) {
		this.expansionCount = expansionCount;
	}

	public String getSeedFileName() {
		return seedFileName;
	}

	public void setSeedFileName(String seedFileName) {
		this.seedFileName = seedFileName;
	}

	public Integer getShowStatus() {
		return showStatus;
	}

	public void setShowStatus(Integer showStatus) {
		this.showStatus = showStatus;
	}

	public String getLongitude() {
		return longitude;
	}

	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}

	public String getLatitude() {
		return latitude;
	}

	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}

	public Long getRadius() {
		return radius;
	}

	public void setRadius(Long radius) {
		this.radius = radius;
	}

	public String getLocationName() {
		return locationName;
	}

	public void setLocationName(String locationName) {
		this.locationName = locationName;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getMapLocations() {
		return mapLocations;
	}

	public void setMapLocations(String mapLocations) {
		this.mapLocations = mapLocations;
	}

	public Integer getImeiType() {
		return imeiType;
	}

	public void setImeiType(Integer imeiType) {
		this.imeiType = imeiType;
	}

	public String getYesterdayInstalledApp() {
		return yesterdayInstalledApp;
	}

	public void setYesterdayInstalledApp(String yesterdayInstalledApp) {
		this.yesterdayInstalledApp = yesterdayInstalledApp;
	}

	public Long getSizeLimit() {
		return sizeLimit;
	}

	public void setSizeLimit(Long sizeLimit) {
		this.sizeLimit = sizeLimit;
	}

	public String getCountryOrRegion() {
		return countryOrRegion;
	}

	public void setCountryOrRegion(String countryOrRegion) {
		this.countryOrRegion = countryOrRegion;
	}

	public String getWeatherCode() {
		return weatherCode;
	}

	public void setWeatherCode(String weatherCode) {
		this.weatherCode = weatherCode;
	}

	public String getInstantInstallList() {
		return instantInstallList;
	}

	public void setInstantInstallList(String instantInstallList) {
		this.instantInstallList = instantInstallList;
	}

	public String getInstantNotInstallList() {
		return instantNotInstallList;
	}

	public void setInstantNotInstallList(String instantNotInstallList) {
		this.instantNotInstallList = instantNotInstallList;
	}

	public String getSeedIdList() {
		return seedIdList;
	}

	public void setSeedIdList(String seedIdList) {
		this.seedIdList = seedIdList;
	}

	public Integer getTaskType() {
		return taskType;
	}

	public void setTaskType(Integer taskType) {
		this.taskType = taskType;
	}

	public String getInstalledNeverActiveAppList() {
		return installedNeverActiveAppList;
	}

	public void setInstalledNeverActiveAppList(String installedNeverActiveAppList) {
		this.installedNeverActiveAppList = installedNeverActiveAppList;
	}

	public String getFilterConvertedAd() {
		return filterConvertedAd;
	}

	public void setFilterConvertedAd(String filterConvertedAd) {
		this.filterConvertedAd = filterConvertedAd;
	}

	public Integer getAppUninstallDays() {
		return appUninstallDays;
	}

	public void setAppUninstallDays(Integer appUninstallDays) {
		this.appUninstallDays = appUninstallDays;
	}

	public Integer getPortraitStatus() {
		return portraitStatus;
	}

	public void setPortraitStatus(Integer portraitStatus) {
		this.portraitStatus = portraitStatus;
	}

	public Integer getPortraitUpdateTime() {
		return portraitUpdateTime;
	}

	public void setPortraitUpdateTime(Integer portraitUpdateTime) {
		this.portraitUpdateTime = portraitUpdateTime;
	}

	public String getUnionMediaFlag() {
		return unionMediaFlag;
	}

	public void setUnionMediaFlag(String unionMediaFlag) {
		this.unionMediaFlag = unionMediaFlag;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getPlanId() {
		return planId;
	}

	public void setPlanId(Long planId) {
		this.planId = planId;
	}

	public Integer getChnId() {
		return chnId;
	}

	public void setChnId(Integer chnId) {
		this.chnId = chnId;
	}

	public Integer getRecommendStatusType() {
		return recommendStatusType;
	}

	public void setRecommendStatusType(Integer recommendStatusType) {
		this.recommendStatusType = recommendStatusType;
	}

	public String getResultTagIds() {
		return resultTagIds;
	}

	public void setResultTagIds(String resultTagIds) {
		this.resultTagIds = resultTagIds;
	}

	public Integer getRecommendType() {
		return recommendType;
	}

	public void setRecommendType(Integer recommendType) {
		this.recommendType = recommendType;
	}

	public Long getRecommendId() {
		return recommendId;
	}

	public void setRecommendId(Long recommendId) {
		this.recommendId = recommendId;
	}

	public String getAppActiveAndRecType() {
		return appActiveAndRecType;
	}

	public void setAppActiveAndRecType(String appActiveAndRecType) {
		this.appActiveAndRecType = appActiveAndRecType;
	}

	public String getAppNotActiveAndRecType() {
		return appNotActiveAndRecType;
	}

	public void setAppNotActiveAndRecType(String appNotActiveAndRecType) {
		this.appNotActiveAndRecType = appNotActiveAndRecType;
	}
}
