package com.omni.ads.model.adstarget;

import com.omni.ads.model.adsgroup.ValidationGroup;
import javax.validation.constraints.Pattern;
import java.io.Serializable;

/**
 * @author 80244667
 * @date 2019/6/18 10:45
 */
public class AdsUAppQueryForm implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     *
     */
    private Integer showType;
    /**
     * 应用名称
     */
    private String appName;
    /**
     * 媒体平台
     */
    private Integer mediaPlatform;
    /**
     * appId
     */
    @Pattern(groups = { ValidationGroup.Find.class}, regexp = "^\\d+(,\\d+)*|^(([A-Za-z0-9])+:[0-9])(,([A-Za-z0-9])+:[0-9])*|(^$)")
    private String appIds;
    /**
     * 是否仅查询已选中项
     */
    private boolean onlySelected;

    /**
     * 推广目的(1:H5,2:APP,3：快应用)
     */
    private Integer extensionType;

    /**
     *流量场景(2:精选推荐,3:安装有礼,4:开机必备,5:搜索,6:信息流,7:banner,8:开屏,9:插屏,10:原生，11：激励视屏）
     */
    private Integer flowScene;

    /**
     * 分页查找，页数
     */
    private Integer page;

    /**
     * 分页查找，行数
     */
    private Integer rows;


    public Integer getShowType() {
        return showType;
    }

    public void setShowType(Integer showType) {
        this.showType = showType;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Integer getMediaPlatform() {
        return mediaPlatform;
    }

    public void setMediaPlatform(Integer mediaPlatform) {
        this.mediaPlatform = mediaPlatform;
    }

    public String getAppIds() {
        return appIds;
    }

    public void setAppIds(String appIds) {
        this.appIds = appIds;
    }

    public boolean isOnlySelected() {
        return onlySelected;
    }

    public void setOnlySelected(boolean onlySelected) {
        this.onlySelected = onlySelected;
    }

    public Integer getExtensionType() {
        return extensionType;
    }

    public void setExtensionType(Integer extensionType) {
        this.extensionType = extensionType;
    }

    public Integer getFlowScene() {
        return flowScene;
    }

    public void setFlowScene(Integer flowScene) {
        this.flowScene = flowScene;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getRows() {
        return rows;
    }

    public void setRows(Integer rows) {
        this.rows = rows;
    }
}
