package com.omni.ads.model.adstarget;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TargetMgeConfig implements Serializable {
    private static final long serialVersionUID = 3095963870359849596L;
    private Integer limitCount;
    private Map<String, Integer> proValueCountLimit;
    private Map<String, String> proRegexRules;
    private List<MultualexConf> mutualexPros;
    private boolean appInstallMutualexSwitch;
    private Integer lookalikeAudienceMinLimit = 1000;
    private Integer appActiveDayMaxLimit = 365;

    public TargetMgeConfig() {
    }

    public Integer getLimitCount() {
        return this.limitCount;
    }

    public Map<String, Integer> getProValueCountLimit() {
        return this.proValueCountLimit;
    }

    public Map<String, String> getProRegexRules() {
        return this.proRegexRules;
    }

    public List<TargetMgeConfig.MultualexConf> getMutualexPros() {
        return this.mutualexPros;
    }

    public boolean isAppInstallMutualexSwitch() {
        return this.appInstallMutualexSwitch;
    }

    public Integer getLookalikeAudienceMinLimit() {
        return this.lookalikeAudienceMinLimit;
    }

    public Integer getAppActiveDayMaxLimit() {
        return this.appActiveDayMaxLimit;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    public void setProValueCountLimit(Map<String, Integer> proValueCountLimit) {
        this.proValueCountLimit = proValueCountLimit;
    }

    public void setProRegexRules(Map<String, String> proRegexRules) {
        this.proRegexRules = proRegexRules;
    }

    public void setMutualexPros(List<TargetMgeConfig.MultualexConf> mutualexPros) {
        this.mutualexPros = mutualexPros;
    }

    public void setAppInstallMutualexSwitch(boolean appInstallMutualexSwitch) {
        this.appInstallMutualexSwitch = appInstallMutualexSwitch;
    }

    public void setLookalikeAudienceMinLimit(Integer lookalikeAudienceMinLimit) {
        this.lookalikeAudienceMinLimit = lookalikeAudienceMinLimit;
    }

    public void setAppActiveDayMaxLimit(Integer appActiveDayMaxLimit) {
        this.appActiveDayMaxLimit = appActiveDayMaxLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof TargetMgeConfig)) {
            return false;
        } else {
            TargetMgeConfig other = (TargetMgeConfig)o;
            if (!other.canEqual(this)) {
                return false;
            } else {
                label87: {
                    Object this$limitCount = this.getLimitCount();
                    Object other$limitCount = other.getLimitCount();
                    if (this$limitCount == null) {
                        if (other$limitCount == null) {
                            break label87;
                        }
                    } else if (this$limitCount.equals(other$limitCount)) {
                        break label87;
                    }

                    return false;
                }

                Object this$proValueCountLimit = this.getProValueCountLimit();
                Object other$proValueCountLimit = other.getProValueCountLimit();
                if (this$proValueCountLimit == null) {
                    if (other$proValueCountLimit != null) {
                        return false;
                    }
                } else if (!this$proValueCountLimit.equals(other$proValueCountLimit)) {
                    return false;
                }

                label73: {
                    Object this$proRegexRules = this.getProRegexRules();
                    Object other$proRegexRules = other.getProRegexRules();
                    if (this$proRegexRules == null) {
                        if (other$proRegexRules == null) {
                            break label73;
                        }
                    } else if (this$proRegexRules.equals(other$proRegexRules)) {
                        break label73;
                    }

                    return false;
                }

                Object this$mutualexPros = this.getMutualexPros();
                Object other$mutualexPros = other.getMutualexPros();
                if (this$mutualexPros == null) {
                    if (other$mutualexPros != null) {
                        return false;
                    }
                } else if (!this$mutualexPros.equals(other$mutualexPros)) {
                    return false;
                }

                if (this.isAppInstallMutualexSwitch() != other.isAppInstallMutualexSwitch()) {
                    return false;
                } else {
                    Object this$lookalikeAudienceMinLimit = this.getLookalikeAudienceMinLimit();
                    Object other$lookalikeAudienceMinLimit = other.getLookalikeAudienceMinLimit();
                    if (this$lookalikeAudienceMinLimit == null) {
                        if (other$lookalikeAudienceMinLimit != null) {
                            return false;
                        }
                    } else if (!this$lookalikeAudienceMinLimit.equals(other$lookalikeAudienceMinLimit)) {
                        return false;
                    }

                    Object this$appActiveDayMaxLimit = this.getAppActiveDayMaxLimit();
                    Object other$appActiveDayMaxLimit = other.getAppActiveDayMaxLimit();
                    if (this$appActiveDayMaxLimit == null) {
                        if (other$appActiveDayMaxLimit != null) {
                            return false;
                        }
                    } else if (!this$appActiveDayMaxLimit.equals(other$appActiveDayMaxLimit)) {
                        return false;
                    }

                    return true;
                }
            }
        }
    }

    protected boolean canEqual(Object other) {
        return other instanceof TargetMgeConfig;
    }

    public String toString() {
        return "TargetMgeConfig(limitCount=" + this.getLimitCount() + ", proValueCountLimit=" + this.getProValueCountLimit() + ", proRegexRules=" + this.getProRegexRules() + ", mutualexPros=" + this.getMutualexPros() + ", appInstallMutualexSwitch=" + this.isAppInstallMutualexSwitch() + ", lookalikeAudienceMinLimit=" + this.getLookalikeAudienceMinLimit() + ", appActiveDayMaxLimit=" + this.getAppActiveDayMaxLimit() + ")";
    }

    public static class MultualexConf implements Serializable {
        private static final long serialVersionUID = 6487734083075202459L;
        private int pro;
        private int exPro;
        private int secExPro;
        private String msg;
        private Set<Integer> mutualExDims;

        public MultualexConf() {
        }

        public int getPro() {
            return this.pro;
        }

        public int getExPro() {
            return this.exPro;
        }

        public int getSecExPro() {
            return this.secExPro;
        }

        public String getMsg() {
            return this.msg;
        }

        public Set<Integer> getMutualExDims() {
            return this.mutualExDims;
        }

        public void setPro(int pro) {
            this.pro = pro;
        }

        public void setExPro(int exPro) {
            this.exPro = exPro;
        }

        public void setSecExPro(int secExPro) {
            this.secExPro = secExPro;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void setMutualExDims(Set<Integer> mutualExDims) {
            this.mutualExDims = mutualExDims;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            } else if (!(o instanceof TargetMgeConfig.MultualexConf)) {
                return false;
            } else {
                TargetMgeConfig.MultualexConf other = (TargetMgeConfig.MultualexConf)o;
                if (!other.canEqual(this)) {
                    return false;
                } else if (this.getPro() != other.getPro()) {
                    return false;
                } else if (this.getExPro() != other.getExPro()) {
                    return false;
                } else if (this.getSecExPro() != other.getSecExPro()) {
                    return false;
                } else {
                    Object this$msg = this.getMsg();
                    Object other$msg = other.getMsg();
                    if (this$msg == null) {
                        if (other$msg != null) {
                            return false;
                        }
                    } else if (!this$msg.equals(other$msg)) {
                        return false;
                    }

                    Object this$mutualExDims = this.getMutualExDims();
                    Object other$mutualExDims = other.getMutualExDims();
                    if (this$mutualExDims == null) {
                        if (other$mutualExDims != null) {
                            return false;
                        }
                    } else if (!this$mutualExDims.equals(other$mutualExDims)) {
                        return false;
                    }

                    return true;
                }
            }
        }

        protected boolean canEqual(Object other) {
            return other instanceof TargetMgeConfig.MultualexConf;
        }

        public String toString() {
            return "TargetMgeConfig.MultualexConf(pro=" + this.getPro() + ", exPro=" + this.getExPro() + ", secExPro=" + this.getSecExPro() + ", msg=" + this.getMsg() + ", mutualExDims=" + this.getMutualExDims() + ")";
        }
    }

}
