package com.omni.ads.model.material;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Set;

public class AdsAdMaterialForm implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 素材id
     * @ignore
     */
    private Long id;
    /**
     * 素材id集合,字段名称ids,逗号分隔
     * @demo 1,2,3
     */
    private Set<Integer> ids;
    /**
     * 类型: 1:图片 2:视频
     * @demo 1
     */
    private Integer type;
    /**
     * 页号，从1开始
     * @demo 1
     */
    @NotNull(message = "页号不能为空")
    private Integer pageNum;
    /**
     * 页容量，取值[1,500]
     * @demo 10
     */
    @NotNull(message = "页容量不能为空")
    private Integer pageSize;

    public AdsAdMaterialForm() {
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Set<Integer> getIds() {
        return ids;
    }

    public void setIds(Set<Integer> ids) {
        this.ids = ids;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public String toString() {
        return "AdsAdMaterialForm{" +
                "id=" + id +
                ", ids=" + ids +
                ", type=" + type +
                ", pageNum=" + pageNum +
                ", pageSize=" + pageSize +
                '}';
    }
}
