package com.omni.ads.model.material;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.omni.ads.model.adsconfig.ApiErrorStruct;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AdsCreativeMaterialResponse implements Serializable {
    @SerializedName("code")
    private Long code = null;

    @SerializedName("msg")
    private String message = null;

    @SerializedName("message_cn")
    private String messageCn = null;

    @SerializedName("errors")
    private List<ApiErrorStruct> errors = null;

    @SerializedName("data")
    private Object data = null;

    public AdsCreativeMaterialResponse code(Long code) {
        this.code = code;
        return this;
    }

    /**
     * Get code
     *
     * @return code
     */
    @ApiModelProperty(value = "")
    public Long getCode() {
        return code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public AdsCreativeMaterialResponse message(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get message
     *
     * @return message
     */
    @ApiModelProperty(value = "")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public AdsCreativeMaterialResponse messageCn(String messageCn) {
        this.messageCn = messageCn;
        return this;
    }

    /**
     * Get messageCn
     *
     * @return messageCn
     */
    @ApiModelProperty(value = "")
    public String getMessageCn() {
        return messageCn;
    }

    public void setMessageCn(String messageCn) {
        this.messageCn = messageCn;
    }

    public AdsCreativeMaterialResponse errors(List<ApiErrorStruct> errors) {
        this.errors = errors;
        return this;
    }

    public AdsCreativeMaterialResponse addErrorsItem(ApiErrorStruct errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<ApiErrorStruct>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    /**
     * Get errors
     *
     * @return errors
     */
    @ApiModelProperty(value = "")
    public List<ApiErrorStruct> getErrors() {
        return errors;
    }

    public void setErrors(List<ApiErrorStruct> errors) {
        this.errors = errors;
    }

    public AdsCreativeMaterialResponse data(Object data) {
        this.data = data;
        return this;
    }

    /**
     * Get data
     *
     * @return data
     */
    @ApiModelProperty(value = "")
    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AdsCreativeMaterialResponse adsUpdateResponse = (AdsCreativeMaterialResponse) o;
        return Objects.equals(this.code, adsUpdateResponse.code)
                && Objects.equals(this.message, adsUpdateResponse.message)
                && Objects.equals(this.messageCn, adsUpdateResponse.messageCn)
                && Objects.equals(this.errors, adsUpdateResponse.errors)
                && Objects.equals(this.data, adsUpdateResponse.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, message, messageCn, errors, data);
    }

    @Override
    public String toString() {
        Gson gson = new Gson();
        return gson.toJson(this);
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
