package com.omni.ads.model.material;


import java.io.Serializable;

/**
 * @author wushibo 80082900
 * @Description: 中间页模板
 * @since 2018年7月13日 下午4:53:40
 */
public class AdsH5TemplateVo implements Serializable {

    private static final long serialVersionUID = 13097206908913621L;

    /**
     * 模板ID
     */
    private Integer h5Id;
    /**
     * 模板名称
     */
    private String h5Name;
    /**
     * 业务ID
     */
    private Integer bizId;
    /**
     * 业务内部广告来源
     * <p>
     * contract
     * feeds
     * general
     * oppo_adx
     * oppo_cpd
     * union_advert
     */
    private String bizAdSource;
    /**
     * 模板地址
     */
    private String h5Url;
    /**
     * 模板demo地址
     */
    private String demoUrl;
    /**
     * 扩展字段
     */
    private String ext;
    /**
     * 新增时间
     */
    private Long insertTime;
    /**
     * 更新时间
     */
    private Long updateTime;
    /**
     * 删除标识
     * 0:正常
     * 1:删除
     */
    private Integer delFlag;

    public Integer getH5Id() {
        return h5Id;
    }

    public void setH5Id(Integer h5Id) {
        this.h5Id = h5Id;
    }

    public String getH5Name() {
        return h5Name;
    }

    public void setH5Name(String h5Name) {
        this.h5Name = h5Name;
    }

    public Integer getBizId() {
        return bizId;
    }

    public void setBizId(Integer bizId) {
        this.bizId = bizId;
    }

    public String getBizAdSource() {
        return bizAdSource;
    }

    public void setBizAdSource(String bizAdSource) {
        this.bizAdSource = bizAdSource;
    }

    public String getH5Url() {
        return h5Url;
    }

    public void setH5Url(String h5Url) {
        this.h5Url = h5Url;
    }

    public String getDemoUrl() {
        return demoUrl;
    }

    public void setDemoUrl(String demoUrl) {
        this.demoUrl = demoUrl;
    }

    public String getExt() {
        return ext;
    }

    public void setExt(String ext) {
        this.ext = ext;
    }

    public Long getInsertTime() {
        return insertTime;
    }

    public void setInsertTime(Long insertTime) {
        this.insertTime = insertTime;
    }

    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }

    @Override
    public String toString() {
        return "AdsH5TemplateVo [h5Id=" + h5Id + ", h5Name=" + h5Name + ", bizId=" + bizId + ", bizAdSource="
                + bizAdSource + ", h5Url=" + h5Url + ", demoUrl=" + demoUrl + ", ext=" + ext + ", insertTime="
                + insertTime + ", updateTime=" + updateTime + ", delFlag=" + delFlag + "]";
    }

    public static AdsH5TemplateVo convertBo2Vo(AdsH5Template bo) {
        AdsH5TemplateVo vo = new AdsH5TemplateVo();
        vo.setH5Id(bo.getTid());
        vo.setH5Name(bo.getTname());
        vo.setH5Url(bo.getUrl());
        vo.setBizId(bo.getBizId());
        vo.setBizAdSource(bo.getBizAdSource());
        vo.setDemoUrl(bo.getDemoUrl());
        vo.setDelFlag(bo.getDelFlag());
        return vo;
    }
}
