package com.omni.ads.model.material;

import com.google.common.base.Optional;
import com.omni.ads.model.material.vo.*;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;

/**
 * @author 80204975
 * @date 2018/8/11 11:44
 */
public class AdsShowTypeVo extends AdsShowTypeBO implements Serializable {
    private static final long serialVersionUID = 1L;
    private String chnName; // 渠道名称
    private String bizName; // 业务名称

    public static AdsShowTypeVo buildFromVo(AdsShowTypeBO showTypeBO) {
        if (showTypeBO == null) {
            return null;
        }
        AdsShowTypeVo vo = new AdsShowTypeVo();
        try {
            BeanUtils.copyProperties(vo, showTypeBO);
            vo.setChnName(ChannelEnum.getDesc(Optional.fromNullable(vo.getChnId()).or(0)));
            vo.setBizName(BizEnum.getDesc(Optional.fromNullable(vo.getBizId()).or(0)));
        } catch (Exception e) {
            throw new ServiceException(ErrCodeV2.CommunalErrCode.ERR_CODE_COPY_SHOW_TYPE);
        }
        return vo;
    }

    public String getChnName() {
        return chnName;
    }

    public void setChnName(String chnName) {
        this.chnName = chnName;
    }

    public String getBizName() {
        return bizName;
    }

    public void setBizName(String bizName) {
        this.bizName = bizName;
    }
}
