package com.omni.ads.model.material;


import java.io.Serializable;

public class AdsV3H5TemplateForm implements Serializable {

    private static final long serialVersionUID = 13097206908913621L;

    /**
     * 推广流量
     * 推广流量为“全流量场景”时，会忽略流量场景
     * <p>
     * 1.全流量场景
     * 2.自有流量
     * 3.联盟流量
     *
     */
    private Integer extensionFlow;
    /**
     * 流量场景
     * 推广流量不是“全流量场景”时生效，不能为空
     * <p>
     * 1.全流量场景
     * 2.精选推广
     * 3.安装有礼
     * 4.开机必备
     * 5.搜索
     * 6.信息流
     * 7.banner
     * 8.开屏
     * 9.插屏
     * 10.原生
     * 11.激励视频
     * 12.通投类型
     * 20.品牌
     *
     */
    private Integer flowScene;

    /**
     * 模板ID
     * <p>
     * 需要加extensionFlow、flowScene同时筛选
     */
    private Integer tid;

    public Integer getExtensionFlow() {
        return extensionFlow;
    }

    public void setExtensionFlow(Integer extensionFlow) {
        this.extensionFlow = extensionFlow;
    }

    public Integer getFlowScene() {
        return flowScene;
    }

    public void setFlowScene(Integer flowScene) {
        this.flowScene = flowScene;
    }

    public Integer getTid() {
        return tid;
    }

    public void setTid(Integer tid) {
        this.tid = tid;
    }

    @Override
    public String toString() {
        return "AdsV3H5TemplateForm{" +
                "extensionFlow=" + extensionFlow +
                ", flowScene=" + flowScene +
                ", tid=" + tid +
                '}';
    }
}
