package com.omni.ads.model.material.vo;
/**
 * 渠道枚舉值常量
 * */
public enum BizEnum {
    CPD(ConstantsV2.BizType.BIZ_CPD, "应用分发"),
    FEEDS(ConstantsV2.BizType.BIZ_FEEDS, "信息流"),
    CONTRACT(ConstantsV2.BizType.BIZ_CONTRACT, "合约广告"),
    ACTIVITY(ConstantsV2.BizType.BIZ_ACTIVITY, "招商活动"),
    SMS(ConstantsV2.BizType.BIZ_SMS, "智能短信"),
    UNION(ConstantsV2.BizType.BIZ_UNION, "联盟广告"),
    SEARCH(ConstantsV2.BizType.BIZ_SEARCH, "搜索广告"),
    BIZ_COMMON(ConstantsV2.BizType.BIZ_COMMON, "公共类型");

    private int value;
    private String desc;

    BizEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (BizEnum channel : BizEnum.values()) {
            if (channel.getValue() == value) {
                return channel.getDesc();
            }
        }
        return "";
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
