package com.omni.ads.model.material.vo;
/**
 * 渠道枚举值常量
 * */
public enum ChannelEnum {
    MARKET(ConstantsV2.ChannelType.CHANNEL_TYPE_MARKET, "软件商店"),
    NOT_MARKET(ConstantsV2.ChannelType.CHANNEL_TYPE_NOT_MARKET, "非软件商店"),
    UNION(ConstantsV2.ChannelType.CHANNEL_TYPE_UNION, "联盟");
    private int value;
    private String desc;

    ChannelEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (ChannelEnum channel : ChannelEnum.values()) {
            if (channel.getValue() == value) {
                return channel.getDesc();
            }
        }
        return "";
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
