package com.omni.ads.model.material.vo;

public interface ConstantsV2 {

    /**
     * 最大日限额
     */
    long MAX_DAY_PLAN_DAY_BUDGET = 13141512654L;
    long MAX_DAY_PLAN_INPUT_BUDGET = 999999999999L;

    /**
     * 推广渠道
     */
    interface ChannelType {
        int CHANNEL_TYPE_MARKET = 1;// 1:软件商店
        int CHANNEL_TYPE_NOT_MARKET = 2;// 2:非软件商店
        int CHANNEL_TYPE_UNION = 3;// 3:联盟
    }

    /**
     * 推广类型
     */
    interface ExtensionType {
        int EXTS_TYPE_LINK = 1;             // 1.链接推广
        int EXTS_TYPE_APP = 2;              // 2.应用推广
        int EXTS_TYPE_INSTANT = 3;          // 3.快应用
        int EXTS_TYPE_BRAND_TOPIC = 4;     // 4.品牌专题
        int EXTS_TYPE_THIRD_PARTY_APP = 5; // 5.第三方应用
        int EXTS_TYPE_LINK_APP = 6;         // 6.应用链接推广
        int EXTS_TYPE_WECHAT_APPLET = 7;   // 7.微信小程序
        String EXTS_TYPE_LINK_NAME = "链接推广";
        String EXTS_TYPE_APP_NAME = "应用推广";
        String EXTS_TYPE_INSTANT_NAME = "快应用";
        String EXTS_TYPE_BRAND_TOPIC_NAME = "品牌专题";
        String EXTS_TYPE_THIRD_PARTY_APP_NAME = "第三方应用";
        String EXTS_TYPE_LINK_APP_NAME = "应用链接推广";
        String EXTS_TYPE_WECHAT_APPLET_NAME = "微信小程序";
    }

    /**
     * 标的物类型
     */
    interface TargetType {
        int EXTS_TYPE_LINK = 1;// 1:链接推广
        int EXTS_TYPE_APP = 2;// 2:应用推广
        int EXTS_TYPE_INSTANT_APP = 3;// 3:快应用
        int EXTS_TYPE_SHOPPING = 4 ;//4:电商
    }

    /**
     * 推广样式
     */
    interface ShowType {
        int SHOW_TYPE_BANNER = 1; // 1:banner
        int SHOW_TYPE_POP_WINDOW = 2; // 2:插屏
        int SHOW_TYPE_SPLASH_SCREEN = 4; // 4:开屏
        int SHOW_TYPE_UNION_RAW = 8; // 8:原生(联盟）
        int SHOW_TYPE_FEEDS = 16; // 16:信息流
        int SHOW_TYPE_SEARCH = 32; // 32:搜索直达(搜索推广)
        int SHOW_TYPE_VIDEO = 64; // 64:视频
        int SHOW_TYPE_CPD = 128; // 128:分发推广
        int SHOW_TYPE_FEED_BANNER = 256; // 256信息流banner位定义
        int SHOW_TYPE_SEARCH_CARD = 512;// 512搜索卡片
        int SHOW_TYPE_GENERAL = 1024;// 1024通投类型
        int SHOW_TYPE_BRAND = 333;// 333品牌showType,非位运算支持原因-定向使用333作为品牌的showType区分定向维度权限
    }

    /**
     * 推广规格<br>
     * <1>新版投放端展示的规格<br>
     * <2>此常量为公共常量,不包含各业务已有的规格,各业务需要在规格表中自行映射<br>
     */
    interface AdSpec {
        int AD_SPEC_SELEC_RECM = 1; // 1.精选推荐
        int AD_SPEC_BOOT_NCSS = 2; // 2.开机必备
        int AD_SPEC_INSTALL_GIFT = 3; // 3.安装有礼
        int AD_SPEC_SEARCH_LIST = 4; // 4.搜索列表
        int AD_SPEC_LARGE_PIC = 5; // 5.大图广告
        int AD_SPEC_SMALL_PIC = 6; // 6.小图广告
        int AD_SPEC_GROUP_PIC = 7; // 7.组图广告
        int AD_SPEC_VIDEO = 8; // 8.视频广告
        int AD_SPEC_UNION_ICON = 9; // 9.联盟图标
        int AD_SPEC_UNION_PIC = 10; // 10.联盟图片
        /**
         * 搜索卡片 , 列表图标
         */
        int AD_SPEC_SEARCH_IMG_TEXT = 11;
        /**
         * 搜索卡片 , 多图轮播
         */
        int AD_SPEC_SEARCH_MUL_IMG = 12;

        /**
         * 搜索卡片 , 三图
         */
        int AD_SPEC_SEARCH_3_IMG = 13;

        /**
         * 搜索卡片 , 一图一文
         */
        int AD_SPEC_SEARCH_SINGLE_IMG = 14;

        /**
         * APP搜索 , 大图
         */
        int AD_SPEC_SEARCH_APP_BIG_IMG = 15;

        /**
         * APP搜索 , 两图
         */
        int AD_SPEC_SEARCH_APP_TWO_IMG = 16;

        /**
         * APP搜索 , 三图
         */
        int AD_SPEC_SEARCH_APP_THREE_IMG = 17;

        /**
         * 搜索卡片，一图
         */
        int AD_SPEC_SEARCH_1_IMG = 18;

        /**
         * 竖版视频
         */
        int AD_SPEC_VERTICAL_VIDEO = 19;

        /**
         * 竖版大图
         */
        int AD_SPEC_VERTICAL_IMG = 20;
    }

    /**
     * 业务类型
     */
    interface BizType {
        int BIZ_CPD = 1; // cpd广告产品
        int BIZ_FEEDS = 2; // feeds广告
        int BIZ_CONTRACT = 3; // 合约广告
        int BIZ_ACTIVITY = 4; // 招商活动广告
        int BIZ_SMS = 5; // 智能短信广告
        int BIZ_UNION = 6; // 联盟广告
        int BIZ_SEARCH = 7; // 搜索
        int BIZ_ADX = 100; // 外部ADX
        int BIZ_COMMON = 101; // 业务公共类型
        int BIZ_MIX = 102; // 融合
        int BIZ_SHOPPING = 201;//电商
    }

    /**
     * 序列生成服务KEY值常量
     */
    interface SeqGenKey {
        String SEQ_ADS_AD_V2 = "seq_ads_ad_v2"; // 新版投放端广告序列key
        String SEQ_ADS_PLAN_V2 = "seq_ads_plan_v2"; // 新版投放端计划序列key
        String SEQ_ADS_GROUP_V2 = "seq_ads_group_v2"; // 新版投放端广告组key
        String SEQ_ADS_MATERIAL_V2 = "seq_ads_material_v2"; // 新版投放端素材key
        String SEQ_ADS_FEEDS_TPL_V2 = "seq_ads_feeds_tpl_v2"; // 信息流新版模板序列Key
        String SEQ_ADS_IMEI_DOWN = "seq_ads_imei_down"; // IMEI下载提取序列key
        String SEQ_ADS_COMMUNAL_DEFINE_TPL_V2 = "seq_ads_communal_define_tpl_v2"; // 自定义模板序列Key
        String SEQ_ADS_CREATIVE_V2 = "seq_ads_creative_v2"; // 创意
    }

    /**
     * 广告计划,广告组&广告表前缀
     *
     * @author 80166776
     *
     *         2018年6月20日
     */
    interface TableNamePrefix {
        String ADS_AD_FEEDS = "ads_ad_feeds"; // 信息流广告表前缀
        String ADS_AD_GROUP = "ads_ad_group"; // 广告组表前缀
        String ADS_AD_PLAN = "ads_ad_plan"; // 广告计划表前缀
        String ADS_AD_SEARCH = "ads_ad_search"; // 搜索广告表前缀
        String ADS_AD_CPD = "ads_ad_cpd"; // CPD广告表前缀
        String ADS_AD_UNION = "ads_ad_union"; // 联盟广告表前缀
    }

    /**
     * 素材类型常量
     *
     * @author 80166776
     *
     *         2018年6月20日
     */
    interface MaterialType {
        int IMAGE_TYPE = 1;
        int VIDEO_TYPE = 2;
        int INTERACT_TYPE = 4;
    }

    /**
     * 素材状态 [0:未生效 1:生效中 2:已删除]
     */
    interface MaterialStatus {

        int INIT = 0; // 初始化 （未生效）

        int ONLINE = 1; // 上架

        int DELETE = 2; // 已删除
    }

    /**
     * 广告扣费类型
     */
    interface AD_CHARGE_TYPE {
        int AD_UNCHARGE = 0; // 不扣费广告
        int AD_CHARGE = 11; // 扣费广告
    }

    /**
     * 审核状态
     */
    interface AUDIT_STATUS {
        int NOT_AUDIT = 0; // 待审核
        int AUDIT_PASS = 1; // 审核通过
        int AUDIT_FAIL = 2; // 审核失败
        int AUDIT_REEDIT = 3; // 重新编辑待审核
    }

    /**
     * V2ID初始值常量.
     *
     * @author 80166776
     *
     *         2018年6月28日
     */
    interface V2_ID_INIT_VALUE {
        long AD_ID = 101000000;// 广告ID初始值
        long PLAN_ID = 101000000;// 计划ID初始值 新
        long OLD_PLAN_ID = 10000000; // v2 旧有广告id
        long FEEDS_TPL_ID = 10000000;// 信息流模板初始值
    }

    /**
     * 账户相关行为
     */
    interface ACC_ACTION {
        int ACC_RECHARGE = 0; // 充值
        int ACC_BUDGET_CHANGE = 1; // 账户预算调整
        int ACC_REMIT = 2; // 账户划账
        int ACC_UNLOCK = 3; //锁定金额解锁
    }


    /**
     * 广告管理相关常量.
     *
     * @author 80166776
     *
     *         2018年7月4日
     */
    interface AdManageConst {
        /** 复制广告木人的审核用户 **/
        String REPLICATE_AD_AUDIT_AUTHOR = "系统";
    }

    /**
     * 消息订阅-消息类型
     *
     * @author 80223788
     *
     */
    interface MSG_TYPE {
        int MSG_NOT_SURFFICIENT = 1; // 余额不足
        int MSG_RECHARGE = 2; // 充值
        int MSG_OUT_BEDGET = 3; // 账户日预算
        int MSG_PLAN = 4; // 计划推广
        int MSG_PLAN_GROUP = 5; // 广告组推广
        int MSG_AD = 6; // 广告推广
        int MSG_AD_AUDIT = 7; // 广告审核
        int MSG_CONTRACT_AUDIT = 8; // 合同审核
        int MSG_SYSTEM_NOTIFY = 9; // 系统通知
        int MSG_REMIT = 10; // 划账
        int MSG_BALANCE_LESS_THAN = 11; // 余额地域阈值提醒
        int MSG_SUB_ACC_AUDIT = 12; // 子客户审核提醒
        int MSG_DARVIN_PAGE_AUDIT = 13;	//达尔文电商落地页审核通知
    }

    /**
     * 应用相关常量信息
     */
    interface APP_TYPE {
        /*** 应用等级 ****/
        int LEVEL_ONE = 1; // 除应用分发，其他业务要求的最低等级
        int LEVEL_TWO = 2; // 应用分发要求的应用最低等级
        /** 应用状态常量 **/
        int STATUS_INIT = 0; // 应用初始化
        int STATUS_ONLINE = 1; // 应用上架
        int STATUS_OFFLINE = 2; // 应用下架
        int STATUS_DELETE = 10; // 应用删除
        /** 应用版本 ****/
        int ACCOUNT_TYPE_NORMAL = 0; // 应用版本正常
        int ACCOUNT_TYPE_WRAP = 1; // 抓包 应用版本过低
    }

    interface UpdateResult {
        int SUCCESS = 0;
        /** 启停次数达到限制 **/
        int TIMES_LIMIT = ErrCodeV2.CommunalErrCode.ERR_CODE_COLLECT_TIMES_LIMIT;
        /** 价格最低最高达到限制 ***/
        int PRICE_LIMIT = ErrCodeV2.CommunalErrCode.ERR_CODE_COLLECT_PRICE_LIMIT;
        /** 价格修改次数达到限制 **/
        int PRICE_TIMES_LIMIT = ErrCodeV2.CommunalErrCode.ERR_CODE_COLLECT_PRICE_TIMES_LIMIT;
        /** 关键词修改次数达到限制 **/
        int KW_TIMES_LIMIT = ErrCodeV2.CommunalErrCode.ERR_CODE_COLLECT_KW_TIMES_LIMIT;
        /** ocpc价格最低最高达到限制 ***/
        int OCPC_PRICE_LIMIT = ErrCodeV2.CommunalErrCode.ERR_CODE_COLLECT_OCPC_PRICE_LIMIT;
        /** ocpc价格修改次数达到限制 **/
        int OCPC_PRICE_TIMES_LIMIT = ErrCodeV2.CommunalErrCode.ERR_CODE_COLLECT_OCPC_PRICE_TIMES_LIMIT;
        // 深度转化价格次数限制
        int DEEP_OCPC_PRICE_TIMES_LIMIT = ErrCodeV2.CommunalErrCode.ERR_CODE_COLLECT_DEEP_OCPC_PRICE_TIMES_LIMIT;
        // 深度转化价格范围
        int DEEP_OCPC_PRICE_LIMIT = ErrCodeV2.CommunalErrCode.ERR_CODE_COLLECT_DEEP_OCPC_PRICE_LIMIT;
        // 深度转化价格低于转化出价
        int DEEP_OCPC_PRICE_GT_OCPC_PRICE = ErrCodeV2.CommunalErrCode.ERR_CODE_COLLECT_DEEP_OCPC_PRICE_GT_OCPC_PRICE;
        //  广告组价格限制
        int GROUP_PRICE_LIMIT = ErrCodeV2.CommunalErrCode.ERR_CODE_GROUP_PRICE_LIMIT;
        // 广告组ocpc价格限制
        int GROUP_OCPC_PRICE_LIMIT = ErrCodeV2.CommunalErrCode.ERR_CODE_GROUP_OCPC_PRICE_LIMIT;
        // 广告组deepOcpc价格限制
        int GROUP_DEEP_OCPC_PRICE_LIMIT = ErrCodeV2.CommunalErrCode.ERR_CODE_GROUP_DEEP_OCPC_PRICE_LIMIT;
        // 广告组targetROI限制
        int GROUP_TARGET_ROI_LIMIT = ErrCodeV2.CommunalErrCode.ERR_CODE_GROUP_TARGET_ROI_LIMIT;
        // 广告组 深度出价不能低于转化出价
        int GROUP_DEEP_OCPC_GT_OCPC_LIMIT = ErrCodeV2.CommunalErrCode.ERR_CODE_GROUP_GROUP_PRICE_DEEPOCPC_GT_OCPC;
    }

    /**
     * 操作日志-系统触发-默认创建者
     *
     * @author 80223788
     */
    interface DEFAULT_AUTHOR {
        String SYSTEM = "system";
        String CREATOR = "system";
    }

    /**
     * 鉴权相关前缀
     */
    interface AUTH_PREFIX {
        String UNDER_LINE = "_";// 下划线
        String CHN = "chn_"; // 推广渠道前缀
        String SHOW_TYPE = "show_type_"; // 推广样式前缀
        String AD_SPEC = "adSpec_"; // 广告规格前缀
        String TARGET_TYPE = "targetType_"; // 链接推广/应用推广
        String TARGET_IMEI = "target_imei_"; // imei类型的权限
        String ACTION = "action_";// 广告附加规格权限
        String OCPC_TYPE = "ocpcType_";
        String DEX_VIEW = "dexView_";// 中间件权限
        String AUTH_APP_REF = "authAppRef_";	//app归因渠道权限
        String DEEP_OCPC_TYPE = "deepOcpcType_"; //深度转化权限
        String GROUP_PRICE = "groupPrice_"; // 广告组出价
        String AUTO_OPEN = "auto_open"; // 下载并打开
        String L1_GAME_LEVEL = "l1_game_level";
        // 信息流智能扩量
        String FEEDS_SMART_EXPAND = "feeds_smart_expand";
        String SHOW_RTA_RATE = "show_rta_rate";// 展示参竟通过率 - Rta过滤
        String DEEPLINK_OCPX_APPID_VALID = "deepLink_ocpx_appId_validate";// deepLink 校验deepLink白名单
    }

    /**
     * 日志常量，用于日志信息过滤
     */
    interface LogInfo {
        String PLAN_GROUP_LOG = "v2_communal_plan_log:"; // 计划广告组log
        String AD_LOG = "v2_communal_ad_log:";
        String MODEL_VER_LOG = "model_version_log:"; // 机型信息log
        String TASK_LOCK_LOG = "distribute_lock_log:"; // 分布式锁log
        String TEMPLATE_LOG = "communal_template_log:"; // 模板log
        String ACC_MSG_WARN_LOG = "acc_budget_warn:";	//账务消息
        String AD_RECONCILIATION = "v2_communal_ad_reconci_log:";
        String AD_RECONCILIATION_RESULT = "v2_communal_ad_reconci_result_log:";
        String AD_JINS_LOG = "v2_communal_ad_jins_log: ";
        String GROUP_JINS_LOG = "v2_communal_group_jins_log: ";
        String ES_JOB_LOG = "v2_communal_es_job_log: ";
        String STATIC_JOB_LOG = "v2_communal_static_job_log: ";
        String ADS_GROUP_CHANGE_LOG = "ads_group_change_log: ";
        String MATERIAL_RELATION_JINS_LOG = "material_relation_jins_log: ";
        String AD_COLD_BOOT_DYNAMIC_LOG = "ad_cold_boot_dynamic_log: ";
        String SUBMIT_GENERATE_DYNAMIC_TO_NODE_LOG = "submit_generate_dynamic_to_node_log: ";
    }

    /**
     * 导出文件类型
     */
    interface FileType {
        String XLSX = "xlsx";
        String XLS = "xls";
        String CSV = "csv";
    }

    /**
     * 操作类型
     */
    interface OprType {
        Integer INSERT = 1;
        Integer UPDATE = 2;
        Integer DELETE = 3;
        Integer LOGIN = 4;
    }

    /**
     * 虚拟业务类型、广告类型、广告ID
     */
    interface AccConstant {
        int BUDGET_ACCOUNT_BIZ = 3333;
        int BUDGET_ACCOUNT_ADTYPE = 3333;
        int BUDGET_ACCOUNT_ID = 3333;
    }

    /**
     * 账户状态
     */
    interface AccStatus {
        int NORMAL = 0; // 正常
        int BALANCE_LACK = 1; // 余额不足
        int ACC_BUDGET_LACK = 2; // 账户限额已经达到
        int BALANCE_BUDGET_LACK = 3; // 余额和限额都已达到
    }

    interface AdsAdPageType {
        int CUSTOM = 0;	//自定义落地页
        int PAGE_YIYE = 1;	//一叶智能
        int PAGE_YN = 2;	//云脑建站
        int PAGE_DARVIN = 3;	//达尔文建站
        int PAGE_FIREFLY = 4;	//萤火虫建站
        int PAGE_INSTANT = 5;	//快应用建站
        int JS_SDK = 6;	//广告主自建页面 JS SDK
        int H5_API = 7;	//H5 API 回传
        int FEEDS_DIRECT = 8;	//信息流 线索直达
        int PAGE_APP_LANDING = 9;	//商店详情页
        int FIRE_APP_DOWN = 11;	//萤火虫应用模板下载页
        /**
         * 互动落地页
         */
        int INTERACTIVE_PAGE = 12;
    }

    interface AccessCode {
        int EMPTY_RESULT = 1001;
    }

    interface ConfigKey {

        String INNER_DSP_REDIS_SET_SWITCH = "redis.sync.switch";

        String TASK_SET_SWITCH = "ads_access_task_switch";

        String ACCESS_INTI_STANDARD = "ads_access_standard";
    }

    interface RedisKey {

        String ACCESS_CACHE_REFRESH = "communal:access:url:%s";

        String CACHE_TASK_LOCK = "access:biz:tgu:%s";

        @Deprecated
        String ACCESS_REALTIME_MAP_MIN_KEY = "communal:access:min:%s:url:%s:ownerid:%s";

        @Deprecated
        String ACCESS_REALTIME_COUNT_SEC_KEY = "communal:access:sec:url:%s:ownerid:%s";

        @Deprecated
        String ACCESS_REALTIME_COUNT_DAY_KEY = "communal:access:day:url:%s:ownerid:%s";


        /**
         * 每秒的QPS限制
         * cmu:acs:min:{0:web 1:api}:{unixTime/(60*1000)}:{url}:{ownerd}
         */
        String ACCESS_REALTIME_MAP_MIN_KEY_V2 = "cmu:acs:min:%s:%s:%s:%s";

        /**
         * 每天的总数限制
         * cmu:acs:api:day:{0:web 1:api}:{unixTime/(24*60*60*1000)}:{url}:{ownerd}
         */
        String ACCESS_REALTIME_COUNT_DAY_KEY_V2 = "cmu:acs:day:%s:%s:%s:%s";

        String SUCC_CODE = "OK";
    }

    interface RedisConstant {
        Integer ACCESS_KEY_SEC_EXPIRE = 1;

        Integer ACCESS_KEY_DAY_EXPIRE = 86400;

        Integer ACCESS_KEY_INIT = 1;

        Long MINUTE_FACTOR = 60 * 1000L;

        Long SECOND_FACTOR = 1000L;

        Long SECOND_MOD_FACTOR = 60L;

        Long ACCESS_KEY_MIN_EXPIRE = 2 * 60L;

        Long EIGHT_HOUR_MILL = 60 * 60 * 8 * 1000L;

        Long ONE_DAY_MILL = 60 * 60 * 24 * 1000L;

        String INIT_WEB_SECOND = "second";

        String INIT_WEB_DAY = "day";

        String INIT_API_SECOND = "api_second";

        String INIT_API_DAY = "api_day";
    }

    interface AccessMap {

        String ACCESS_MAP_VALUE = "sec:%s:day:%s:apiSec:%s:apiDay:%s";

        String DEFAULT_KEY = "default";

        String FREQ_SPLITTER = ":";

        int SEC_SEQ = 1;

        int DAY_SEQ = 3;

        int SEC_SEQ_API = 5;

        int DAY_SEQ_API = 7;

        int DEFAULT_QPS = 20;

        int DEFAULT_DAY_TOTAL = 5000;
    }

    interface CacheCode {
        Integer URL_NOT_EXIST = 3001;
        Integer CACHE_EXCEPTION = 3002;
    }

    interface AccessConstants {
        Integer BASE_FACTOR = 32;
        Integer MAP_INIT_CAPACITY = 16;
        Integer WEB_ACCESS_TYPE = 1;
        Integer API_ACCESS_MAP = 2;

    }

    interface PermAndFreqCode {
        Integer VALID_REQUEST = 1;
        Integer SECOND_ACCESS_INVALID = 2;
        Integer DAY_ACCESS_INVALID = 3;
        Integer PERMISSION_INVALID = 4;
//		Integer API_SECOND_ACCESS_INVALID = 5;
//		Integer API_DAY_ACCESS_INVALID = 6;
    }

    interface H5Template {//外部标识
        int OUTTER_FLAG_NO = 0;
        int OUTTER_FLAG_YES = 1;
    }

    interface ReconciliationType {
        int ADS_AD_COLLECT_SYNC = 0;	//聚合表对账
    }

    interface ReconciliationStatus {
        int INIT = 0;
        int PROCESSING = 1;
        int DONE = 2;
    }

    interface TableNameConstants {
        String plan = "ads_ad_plan";
        String group = "ads_ad_group";
        String collect = "ads_ad_collect";
        String creative = "ads_ad_creative";
        String owner = "ads_ad_owner";
        String materialMapping = "ads_ad_material_mapping";
    }

    interface SearchConditionConstants {
        int term = 1;
        int idsIn = 2;
        int range = 3;
        int bitAndEqual = 4;
        int bitOrEqual = 5;
        int bitAndLarger = 6;
        int bitOrLarger = 7;
        int match = 8;
        int matchPhase = 9;
        int orSetBiAnd = 10;
        int andOrAnd = 11;
        int wildCard = 12; //只适用于type为keyword的字段
        int startWith = 31; //只适用于type为keyword的字段
        int should = 32;
    }

    /**
     * 是否需要打质量分级标签
     */
    interface REQUIRED_QUALITY_LEVEL {
        Integer REQUIRED_QUALITY_LEVEL = 0; // 需要打质量分级标签(默认)
        Integer NOT_REQUIRED_QUALITY_LEVEL = 2; // 不需要打质量分级标签
    }

    /**
     * 品牌广告送审类型：1-自审查  2-三方流量侧审核
     */
    interface BIZ_CONTRACT_EXAMINATION_TYPE {
        Integer SELF_EXAMINATION = 1;
        Integer UN_SELF_EXAMINATION = 2;
    }

    interface DeleteFlag {
        int ALL = -1; //所有
        int DEL = 1; //已删除
        int UNDEL = 0; //未删除
    }

    interface DataDimension {
        int AD = 1;
        int AD_GROUP = 2;
        int AD_PLAN = 3;
    }

    interface target {
        int IMMUTABLE = 1; // 不可编辑的,没有保存为定向包
        int MUTABLE = 2;   // 可编辑的，保存为定向包的
    }
}
