package com.omni.ads.model.material.vo;
/**
 * V2错误码定义.
 * */
public interface ErrCodeV2 {
    /**
     * 素材相关错误信息,从83000开始
     */
    interface MaterialErrCode {
        int UPLOAD_LACK_OF_SHOWTYPE = 83000; // 上传图片缺少showType参数
        int UPLOAD_LACK_OF_BIZ_SPEC_ID = 83001; // 上传图片缺少biz规格ID
        int ERR_SAVE_MATERIAL = 83002;// 保存素材报错
        int ERR_QRY_PARAM = 83003;// 查询参数错误
        int ERR_BIND_MAPPING = 83004;// 绑定映射关系错误
        int ERR_REMOVE_MAPPING = 83005;// 移除映射关系错误
    }

    /**
     * 元数据相关-124000~124100.
     */
    interface MetaDataErrCode {
        int ERR_INSTANT_NOT_EXIST = 124000; // 快应用不存在int ERR_INSTANT_NOT_EXIST = 124000;
        // // 快应用不存在
        int ERR_INSTANT_INVALID = 124001; // 快应用不合法.
        int ERR_INSTANT_VALID_VERSION_NOT_EXIST = 124002; // 快应用有效版本不存在.
        int ERR_INSTANT_VALID_VERSION_NOT_ONLY_ONE = 124003; // 存在多个有效版本错误.
        int ERR_QUERY_ONLINE_INSTANT_PARAM = 124004; // 在线快应用请求参数错误.
        int ERR_INVALID_INSTANT_URL = 124005;//快应用链接不合法
        int ERR_INSTANT_NOT_ON_SHELF = 124006;//应用已下架
        int ERR_QUERY_ONLINE_INSTANT_INFO = 124007;//查询在线快应用信息错误
        int ERR_INSTANT_NOT_EQUAL_GROUP = 124008; // 快应用应和广告组保持一致
        int ERR_INSTANT_NOT_EQUAL_ID = 124015; // 快应用地址应和ID保持一致

        int INSTANT_NOT_EXIST = 124000;
        int INSTANT_INVALID = 124001;
        int INSTANT_VALID_VERSION_NOT_EXIST = 124002;
        int INSTANT_VALID_VERSION_NOT_ONLY_ONE = 124003;
        int QUERY_ONLINE_INSTANT_PARAM_ERROR = 124004;

        int ERR_DEEPLINK_WHITE_LIST = 124200; // deepLink 不在app映射白名单内
        int ERR_DEEPLINK_MATCH_OCPX_WHITE_LIST = 124201; // 广告图标的应用与应用直达链接的应用不一致，请重新填写
    }

    /**
     * 定向相关错误信息.
     *
     * @author 80166776
     *
     *         2018年6月20日
     */
    interface TargetErrCode {
        // 定向
        int ERR_TARGET_GET_SEQ = 125100;// 获取序列失败
        int ERR_TARGET_ADD = 125101;// 新建定向失败
        int ERR_TARGET_UPDATE = 125102;// 更新定向失败
        int ERR_TARGET_DEL = 125103;// 删除定向失败
        int ERR_TARGET_EXISTED = 125104;// 定向已存在
        int ERR_TARGET_APP_CATE_QRY_ERR = 125105;// 获取定向应用分类错误.
        int ERR_TARGET_INT_TAGS_QRY_ERR = 125106;// 获取定向兴趣标签错误.
        int ERR_TARGET_MGE_CONF_QRY_ERR = 125107;// 获取定向配置错误.
        int ERR_TARGET_MOBILE_QRY_ERR = 125108;// 获取定向机型错误.
        int ERR_TARGET_APP_QRY_ERR = 125109;// 获取APP定向错误.
        int ERR_TARGET_UNION_APP_QRY_ERR = 125110;// 获取联盟APP定向错误.
        int ERR_TARGET_METADATA_QUERY_ERR = 125111;// 获取定向元数据错误.
        int ERR_TARGET_QUERY_PARAM_ERR = 125151;// 请求参数错误.
        int ERR_TARGET_DAO_INIT_ERR = 125152;// 请求请求定向信息错误.
        int ERR_TARGET_QUERY_ERR = 125153;// 请求请求定向错误.
        int ERR_TARGET_IMEI_TYPE_ERR = 125154;// imei 类型不正确.
        int ERR_TARGET_ALIKE_SYNC_LACK = 125155; // 同步lookalike状态缺少参数
        int ERR_TARGET_NOT_EXIST_FOR_ALIKE = 125156; // 根绝alike id查询不到对应的target

        // 定向属性
        int ERR_TARGET_PROPERTY_ADD = 125201;// 新建定向属性失败
        int ERR_TARGET_PROPERTY_UPDATE = 125202;// 更新定向属性失败
        int ERR_TARGET_PROPERTY_INVALID = 125203;// 定向属性校验有误
        int ERR_TARGET_PROPERTY_COUNT_LIMITED = 125204;// 定向属性数量限制制定数量
        int ERR_TARGET_NOT_EXIST = 125205;// 定向属性数量限制制定数量
        int ERR_TARGET_PROPERTY_MUTUAL_EX = 125206;// 定向属性值互斥
        int ERR_ACTIVE_DAYS_INVALID = 125207;// 活跃天数不合法
        int ERR_NOT_ACTIVE_DAYS_INVALID = 125208;// 非活跃天数不合法
        int ERR_IS_NOT_ZIP_FILE = 125209;// imei文件非zip文件.
        int ERR_IMEI_INVALID = 125210;// IMEI不合法.
        int ERR_EMPTY_IMEI_FILE = 125211;// 空imei文件
        int ERR_IMEI_FILE_OVERSIZE = 125212;// imei文件超过大小限制.
        int ERR_IMEI_COUNT_EXCEEDED = 125213;// imei受众包超过50个
        int ERR_IMEI_TODAY_COUNT_EXCEEDED = 125214;// 当天新增imei受众包超过5个
        int ERR_V2_TARGET_NAME_REPEATED = 125215;// 定向包名称重复
        int ERR_V2_DEL_REFERRED_TARGET = 125216;// 删除被引用的定向错误.
        int ERR_V2_DEL_REFERRED_CHILD_TARGET = 125217;// .该人群包存在关联的定向包，无法进行删除
        int ERR_V2_TARGET_NAME_EMPTY = 125218;// 定向包名称不存在
        int ERR_V2_TARGET_DESC_EMPTY = 125219;// 定向包描述不存在
        int ERR_V2_UPDATE_TARGET_NOT_EXIST = 125220;// 更新定向包不存在
        int ERR_V2_LOOKALIKE_SEED_TARGET_NOT_EXIST = 125221;// 种子定向包不存在
        int ERR_V2_LOOKALIKE_SEED_TARGET_NOT_VALID = 125222;// 种子定向包非imei定向
        int ERR_V2_LOOKALIKE_SEED_COUNT_GREATER_THAN_EXPAN_COUNT = 125223;// 种子定向包数量大于扩展包目标数量
        int ERR_V2_LOOKALIKE_NOT_EXPANDED = 125224;// lookalike的imei包未拓展完成.
        int ERR_V2_UNUSABLE_DELETE_TARGET = 125225;// 不能使用已删除定向包.
        int ERR_V2_LOOKALIKE_HDFS_EXT_FILE_NOT_EXIST = 125226;// 拓展完成文件不存在.
        int ERR_V2_LOOKALIKE_HDFS_EXT_TO_NFS_ERROR = 125227;// 拓展文件同步NFS错误.
        int ERR_V2_LOOKALIKE_NFS_TO_HDFS_ERROR = 125228;// 种子文件同步HDFS错误.
        int ERR_V2_LOOKALIKE_TASK_NOT_EXIST = 125229;// 人群拓展任务任务不存在.
        int ERR_V2_LOOKALIKE_SYNC_ERROR = 125230;// 同步lookalike错误.
        int ERR_V2_LOOKALIKE_COUNT_EXCEED = 125231;// lookalike定向包数量不允许超过1000w
        int ERR_V2_LOOKALIKE_DAILY_COUNT_EXCEED = 125232;// 当天lookalike拓展包个数超过限制
        int ERR_V2_TARGET_NOT_EXIST = 125233;// 定向包不存在
        int ERR_DMP_COUNT_EXCEEDED = 125234;// DMP总数超过50个限制
        int ERR_DMP_DEL_EXPANDING_ERROR = 125235;// 拓展中定向包不允许删除.
        int ERR_UPDATE_DELETE_TARGET_ERROR = 125236;// 已经删除定向不允许修改.
        int ERR_REF_IMEI_TARGET_INVALID = 125237;// 引用的imei定向不存在.
    }

    /**
     * 信息流相关错误信息.
     *
     * @author 80166776
     *
     *         2018年6月20日
     */
    interface FeedsErrCode {
        int ERR_QUERY_FEEDS_AD = 170000; // 查询广告错误
        int ERR_PARAM_QUERY_ONE_AD = 170001; // 请求单个广告参数错误
        int ERR_QUERY_FEEDS_AD_LIST = 170002; // 查询广告列表报错
        int ERR_PARAM_QUERY_LIST_AD = 170003; // 请求广告列表参数错误
        int ERR_QUERY_FEEDS_OPEN_AD = 170004; // 查询外部ID广告错误
        int ERR_PARAM_FEEDS_OPEN_AD = 170005; // 查询外部ID广告参数错误
        int ERR_PARAM_QUERY_TPL = 170006; // 查询广告模板参数错误
        int ERR_QUERY_TPL = 170007; // 查询广告模板错误

        /********* 新增广告相关 **********/
        int ERR_ADD_FEEDS_AD = 170008; // 新增广告错误
        int ERR_DUPLICATE_AD_NAME = 170009;// 重复广告名
        int ERR_OVER_MAX_DAILY_INCR_COUNT = 170010;// 超过每天最大增加广告数
        int ERR_OVER_MAX_AD_COUNT = 170011;// 超过最大广告数
        int ERR_DEEP_LINK_NOT_IN_WHITELIST = 170012;// 应用直达链接不在白名单中
        int ERR_PLAN_NOT_EXIST = 170013;// 广告计划不存在
        int ERR_MAIN_GROUP_TARGET_URL_ERROR = 170014;// 组/主图链接有误
        int ERR_MAIN_GROUP_TARGET_URL_NOT_BE_USED = 170015;// 链接推广不允许使用
        // 组/主
        int ERR_GROUP_NOT_EXIST = 170016;// 广告组不存在
        int ERR_LACK_OF_IMAGES_ERROR = 170017; // 缺少图片文件.
        int ERR_LACK_OF_VIDEO_ERROR = 170018; // 缺少视频文件.
        int ERR_MATERIAL_ERROR = 170019; // 添加素材错误.
        int ERR_TEMPLATE_JSON_EMPTY = 170020; // 添加模板数据为空.
        int ERR_TPL_TYPE = 170021; // 错误半自定义类型
        int ERR_GROUP_EMPTY_IMGS = 170022; // 组图模板缺少图片素材
        int ERR_MAIN_EMPTY_IMGS = 170023;// 主图模板缺少图片素材

        /** 复制广告 **/
        int ERR_REPLICATE_MISS_PARAM = 170050;// 缺少参数
        int ERR_REPLICATE_PLAN_NOT_EXIST = 170051;// 复制广告的目标计划不存在
        int ERR_REPLICATE_GROUP_NOT_EXIST = 170052;// 复制广告的目标组不存在
        /*
         * final int ERR_LACK_AD_ID = 100; //缺少广告ID
         *
         * final int ERR_LACK_AD_OWNER_ID = 101; //缺少广告主ID
         */

        /********* 新增cache相关 **********/
        int ERR_CACHE_QUERY_TARGET_ERROR = 170057;
        int ERR_CACHE_REFRESH = 170058;
        int ERR_PAUSE_START_AD_OWNERID_INVALID = 170059;// 暂停广告ownerId不合法
        int ERR_PAUSE_START_UP_AD_ADID_INVALID = 170060;// 暂停广告Id不合法
        int ERR_PAUSE_AD = 170061;// 暂停广告运行时错误
        int ERR_DEL_AD = 170062;// 删除广告运行时错误
        int ERR_DEL_AD_OWNERID_INVALID = 170063;// 删除广告ownerId不合法
        int ERR_DEL_AD_ID_INVALID = 170064;// 删除广告Id不合法
        int ERR_UPDATE_AD_NOT_EXIST = 170065;// 更新的广告不存在
        int ERR_TPL_PLAN_EXT_INVALID = 170066;// 只允许应用推广创建模板广告
        int ERR_PIC_MATERIAL_IS_EMPTY = 170067;// 素材文件为空
        int ERR_VIDEO_MATERIAL_IS_EMPTY = 170068;// 素材文件为空
        int ERR_TPL_BG_MAT_IS_EMPTY = 170069;// 主图模板背景图为空
        int ERR_TPL_BD_MAT_IS_EMPTY = 170070;// 组图模板品牌宣传图为空
        int ERR_TPL_PD_MAT_IS_EMPTY = 170071;// 组图模板商品图为空
        int ERR_PRICE_CHG_EXCEEDED = 170072;// 价格修改次数超过限制
        int ERR_O_PRICE_CHG_EXCEEDED = 170073;// ocpc价格修改次数超过限制
        int ERR_STARTUP_CHG_EXCEEDED = 170074;// 启动暂停修改次数超过限制
        int ERR_OWNER_ID_EMPTY = 170075;// 广告主Id为空
        int ERR_AD_ID_EMPTY = 170076;// 广告Id为空
        int ERR_AD_NOT_EXIST = 170077;// 广告不存在
        int ERR_GROUP_AND_PLAN_MISMATCH = 170078;// 广告计划和组不匹配
        int ERR_DIGITAL_COPYWRITER = 170080;// 文案不能都为数字
        int ERR_OCPC_PLAN_EXT_INVALID = 170081;// 只允许应用推广使用转化出价
        int ERR_TPL_TYPE_INVALID = 170082;// 链接推广使用错误的模板类型
        int ERR_AD_NAME_LEN_INVALID = 170083;// 广告名称长度不合法
        int ERR_REPLICATE_PLAN_EXT_TYPE_MISMATCH = 170084;// 被复制广告与目标计划推广类型不匹配
        int ERR_AUDIT_STATUS_NULL = 170085;// 广告审核状态不合法
        int ERR_BRAND_NAME_IS_NUMBER = 170086; // 广告品牌名称都是数字
        int ERR_CHECK_PLAN_ERROR = 170087;// 检查计划错误
        int ERR_GROUP_MAIN_URL_ERROR = 170088;// 主/组图模板链接错误
        int ERR_GROUP_MAIN_TPL_REUSE = 170089;// 主/组图模板无法复用
        int ERR_REFRESH_CACHE_PG_ABNORMAL = 170090;// 计划/组状态异常,无法刷新cache
        int MULT_REPLICATE = 170091;// 批量复制
        int MULT_DEL = 170092;// 批量删除
        int MULT_STARTUP = 170093;// 批量启动
        int MULT_PAUSE = 170094;// 批量暂停
        int ERR_CHANGE_PRICE = 170095;// 更新价格报错
        int ERR_MAX_CHANGE_PRICE = 170096;// 更新价格超过最大限制
        int ERR_ADD_PERMISSION_DENY = 170097;// 无权限新增广告
        int ERR_SITE_NOT_EXIST = 170098;// 建站不存在
        int ERR_INVALID_OCPC_PRICE = 170099;// oCpc价格不合法.
        int ERR_GROU_SHOW_TYPE_ERROR = 170100;// 广告组推广样式不为信息流.
    }

    /**
     * 公共部分错误码
     */
    interface CommunalErrCode {
        /*** 计划部分 **/
        int ERR_CODE_ADD_PLAN = 120101; // 添加计划出错
        int ERR_CODE_DELETE_PLAN = 120102; // 删除计划出错
        int ERR_CODE_GET_PLAN = 120103; // 查找计划出错
        int ERR_CODE_EDIT_PLAN = 120104; // 编辑计划错误
        int ERR_CODE_PLAN_STATUS = 120105; // 更新计划状态出错
        int ERR_CODE_GET_VALID_PLAN = 120106; // 查找不到有效计划
        int ERR_CODE_PLAN_COPY = 120107; // 复制计划错误
        int ERR_CODE_PLAN_PARAM_ADD = 120108; // 添加计划参数缺失
        int ERR_CODE_PLAN_COUNT_DAO = 120109; // 查询数据库出错
        int ERR_CODE_PLAN_NAME_DUPLICATE = 120110; // 计划名称重复
        int ERR_CODE_PLAN_FIND_ONE_DAO = 120111; // 调用find one dao出错
        int ERR_CODE_PLAN_COUNT_LIMIT = 120112; // 超出广告主所能创建计划数量限制
        int ERR_CODE_PLAN_DUPLICATE_ID = 120113; // 添加账务预算信息出错
        int ERR_CODE_PLAN_QRY_ACC = 120114; // 查询账户余额出错了
        int ERR_CODE_PLAN_ADD_DAO = 120115; // plan add dao出错
        int ERR_CODE_PLAN_PARAM_DELETE = 120116; // 删除计划缺少参数信息
        int ERR_CODE_PLAN_GROUP_DEL_SRV = 120117; // 删除计划对应的广告组信息时出错了
        int ERR_CODE_PLAN_FIND_PARAM = 120118; // 查找计划时缺少参数
        int ERR_CODE_PLAN_LIST_PARAM = 120119; // 查询计划时缺少参数
        int ERR_CODE_PLAN_EDIT_NOT_EXIST = 120120; // 待编辑计划不存在
        int ERR_CODE_PLAN_EDIT_FOR_DAY_BUDGET = 120121; // 已超过单个计划限额修改次数
        int ERR_CODE_PLAN_LIST_DAO = 120122; // 查找多个计划出错
        int ERR_CODE_PLAN_EDIT_CHN = 120123; // 编辑计划时，渠道或推广类型不可修改
        int ERR_CODE_PLAN_EDIT_BUDGET_FOR_OWNER = 120124; // 预算超过广告主下所有计划的修改次数
        int ERR_CODE_PLAN_QRY_ACC_BUDGET = 120125; // 查询账户预算信息出错了
        int ERR_CODE_PLAN_ADD_ACC_BUDGET = 120126; // 添加账户预算信息出错了
        int ERR_CODE_PLAN_UPDATE_PLAN_DAO = 120127; // DAO更新计划信息错误了
        int ERR_CODE_PLAN_UPDATE_STATUS_PARAM = 120128; // 更新计划状态时，缺少参数
        int ERR_CODE_PLAN_START_PAUSE_LIMIT = 120129; // 计划开启关闭次数超过限制
        int ERR_CODE_PLAN_UPDATE_STATUS_DAO = 120130; // 调用DAO更新计划状态DB时，出错
        int ERR_CODE_PLAN_DELETE_MISS = 120131; // 找不到待删除的计划信息
        int ERR_CODE_PLAN_REPORT_ERROR = 120132; // 获取报表出错了
        int ERR_CODE_PLAN_START_LIMIT = 120133; // 计划启动次数限制
        int ERR_CODE_PLAN_BUDGET_TIMES_LIMIT = 120134; // 日预算启动次数限制
        int ERR_CODE_PLAN_IDS_EMPTY = 120135; // 计划id列表不能空
        int ERR_CODE_PLAN_DAY_BUDGET_EXCEED= 120136; // 计划日预算超过最大限额
        int ERR_CODE_V2_PLAN_ADD_OFFLINE= 120137; // 已禁止创建2.0广告计划，请到3.0创建
        int ERR_CODE_V2_PLAN_EDIT_OFFLINE= 120138; // 已禁止编辑2.0广告计划，请到3.0编辑


        /*** 广告组部分 ****/
        int ERR_CODE_ADD_GROUP = 120201; // 添加广告组出错
        int ERR_CODE_DELETE_GROUP = 120202; // 删除广告组错误
        int ERR_CODE_UPDATE_GROUP = 120203; // 更新广告组
        int ERR_CODE_GROUP_DUPLICATE = 120204; // 广告组id重复了
        int ERR_CODE_FIND_GROUP = 120205; // 查找广告组信息出错
        int ERR_CODE_GROUP_COPY = 120206; // 广告组复制出错
        int ERR_CODE_GROUP_UPDATE_STATUS = 120208; // 更新广告组状态出错
        int ERR_CODE_GROUP_QRY_APP_INFO = 120209; // 查询应用信息出错
        int ERR_CODE_GROUP_CHN_SHOW_TYPE = 120210; // 推广渠道和推广类型不符合
        int ERR_CODE_GROUP_ADD_PARAM = 120211; // 添加广告组时参数出错
        int ERR_CODE_GROUP_APP_INFO_ERR = 120212; // 应用状态信息异常
        int ERR_CODE_GROUP_APP_LEVEL_LOW = 120213; // 应用等级过低
        int ERR_CODE_GROUP_PLAN_EXIST = 120214; // 查找不到广告组对应的计划
        int ERR_CODE_GROUP_ADD_DAO = 120215; // 添加广告组到数据库时出错
        int ERR_CODE_GROUP_DUPLICATE_NAME = 120216; // 广告组名称重复了
        int ERR_CODE_GROUP_LIST_DAO = 120217; // 查询广告组数据库出错了
        int ERR_CODE_GROUP_COUNT_DAO = 120218; // 查询广告组数量时出错了
        int ERR_CODE_GROUP_COUNT_LIMIT = 120219; // 广告组数量超出限制
        int ERR_CODE_GROUP_DELETE_PARAM = 120220; // 广告组删除时，参数不合法
        int ERR_CODE_GROUP_VALID_GROUP_INFO = 120221; // 找不到有效的广告组信息
        int ERR_CODE_GROUP_DELETE_DAO = 120222; // 在数据库
        int ERR_CODE_GROUP_FIND_PARAM = 120223; // 查找广告组时缺少参数
        int ERR_CODE_GROUP_FIND_DAO = 120224; // 查询单个广告组数据库出错了
        int ERR_CODE_GROUP_LIST_PARAM = 120225; // 查询多个广告组时，参数不合法
        int ERR_CODE_GROUP_UPDATE_PARAM = 120226; // 广告组更新时，参数不合法
        int ERR_CODE_GROUP_UPDATE_DAO = 120227; // 更新广告组数据库出错了
        int ERR_CODE_GROUP_MOD_TIMES_LIMIT = 120228; // 超出广告组修改次数限制
        int ERR_CODE_GROUP_MOD_LIMIT = 120229; // 推广样式和标的物不可修改
        int ERR_CODE_GROUP_STATUS_DAO = 120230; // 更新广告组状态数据库出错了
        int ERR_CODE_GROUP_SWITCH_LIMIT = 120231; // 广告组开启暂停次数达到限制
        int ERR_CODE_GROUP_EXTENSION_TARGET_ILLEGAL = 120232; // 计划推广类型与广告组推广类型不符合
        int ERR_CODE_GROUP_DAY_ILLEGAL = 120233; // 广告组推广日期不合法
        int ERR_CODE_GROUP_REPORT_ERROR = 120234; // 广告组推广日期不合法
        int ERR_CODE_GROUP_APP_ID_ILLEGAL = 120235; // 无效的应用id信息
        int ERR_CODE_GROUP_START_LIMIT = 120236; // 广告组启动限制
        int ERR_CODE_GROUP_TIME_LIMIT = 120237; // 广告组推广时段修改次数限制
        int ERR_CODE_GROUP_INSTANT_ID_NULL = 120238; // 广告组快应用id不合法
        int ERR_CODE_GROUP_INSTANT_ID_PKG_NOT_MATCH = 120239; // 广告组快应用ID与pkg不匹配
        int ERR_CODE_GROUP_INSTANT_ID_NOT_ONLINE = 120240; // 广告组快应用已下线
        int ERR_CODE_GROUP_INSTANT_INFO_NOT_EXIST = 120241; // 快应用ID无信息
        int ERR_CODE_GROUP_CLOUD_URL_NOT_EXIST = 120242; // 对应的云脑的url不存在
        int ERR_CODE_GROUP_INSTANT_URL_INVALID = 120244;// 快应用链接不合法
        int ERR_CODE_GROUP_INSTANT_CHANNEL_ID_INVALID = 120243;// 频道不支持快应用.
        int ERR_CODE_GROUP_ID_NULL = 120245; // 广告组id不能为空
        int ERR_CODE_GROUP_TARGET_NO_RIGHT = 120246; // 定向权限校验失败
        int ERR_CODE_GROUP_APPREF_NO_RIGHT = 120247; // 广告组app渠道校验失败
        // 广告组出价
        int ERR_CODE_GROUP_PRICE_MOD_TIMES_LIMIT = 120248; // 广告组价格修改次数限制
        int ERR_CODE_GROUP_OCPC_PRICE_MOD_TIMES_LIMIT = 120249; // 广告组ocpc价格修改次数限制
        int ERR_CODE_GROUP_DEEP_OCPC_PRICE_MOD_TIMES_LIMIT = 120250; // 广告组deepOcpc价格修改次数限制

        int ERR_CODE_GROUP_PRICE_LIMIT = 120251; // 广告组价格限制
        int ERR_CODE_GROUP_OCPC_PRICE_LIMIT = 120252; // 广告组ocpc价格限制
        int ERR_CODE_GROUP_DEEP_OCPC_PRICE_LIMIT = 120253; // 广告组deepOcpc价格限制

        int ERR_CODE_GROUP_AUTH_GROUP_PRICE = 120254; // 没有广告组价格修改权限
        int ERR_CODE_GROUP_GROUP_PRICE_NOT_ALLOW = 120255; // 不允许广告组价格修改
        int ERR_CODE_GROUP_GROUP_PRICE_PARAM = 120256; // 广告组出价参数错误
        int ERR_CODE_GROUP_GROUP_PRICE_VALIDATE = 120257; // 广告组出价校验异常
        int ERR_CODE_GROUP_GROUP_PRICE_DEEPOCPC_GT_OCPC = 120258; // 深度出价不能低于转化出价

        int ERR_CODE_GROUP_GROUP_TARGET_ROI_GT_ZERO = 120259; // targetROI 必须大于0
        int ERR_CODE_GROUP_TARGET_ROI_MOD_TIMES_LIMIT = 120260; // 广告组target roi修改次数限制
        int ERR_CODE_GROUP_TARGET_ROI_LIMIT = 120261; // 广告组targetROI限制

        int ERR_CODE_GROUP_INSTANT_APP_ID_NOT_SUPPORT_EDIT = 120262;   // 广告组快应用id不支持修改
        int ERR_CODE_GROUP_AD_SERVING_TYPE_NOT_SUPPORT_EDIT = 120263;   // 广告组投放类型不支持修改
        int ERR_CODE_GROUP_ROI_NOT_SUPPORT_EDIT_PRICE_DEEPOCPC = 120264;   // 广告组为目标ROI不允许修改深度出价

        int ERR_CODE_GROUP_DYNAMIC_PRICE_NOT_ALLOW_EDIT_OCPC_PRICE = 120265; // 广告组动态出价不允许修改转化出价
        int ERR_CODE_GROUP_DYNAMIC_PRICE_NOT_ALLOW_EDIT_DEEP_OCPC_PRICE = 120266; // 广告组动态出价不允许修改深度转化出价

        int ERR_CODE_V2_GROUP_ADD_OFFLINE= 120267; // 已禁止创建2.0广告组，请到3.0创建
        int ERR_CODE_V2_GROUP_EDIT_OFFLINE= 120268; // 已禁止编辑2.0广告组，请到3.0编辑

        int ERR_CODE_V2_GROUP_EDIT_PRICE_SAME_FLOWSCENE= 120268; // 仅相同流量场景支持批量修改
        int ERR_CODE_GROUP_GROUP_PRICE_DEEP_OCPC_VALIDATE = 120269; // 非双出价修改深度出价过滤

        // 广告组出价


        /*** 广告聚合部分 ****/
        int ERR_CODE_COLLECT_LIST = 120301; // 查找聚合广告出错
        int ERR_CODE_COLLECT_COPY = 120302; // 复制广告出错
        int ERR_CODE_COLLECT_REPORT = 120302; // 复制广告出错
        int ERR_CODE_COLLECT_SWITCH_PARAM = 120303; // 开启，暂停暂停广告参数缺失
        int ERR_CODE_COLLECT_DELETE_PARAM = 120304; // 删除广告参数缺失
        int ERR_CODE_COLLECT_PRICE_PARAM = 120305; // 修改广告价格参数缺失
        int ERR_CODE_COLLECT_UPDATE_DAO = 120306; // 更新聚合表出错
        int ERR_CODE_COLLECT_LIST_PARAM = 120307; // 查询广告缺少参数
        int ERR_CODE_COLLECT_LIST_DAO = 120308; // 查找不到有效的广告
        int ERR_CODE_COLLECT_TIMES_LIMIT = 120309; // 广告修改次数达到限制
        int ERR_CODE_COLLECT_PRICE_LIMIT = 120310; // 价格修改不合法
        int ERR_CODE_COLLECT_FEEDS_SWITCH = 120311; // 信息流广告开启暂停出错
        int ERR_CODE_COLLECT_FEEDS_PRICE = 120312; // 信息流广告价格修改出错
        int ERR_CODE_COLLECT_FEEDS_DELETE = 120313; // 信息流广告删除出错
        int ERR_CODE_COLLECT_UNION_SWITCH = 120314; // 联盟广告开启暂停出错
        int ERR_CODE_COLLECT_UNION_PRICE = 120315; // 联盟广告价格修改出错
        int ERR_CODE_COLLECT_UNION_DELETE = 120316; // 联盟广告删除出错
        int ERR_CODE_COLLECT_TIMES_HINT = 120317; // 修改次数提醒
        int ERR_CODE_COLLECT_PRICE_TIMES_LIMIT = 120318; // 价格修改次限制
        int ERR_CODE_COLLECT_KW_TIMES_LIMIT = 120319;// 关键词修改次数限制
        int ERR_CODE_COLLECT_ID_NULL = 120320; // 广告id不能为空
        int ERR_CODE_PRICE_ILLEGAL = 120321; // 广告出价不合法
        int ERR_CODE_PERCENT_ILLEGAL = 120322; // 广告出价百分比不合法
        int ERR_CODE_COLLECT_CPD_SWITCH = 120323; // 分发广告开启暂停出错
        int ERR_CODE_COLLECT_CPD_PRICE = 120324; // 分发广告价格修改出错
        int ERR_CODE_COLLECT_CPD_DELETE = 120325; // 分发广告删除出错
        int ERR_CODE_COLLECT_SEARCH_SWITCH = 120326; // 搜索广告开启暂停出错
        int ERR_CODE_COLLECT_SEARCH_PRICE = 120327; // 搜索广告价格修改出错
        int ERR_CODE_COLLECT_SEARCH_DELETE = 120328; // 搜索广告删除出错
        int ERR_CODE_COLLECT_CPD_OCPC_PRICE = 120329; // 分发广告修改转化目标错误
        int ERR_CODE_COLLECT_SEARCH_OCPC_PRICE = 120330; // 搜索广告修改转化目标错误
        int ERR_CODE_COLLECT_FEEDS_OCPC_PRICE = 120331; // 信息流广告修改转化目标错误
        int ERR_CODE_COLLECT_UNION_OCPC_PRICE = 120332; // 联盟广告修改转化目标错误
        // 编码用完, 231xxx
        int ERR_CODE_COLLECT_CPD_DEEP_OCPC_PRICE = 221001; // 分发广告修改转化目标错误
        int ERR_CODE_COLLECT_SEARCH_DEEP_OCPC_PRICE = 221002; // 搜索广告修改转化目标错误
        int ERR_CODE_COLLECT_FEEDS_DEEP_OCPC_PRICE = 221003; // 信息流广告修改转化目标错误
        int ERR_CODE_COLLECT_UNION_DEEP_OCPC_PRICE = 221004; // 联盟广告修改转化目标错误
        // 当前广告计费类型不是OCPC广告
        int ERR_CODE_COLLECT_NOT_OCPC_AD = 120333;
        // 当前广告计费类型不是DEEPOCPC广告
        int ERR_CODE_COLLECT_NOT_DEEP_OCPC_AD = 120340;

        int ERR_CODE_COLLECT_OCPC_PRICE_LIMIT = 120334;
        int ERR_CODE_COLLECT_OCPC_PRICE_TIMES_LIMIT = 120335;        // 转化价格次数限制
        int ERR_CODE_COLLECT_DEEP_OCPC_PRICE_TIMES_LIMIT = 120336;   // 深度转化价格次数限制
        int ERR_CODE_COLLECT_DEEP_OCPC_PRICE_LIMIT = 120337;         // 深度转化价格范围
        int ERR_CODE_COLLECT_DEEP_OCPC_PRICE_GT_OCPC_PRICE = 120338; // 深度转化价格低于转化出价
        int ERR_CODE_COLLECT_GROUP_PRICE_LIMIT = 120339;		     // 广告组出价的广告不允许修改价格

        int ERR_CODE_V2_COLLECT_ADD_OFFLINE= 120267; // 已禁止创建2.0广告，请到3.0创建
        int ERR_CODE_V2_COLLECT_EDIT_OFFLINE= 120268; // 已禁止编辑2.0广告，请到3.0编辑

        int ERR_CODE_COLLECT_TOTAL_COUNT_LIMIT = 120340; // 广告创建数量超出限制
        int ERR_CODE_COLLECT_DAY_COUNT_LIMIT = 120341; // 广告单日创建数量超出限制


        /** 数据查询服务 **/
        int ERR_CODE_DATA_PLAN = 120401; // 数据查询-计划结果为空
        int ERR_CODE_DATA_PLAN_EMPTY = 120402; // 数据查询-计划返回为空

        /** 公共部分 ***/
        int ERR_CODE_GEN_SEQ = 120501; // 产生序列号出错
        int ERR_CODE_INVOKE_GEN_SEQ_SRV = 120502; // 产生序列号出错
        int ERR_CODE_OWNER_INFO = 120502; // 广告主信息有错
        int ERR_CODE_MQ_SET_PARAM = 120503; // MQ请求写入时，参数出错
        int ERR_CODE_PAGINATOR_ILLEGAL = 120504; // paginator is not legal
        int ERR_CODE_SHARDING_PLAN = 120505; // 分页查询计划出错
        int ERR_CODE_SHARDING_GROUP = 120505; // 分页查询广告组出错
        int ERR_CODE_SHARDING_COLLECT_AD = 120505; // 分页查询聚合广告出错

        /** 公共素材部分 *******/
        int ERR_CODE_COPY_SHOW_TYPE = 120601; // 复制推广样式出错
        int ERR_CODE_GET_SHOW_TYPE = 120602; // 查询推广样式出错了
        int ERR_CODE_SHOW_TYPE_FIND_DAO = 120603; // 查询推广样式数据库出错
        int ERR_CODE_PARSE_WEBP_ERROR = 120604; // 转换web错误
        int ERR_CODE_PARSE_WEBP_FILE_NOT_EXIST = 120605; // 源文件不存在
        int ERR_CODE_PARSE_WEBP_TIMEOUT = 120606; // 转换webptimeout.

        int ERR_CODE_V2_MATERIAL_EDIT_OFFLINE = 120607; // 不可编辑广告素材，请至3.0新建投放

        /** 公共部分-工具箱相关 **/
        int ERR_CODE_QUERY_ROLE_MENU = 127000;// 查询角色权限信息失败
        int ERR_CODE_QUERY_BANNER_MSG = 127001;// 获取横幅消息失败
        int ERR_CODE_AUTH_CHN_FORBID = 127002; // 没有该推广渠道的权限
        int ERR_CODE_AUTH_SHOW_TYPE_FORBID = 127003; // 没有该推广样式的权限
        int ERR_CODE_OPR_LOG_ERROR = 127004; // 获取操作日志失败
        int ERR_CODE_USER_MSG_ERROR = 127005; // 获取站内信失败
        int ERR_CODE_USER_MSG_STATUS_ERROR = 127006; // 修改站内信异常
        int ERR_CODE_USER_MSG_BATCH_STATUS_ERROR = 127007; // 批量修改站内信异常
        int ERR_CODE_USER_QUERY_CONTACT_ERROR = 127008; // 获取用户联系方式异常
        int ERR_CODE_USER_ADD_CONTACT_ERROR = 127009; // 新增用户联系方式异常
        int ERR_CODE_USER_DELETE_CONTACT_ERROR = 127010; // 新增用户联系方式异常
        int ERR_CODE_USER_MSG_REL_ERROR = 127011; // 获取用户订阅列表异常
        int ERR_CODE_USER_MSG_REL_SWITCH_ERROR = 127012; // 切换用户订阅状态异常
        int ERR_CODE_OPR_LOG_DOWNLAOD_ERROR = 127013; // 下载操作日志异常
        int ERR_CODE_DUPLICATE_USER_CONTACT = 128001; // 添加重复的联系方式
        int ERR_CODE_INVALID_USER_CONTACT = 128002; // 添加无效的联系方式
        int ERR_CODE_AUTH_FEEDS_SMART_EXPAND = 128003;//  没有该智能扩量的权限

        int ERR_CODE_DATE_PARAM = 128501; // 导出IMEI时间参数有误
        int ERR_CODE_IDS_PARAM = 128502; // 导出IMEI广告参数有误
        int ERR_CODE_IMEI_EXTRACT_SEARCH = 128503; // 导出IMEI错误
        int ERR_CODE_IMEI_EXTRACT_ADD = 128504; // 新增提取IMEI错误
        int ERR_CODE_IMEI_EXTRACT_EXPORT_STATUS = 128505; // 记录未提取完成
        int ERR_CODE_IMEI_FREQUENT_INVALID = 128506; // 导出IMEI操作频率不合法(指定周期内不允许多次导出)
        int ERR_CODE_IMEI_AGENCY_INVALID = 128507; // 不合法操作
        int ERR_CODE_IMEI_DATE_OUT_RANGE = 128508; // 日期超过可选范围

        /** *************/
        int ERR_CODE_TEMPLATE_OWER_ID_EMPTY=129001;//查找模板广告主id为空
        int ERR_CODE_TEMPLATE_EMPTY=129002;//模板为空
        int ERR_CODE_TEMPLATE_CONFIG_EMPTY=129003;//模板为空
        int ERR_CODE_TEMPLATE_TARGET_URL_EMPTY=129004;//模板链接为空

        /*模板校验部分*/
        int ERR_CODE_TEMPLATE_APP_NOT_MATCH = 129201;//模板落地页链接中的应用与广告推广中的应用不一致
        int ERR_CODE_TEMPLATE_AND_TARGET_URL_NOT_MATCH = 129202;//模板链接与所选模板类型不匹配
        int ERR_CODE_TEMPLATE_INFO_QUERY = 129203;//获取模板信息错误

        /*文案库/文案助手错误码*/
        int ERR_CODE_COPYWRITER_PARAM_INVALID = 130001;
        int ERR_CODE_COPYWRITER_DB_ERROR = 130002;
        int ERR_CODE_COPYWRITER_SYSTEM_ERROR = 130003;
        int ERR_CODE_KEYWORD_SUGGESTION = 130004;
        int ERR_CODE_TITLE_RECOMMEND = 130005;
    }


    interface AccessErrCode {
        int ERR_EXCEPTIN = -1;

        // 参数校验错误
        int ERR_PARAM_VAILD = -2;

        // dao初始化异常
        int ERR_DAO_INIT = -3;

        // dao执行失败
        int ERR_DAO_INVOKE = -4;

        // dao事务失败
        int ERR_DAO_TRANSCATION = -5;

        // dubbo 调用异常
        int ERR_DUBBO_INVOKE = -6;

        // > 0 为业务错误

        // 定向
        int ERR_TARGET_GET_SEQ = 10100;// 获取序列失败
        int ERR_TARGET_ADD = 10101;// 新建定向失败
        int ERR_TARGET_UPDATE = 10102;// 更新定向失败
        int ERR_TARGET_DEL = 10103;// 删除定向失败
        int ERR_TARGET_EXISTED = 10104;// 定向已存在
        int ERR_TARGET_APP_CATE_QRY_ERR = 10105;// 获取定向应用分类错误.
        // 定向属性
        int ERR_TARGET_PROPERTY_ADD = 10201;// 新建定向属性失败
        int ERR_TARGET_PROPERTY_UPDATE = 10202;// 更新定向属性失败
        int ERR_TARGET_PROPERTY_INVALID = 10203;// 定向属性校验有误
        int ERR_TARGET_PROPERTY_COUNT_LIMITED = 10204;// 定向属性数量限制制定数量

        // 文件
        int ERR_FILE_GET_SEQ = 10300;// 获取序列失败

        // 定向缓存
        int ERR_TAREGT_CACHE_FILE_ERROR = 10400;// 获取IMEI文件失败
        int ERR_OPERATE_FREQUENTLY = 10401;// 定向缓存操作过于频繁
        int ERR_TAREGT_CACHE_FILE_SIZE_LIMIT = 10402;// IMEI文件大小超过限制
        int ERR_TAREGT_CACHE_TASK_EXECUTED = 10403;// 定向文件刷入任务“近期”已经执行过

        // 工具箱
        int ERR_DUPLICATE_CONTACT_INFO = 128001;// 重复的联系方式

        // 操作
        int ERR_NO_UPDATE = 10501;

        // 参数
        int ERR_INVALID_ARGUMENT = 10601;

    }

    interface CrowdErrCode {
        int ERR_EXCEPTIN = -1;

        // 参数校验错误
        int ERR_PARAM_VAILD = -2;

        // dao初始化异常
        int ERR_DAO_INIT = -3;

        // dao执行失败
        int ERR_DAO_INVOKE = -4;

        // dao事务失败
        int ERR_DAO_TRANSCATION = -5;

        // dubbo 调用异常
        int ERR_DUBBO_INVOKE = -6;

        // > 0 为业务错误

        // 定向
        int ERR_TARGET_GET_SEQ = 10100;// 获取序列失败
        int ERR_TARGET_ADD = 10101;// 新建定向失败
        int ERR_TARGET_UPDATE = 10102;// 更新定向失败
        int ERR_TARGET_DEL = 10103;// 删除定向失败
        int ERR_TARGET_EXISTED = 10104;// 定向已存在
        int ERR_TARGET_APP_CATE_QRY_ERR = 10105;// 获取定向应用分类错误.
        // 定向属性
        int ERR_TARGET_PROPERTY_ADD = 10201;// 新建定向属性失败
        int ERR_TARGET_PROPERTY_UPDATE = 10202;// 更新定向属性失败
        int ERR_TARGET_PROPERTY_INVALID = 10203;// 定向属性校验有误
        int ERR_TARGET_PROPERTY_COUNT_LIMITED = 10204;// 定向属性数量限制制定数量

        // 文件
        int ERR_FILE_GET_SEQ = 10300;// 获取序列失败

        // 定向缓存
        int ERR_TAREGT_CACHE_FILE_ERROR = 10400;// 获取IMEI文件失败
        int ERR_OPERATE_FREQUENTLY = 10401;// 定向缓存操作过于频繁
        int ERR_TAREGT_CACHE_FILE_SIZE_LIMIT = 10402;// IMEI文件大小超过限制
        int ERR_TAREGT_CACHE_TASK_EXECUTED = 10403;// 定向文件刷入任务“近期”已经执行过

        // 工具箱
        int ERR_DUPLICATE_CONTACT_INFO = 128001;// 重复的联系方式

        // 操作
        int ERR_NO_UPDATE = 10501;

        // 参数
        int ERR_INVALID_ARGUMENT = 10601;

    }

}
