package com.omni.ads.model.material.vo;

import org.apache.commons.lang3.math.NumberUtils;

import java.util.ArrayList;
import java.util.List;

public class Page<T> {
    private Integer totalCount;
    private Integer itemCount;
    private List<T> items;

    public Page() {
        this(NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO);
    }

    public Page(Integer totalCount, Integer itemCount) {
        this(totalCount, itemCount, new ArrayList());
    }

    public Page(Integer totalCount, Integer itemCount, List<T> items) {
        this.totalCount = totalCount;
        this.itemCount = itemCount;
        this.items = items;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public Integer getItemCount() {
        return this.itemCount;
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public void setItemCount(Integer itemCount) {
        this.itemCount = itemCount;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }
}
