package com.omni.ads.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public DateUtils() {
    }

    public static Date str2Date(String str, String pattern) throws Exception {
        SimpleDateFormat formator = new SimpleDateFormat(pattern);
        return formator.parse(str);
    }

    public static Date str2DateEnd(String str, String pattern) throws Exception {
        SimpleDateFormat formator = new SimpleDateFormat(pattern);
        Date date = formator.parse(str);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static String date2Str(Date date, String pattern) throws Exception {
        SimpleDateFormat formator = new SimpleDateFormat(pattern);
        return formator.format(date);
    }

    public static long duration(Date startDate, Date endDate) {
        long diff = endDate.getTime() - startDate.getTime();
        return diff / 1000L;
    }

    public static int unixTime() {
        BigDecimal num = new BigDecimal(System.currentTimeMillis() / 1000L);
        return num.intValue();
    }

    public static int unixTime(Date date) {
        BigDecimal num = new BigDecimal(date.getTime() / 1000L);
        return num.intValue();
    }

    public static Date unixTimeToDate(int unixtime) {
        return new Date((long)unixtime * 1000L);
    }

    public static Date unixTimeToDate(long unixtime) {
        return new Date(unixtime * 1000L);
    }

    public static int dateInt(Date date) {
        try {
            return Integer.parseInt(date2Str(date, "yyyyMMdd"));
        } catch (Exception var2) {
            return -1;
        }
    }

    public static long dateLong(Date date, String pattern) {
        try {
            return Long.parseLong(date2Str(date, pattern));
        } catch (Exception var3) {
            return -1L;
        }
    }

    public static double nanoToMilli(double nanoTime) {
        return BigDecimal.valueOf(nanoTime / 1000000.0D).setScale(3, RoundingMode.HALF_UP).doubleValue();
    }
}
