package com.omni.ads.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonToMapUtils {

    /**
     *简单JSON转MAP
    */
    public static Map<String,Object> getForm(Object data){
        JSONObject jo= null;
        try {
            jo = (JSONObject) JSONObject.toJSON(data);
        } catch (Exception e) {
            e.printStackTrace();
        }
        String str = jo.toString();
        Map<String,Object> mapType = JSON.parseObject(str,Map.class);
        return mapType;
    }

    /**
     * 对list进行转换
     * */
    public static Map<String,Object> getFormList(Object data) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        Map<String, Object> map = new HashMap<String, Object>();
        Map<String, Object> map2 = new HashMap<String, Object>();

        BeanInfo beanInfo = Introspector.getBeanInfo(data.getClass());
        PropertyDescriptor[] propertyDescriptors = beanInfo
                .getPropertyDescriptors();
        for (PropertyDescriptor property : propertyDescriptors) {
            String key = property.getName();
            if (key.compareToIgnoreCase("class") == 0) {
                continue;
            }
            Method getter = property.getReadMethod();
            Object value = getter != null ? getter.invoke(data) : null;
            List mapList = new ArrayList<>();
            if(value instanceof List<?>){
                List<?> cc = (List<?>) value;
                for (Object oo : cc){
                    Map<String, Object> map1 = new HashMap<String, Object>();
                    Field[] fields = oo.getClass().getDeclaredFields();
                    for(Field field : fields){
                        field.setAccessible(true);
                        map1.put(field.getName() , field.get(oo));
                    }
                    mapList.add(map1);
                    map.put(key,mapList);
                }
            }else {
                map.put(key,value);
            }
        }map2.putAll(map);
        return map2;
    }

}
