package com.omni.ads.utils;

import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;

import java.nio.charset.Charset;

/**
 * 获取token
 */
public class TokenUtils {

    /**
     * @param ownerId   广告主id
     * @param apiId  API授权接入方唯一身份标识；
     * @param apiKey  开通API授权后获得的私钥，在开通授权邮件中会与app_id一块提供；
     */
    public static String getToken(Long ownerId, String apiId, String apiKey) {
        int timestamp = DateUtils.unixTime();
        String sign = Hashing.sha1().hashString(apiId + apiKey + timestamp, Charset.defaultCharset()).toString();
        BaseEncoding baseEncoding = BaseEncoding.base64();
        String encodeToken = baseEncoding.encode((ownerId + "," + apiId + "," + timestamp + "," + sign).getBytes());
        String token = "Bearer" + " " + encodeToken;
        return token;
    }

}
