/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.controller;

import com.ibm.db2.cmx.ClientDescriptor;
import com.ibm.db2.cmx.ClientInfo;
import com.ibm.db2.cmx.Database;
import com.ibm.db2.cmx.Environment;
import com.ibm.db2.cmx.MonitorInterface;
import com.ibm.db2.cmx.ProductInformation;
import com.ibm.db2.cmx.Profile;
import com.ibm.db2.cmx.PushDownError;
import com.ibm.db2.cmx.TransactionRule;
import com.ibm.db2.cmx.TransportPoolStatistics;
import com.ibm.db2.cmx.internal.controller.ControlDataSource;
import com.ibm.db2.cmx.internal.controller.ControlDataSourceImpl;
import com.ibm.db2.cmx.internal.controller.ControlDriver;
import com.ibm.db2.cmx.internal.core.JSONHelper;
import com.ibm.db2.cmx.internal.core.Message;
import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.internal.json4j.JSONObject;
import com.ibm.db2.cmx.internal.metadata.ClientProfileUtil;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ControllerMessageHelper {
    private static final ControllerMessageHelper instance_ = new ControllerMessageHelper();
    private static Logger clientLogger__ = Log.getCMXClientLogger();

    public static ControllerMessageHelper getInstance() {
        return instance_;
    }

    private ControllerMessageHelper() {
    }

    Message createLookupRequest(String string, String string2, String string3, String string4, String string5, String string6, int n2) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add("1");
        jSONArray.add(string);
        jSONArray.add(string2);
        jSONArray.add(string4);
        jSONArray.add(string5);
        if (n2 > 2) {
            jSONArray.add(string6);
        }
        if (n2 >= 8) {
            jSONArray.add(string3);
        }
        return new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
    }

    private void setDriverDescriptorProperties(JSONObject jSONObject, Map<String, Object> map) {
        JSONArray jSONArray = null;
        JSONObject jSONObject2 = null;
        JSONObject jSONObject3 = null;
        jSONObject.put("driverDescriptorUUID", map.get("driverDescriptorUUID"));
        if (map.get("driverDescriptorClientIP") != null) {
            String[] stringArray = (String[])map.get("driverDescriptorClientIP");
            jSONArray = new JSONArray();
            for (String string : stringArray) {
                jSONArray.add(string);
            }
        }
        jSONObject.put("driverDescriptorClientIP", jSONArray);
        jSONObject.put("driverId", map.get("driverId"));
        jSONObject2 = new JSONObject();
        jSONObject.put("driverDescriptorClientProductInformation", jSONObject2);
        jSONObject2.put("driverKind", map.get("driverKind"));
        jSONObject2.put("driverName", map.get("driverName"));
        jSONObject2.put("driverMajorVersion", map.get("driverMajorVersion"));
        jSONObject2.put("driverMinorVersion", map.get("driverMinorVersion"));
        jSONObject2.put("driverMicroVersion", map.get("driverMicroVersion"));
        jSONObject2.put("driverBuildQualifier", map.get("driverBuildQualifier"));
        jSONObject2.put("driverBuildCertification", map.get("driverBuildCertification"));
        jSONObject2.put("cmxComponentName", map.get("cmxComponentName"));
        jSONObject2.put("cmxMajorVersion", map.get("cmxMajorVersion"));
        jSONObject2.put("cmxMinorVersion", map.get("cmxMinorVersion"));
        jSONObject2.put("cmxMicroVersion", map.get("cmxMicroVersion"));
        jSONObject2.put("cmxBuildQualifier", map.get("cmxBuildQualifier"));
        jSONObject2.put("cmxBuildCertification", map.get("cmxBuildCertification"));
        jSONObject2.put("cmxSpecVersion", map.get("cmxSpecVersion"));
        jSONObject2.put("wasServerName", map.get("wasServerName"));
        jSONObject2.put("wasServerVersion", map.get("wasServerVersion"));
        jSONObject3 = JSONHelper.createJSONObjectFromMap((HashMap)map.get("driverDescriptorClientPropertySettings"));
        jSONObject.put("driverDescriptorClientPropertySettings", jSONObject3);
    }

    public Message createLookupReply(String string, String string2, String string3, String string4, String string5, JSONObject jSONObject, JSONObject jSONObject2, String string6, int n2, int n3) {
        Message message = null;
        JSONArray jSONArray = new JSONArray();
        jSONArray.add(string2);
        jSONArray.add(jSONObject);
        jSONArray.add(jSONObject2);
        jSONArray.add(string3);
        jSONArray.add(string4);
        jSONArray.add(string5);
        if (n3 > 2) {
            jSONArray.add(string6);
            jSONArray.add((Object)n2);
        }
        message = new Message(string, ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
        return message;
    }

    private boolean[] parseClientInfoFieldsToIgnore(JSONArray jSONArray, int n2, int n3) {
        boolean[] blArray = null;
        JSONArray jSONArray2 = (JSONArray)jSONArray.get(n2);
        if (jSONArray2 != null && jSONArray2.size() > 0) {
            blArray = n3 >= 10 ? new boolean[5] : new boolean[]{(Boolean)jSONArray2.get(0), (Boolean)jSONArray2.get(1), (Boolean)jSONArray2.get(2), (Boolean)jSONArray2.get(3)};
            if (n3 >= 10) {
                blArray[4] = (Boolean)jSONArray2.get(4);
            }
        }
        return blArray;
    }

    private String[] parseSubstringExtractionPatternsForClientInfo(JSONArray jSONArray, int n2, int n3) {
        String[] stringArray = null;
        JSONArray jSONArray2 = (JSONArray)jSONArray.get(n2);
        if (jSONArray2 != null && jSONArray2.size() > 0) {
            stringArray = n3 >= 10 ? new String[5] : new String[]{(String)jSONArray2.get(0), (String)jSONArray2.get(1), (String)jSONArray2.get(2), (String)jSONArray2.get(3)};
            if (n3 >= 10) {
                stringArray[4] = (String)jSONArray2.get(4);
            }
        }
        return stringArray;
    }

    private int[][] parseSubstringExtractionPositionsForClientInfo(JSONArray jSONArray, int n2, int n3) {
        int[][] nArray = null;
        JSONArray jSONArray2 = (JSONArray)jSONArray.get(n2);
        if (jSONArray2 != null && jSONArray2.size() > 0) {
            int n4 = n3 >= 10 ? 5 : 4;
            nArray = new int[n4][2];
            for (int i10 = 0; i10 < n4; ++i10) {
                JSONArray jSONArray3 = (JSONArray)jSONArray2.get(i10);
                if (jSONArray3 != null) {
                    nArray[i10][0] = ((Number)jSONArray3.get(0)).intValue();
                    nArray[i10][1] = ((Number)jSONArray3.get(1)).intValue();
                    continue;
                }
                nArray[i10] = null;
            }
        }
        return nArray;
    }

    private TransactionRule.PenaltyBox[] parseClientInfoPenaltyBoxRules(JSONArray jSONArray, int n2) {
        TransactionRule.PenaltyBox[] penaltyBoxArray = null;
        if (jSONArray != null) {
            if (n2 < 6) {
                penaltyBoxArray = new TransactionRule.PenaltyBox[]{this.parseClientInfoPenaltyBoxRule(jSONArray, n2)};
            } else {
                penaltyBoxArray = new TransactionRule.PenaltyBox[jSONArray.size()];
                for (int i10 = 0; i10 < jSONArray.size(); ++i10) {
                    penaltyBoxArray[i10] = this.parseClientInfoPenaltyBoxRule((JSONArray)jSONArray.get(i10), n2);
                }
            }
        }
        return penaltyBoxArray;
    }

    private TransactionRule.PenaltyBox parsePenaltyBoxFlavor(HashMap<ClientInfo, Database> hashMap, boolean[] blArray, String[] stringArray, int[][] nArray) {
        TransactionRule.PenaltyBox penaltyBox = null;
        penaltyBox = stringArray != null ? new TransactionRule.PenaltyBox(hashMap, blArray, stringArray) : (nArray != null ? new TransactionRule.PenaltyBox(hashMap, blArray, nArray) : new TransactionRule.PenaltyBox(hashMap, blArray));
        return penaltyBox;
    }

    private TransactionRule.PenaltyBox parsePenaltyBoxFlavor(String string, HashMap<ClientInfo, Database> hashMap, boolean[] blArray, String[] stringArray, int[][] nArray) {
        TransactionRule.PenaltyBox penaltyBox = null;
        TransactionRule.PenaltyBox.Flavor flavor = null;
        try {
            flavor = Enum.valueOf(TransactionRule.PenaltyBox.Flavor.class, string);
        }
        catch (Exception exception) {
            DataLogger.logConnectedComponents(clientLogger__, this, "clientInfoPenaltyBoxRule", "flavor is invalid");
            return penaltyBox;
        }
        switch (flavor) {
            case patternedSubstringLookup: {
                penaltyBox = new TransactionRule.PenaltyBox(hashMap, blArray, stringArray);
                break;
            }
            case positionedSubstringLookup: {
                penaltyBox = new TransactionRule.PenaltyBox(hashMap, blArray, nArray);
                break;
            }
            case literalLookup: {
                penaltyBox = new TransactionRule.PenaltyBox(hashMap, blArray);
                break;
            }
            default: {
                DataLogger.logConnectedComponents(clientLogger__, this, "parseClientInfoPenaltyBoxRule", "No flavor match");
            }
        }
        if (penaltyBox == null) {
            DataLogger.logConnectedComponents(clientLogger__, this, "parseClientInfoPenaltyBoxRule", string + " flavor with null parameters ");
        }
        return penaltyBox;
    }

    private TransactionRule.PenaltyBox parseClientInfoPenaltyBoxRule(JSONArray jSONArray, int n2) {
        TransactionRule.PenaltyBox penaltyBox = null;
        if (jSONArray != null && jSONArray.size() > 0) {
            Object object;
            Object object2;
            Object object3;
            HashMap<ClientInfo, Database> hashMap = null;
            JSONArray jSONArray2 = (JSONArray)jSONArray.get(0);
            if (jSONArray2 != null && jSONArray2.size() > 0) {
                hashMap = new HashMap<ClientInfo, Database>();
                for (int i10 = 0; i10 < jSONArray2.size(); ++i10) {
                    object3 = (JSONArray)jSONArray2.get(i10);
                    object2 = null;
                    if (object3 != null && ((ArrayList)object3).size() > 0) {
                        object2 = n2 >= 10 ? (Object)new ClientInfo((String)((ArrayList)object3).get(0), (String)((ArrayList)object3).get(1), (String)((ArrayList)object3).get(2), (String)((ArrayList)object3).get(3), (String)((ArrayList)object3).get(4)) : (Object)new ClientInfo((String)((ArrayList)object3).get(0), (String)((ArrayList)object3).get(1), (String)((ArrayList)object3).get(2), (String)((ArrayList)object3).get(3));
                    }
                    object = (JSONArray)jSONArray2.get(++i10);
                    Database database = this.parseDatabase((JSONArray)object, n2, false);
                    if (object2 == null || database == null) continue;
                    hashMap.put((ClientInfo)object2, database);
                }
            }
            boolean[] blArray = this.parseClientInfoFieldsToIgnore(jSONArray, 1, n2);
            object3 = this.parseSubstringExtractionPatternsForClientInfo(jSONArray, 2, n2);
            object2 = this.parseSubstringExtractionPositionsForClientInfo(jSONArray, 3, n2);
            if (n2 >= 8) {
                object = (String)jSONArray.get(4);
                penaltyBox = this.parsePenaltyBoxFlavor((String)object, hashMap, blArray, (String[])object3, (int[][])object2);
            } else {
                penaltyBox = this.parsePenaltyBoxFlavor(hashMap, blArray, (String[])object3, (int[][])object2);
            }
        }
        return penaltyBox;
    }

    private String[] parseFinalClientInfoSubstitutionPatterns(JSONArray jSONArray, int n2, int n3) {
        String[] stringArray = null;
        JSONArray jSONArray2 = (JSONArray)jSONArray.get(n2);
        if (jSONArray2 != null && jSONArray2.size() > 0) {
            stringArray = n3 >= 10 ? new String[5] : new String[]{(String)jSONArray2.get(0), (String)jSONArray2.get(1), (String)jSONArray2.get(2), (String)jSONArray2.get(3)};
            if (n3 >= 10) {
                stringArray[4] = (String)jSONArray2.get(4);
            }
        }
        return stringArray;
    }

    private int[] parseConditionsOfSubstitution(JSONArray jSONArray, int n2, int n3) {
        int[] nArray = null;
        JSONArray jSONArray2 = (JSONArray)jSONArray.get(n2);
        if (jSONArray2 != null && jSONArray2.size() > 0) {
            nArray = n3 >= 10 ? new int[5] : new int[]{((Number)jSONArray2.get(0)).intValue(), ((Number)jSONArray2.get(1)).intValue(), ((Number)jSONArray2.get(2)).intValue(), ((Number)jSONArray2.get(3)).intValue()};
            if (n3 >= 10) {
                nArray[4] = ((Number)jSONArray2.get(4)).intValue();
            }
        }
        return nArray;
    }

    private TransactionRule.Remapping[] parseClientInfoRemappingRules(JSONArray jSONArray, int n2) {
        TransactionRule.Remapping[] remappingArray = null;
        if (jSONArray == null) {
            return null;
        }
        if (n2 < 6) {
            remappingArray = new TransactionRule.Remapping[]{this.parseClientInfoRemappingRule(jSONArray, n2)};
        } else {
            int n3 = jSONArray.size();
            remappingArray = new TransactionRule.Remapping[n3];
            for (int i10 = 0; i10 < n3; ++i10) {
                remappingArray[i10] = this.parseClientInfoRemappingRule((JSONArray)jSONArray.get(i10), n2);
            }
        }
        return remappingArray;
    }

    private TransactionRule.Remapping parseRemappingFlavor(String string, HashMap<ClientInfo, ClientInfo> hashMap, String[] stringArray, String[] stringArray2, int[][] nArray, boolean[] blArray, int[] nArray2) {
        TransactionRule.Remapping remapping = null;
        TransactionRule.Remapping.Flavor flavor = null;
        try {
            flavor = Enum.valueOf(TransactionRule.Remapping.Flavor.class, string);
        }
        catch (Exception exception) {
            DataLogger.logConnectedComponents(clientLogger__, this, "parseClientInfoRemappingRule", "flavor is invalid");
            return remapping;
        }
        switch (flavor) {
            case patternedSubstringSubstitution: {
                remapping = new TransactionRule.Remapping(stringArray, stringArray2, nArray2);
                break;
            }
            case positionedSubstringSubstitution: {
                remapping = new TransactionRule.Remapping(nArray, stringArray2);
                break;
            }
            case literalSubstitution: {
                remapping = new TransactionRule.Remapping(hashMap, blArray);
                break;
            }
            case unconditionalReplacement: {
                remapping = new TransactionRule.Remapping(stringArray2, blArray);
                break;
            }
            case literalSubstitutionWithPreliminaryPatternedSubstringExtraction: {
                remapping = new TransactionRule.Remapping(hashMap, blArray, stringArray);
                break;
            }
            case literalSubstitutionWithPreliminaryPositionedSubstringExtraction: {
                remapping = new TransactionRule.Remapping(hashMap, blArray, nArray);
                break;
            }
            default: {
                DataLogger.logConnectedComponents(clientLogger__, this, "parseClientInfoRemappingRule", "No flavor match");
            }
        }
        if (remapping == null) {
            DataLogger.logConnectedComponents(clientLogger__, this, "parseClientInfoRemappingRule", string + " flavor with null parameters ");
        }
        return remapping;
    }

    private TransactionRule.Remapping parseRemappingFlavor(String[] stringArray, int[][] nArray, HashMap<ClientInfo, ClientInfo> hashMap, boolean[] blArray, String[] stringArray2, int[] nArray2) {
        TransactionRule.Remapping remapping = null;
        remapping = stringArray != null && hashMap != null && blArray != null ? new TransactionRule.Remapping(hashMap, blArray, stringArray) : (nArray != null && hashMap != null && blArray != null ? new TransactionRule.Remapping(hashMap, blArray, nArray) : (stringArray != null ? new TransactionRule.Remapping(stringArray, stringArray2, nArray2) : (nArray != null ? new TransactionRule.Remapping(nArray, stringArray2) : (stringArray2 != null && blArray != null ? new TransactionRule.Remapping(stringArray2, blArray) : new TransactionRule.Remapping(hashMap, blArray)))));
        return remapping;
    }

    private TransactionRule.Remapping parseClientInfoRemappingRule(JSONArray jSONArray, int n2) {
        TransactionRule.Remapping remapping = null;
        if (jSONArray != null && jSONArray.size() > 0) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            HashMap<ClientInfo, ClientInfo> hashMap = null;
            JSONArray jSONArray2 = (JSONArray)jSONArray.get(0);
            if (jSONArray2 != null && jSONArray2.size() > 0) {
                hashMap = new HashMap<ClientInfo, ClientInfo>();
                for (int i10 = 0; i10 < jSONArray2.size(); ++i10) {
                    object4 = (JSONArray)jSONArray2.get(i10);
                    object3 = null;
                    if (object4 != null && ((ArrayList)object4).size() > 0) {
                        object3 = n2 >= 10 ? (Object)new ClientInfo((String)((ArrayList)object4).get(0), (String)((ArrayList)object4).get(1), (String)((ArrayList)object4).get(2), (String)((ArrayList)object4).get(3), (String)((ArrayList)object4).get(4)) : (Object)new ClientInfo((String)((ArrayList)object4).get(0), (String)((ArrayList)object4).get(1), (String)((ArrayList)object4).get(2), (String)((ArrayList)object4).get(3));
                    }
                    object2 = (JSONArray)jSONArray2.get(++i10);
                    object = null;
                    if (object2 != null && ((ArrayList)object2).size() > 0) {
                        object = n2 >= 10 ? (Object)new ClientInfo((String)((ArrayList)object2).get(0), (String)((ArrayList)object2).get(1), (String)((ArrayList)object2).get(2), (String)((ArrayList)object2).get(3), (String)((ArrayList)object2).get(4)) : (Object)new ClientInfo((String)((ArrayList)object2).get(0), (String)((ArrayList)object2).get(1), (String)((ArrayList)object2).get(2), (String)((ArrayList)object2).get(3));
                    }
                    if (object3 == null || object == null) continue;
                    hashMap.put((ClientInfo)object3, (ClientInfo)object);
                }
            }
            boolean[] blArray = this.parseClientInfoFieldsToIgnore(jSONArray, 1, n2);
            object4 = this.parseSubstringExtractionPatternsForClientInfo(jSONArray, 2, n2);
            object3 = this.parseSubstringExtractionPositionsForClientInfo(jSONArray, 3, n2);
            object2 = this.parseFinalClientInfoSubstitutionPatterns(jSONArray, 4, n2);
            object = this.parseConditionsOfSubstitution(jSONArray, 5, n2);
            if (n2 >= 8) {
                String string = (String)jSONArray.get(6);
                remapping = this.parseRemappingFlavor(string, hashMap, (String[])object4, (String[])object2, (int[][])object3, blArray, (int[])object);
            } else {
                remapping = this.parseRemappingFlavor((String[])object4, (int[][])object3, hashMap, blArray, (String[])object2, (int[])object);
            }
        }
        return remapping;
    }

    ControlDataSource parseLookupReply(Message message, ControlDataSourceImpl controlDataSourceImpl, String string) {
        if (clientLogger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(clientLogger__, this, "parseLookupReply", "ENTRY " + Arrays.deepToString(new Object[]{controlDataSourceImpl}));
        }
        if (message == null && string == null) {
            return null;
        }
        Properties properties = null;
        Properties properties2 = null;
        JSONArray jSONArray = null;
        if (string != null) {
            try {
                jSONArray = JSONArray.parse(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            jSONArray = JSONHelper.convertJSONByteBuffer(message);
        }
        properties = JSONHelper.createPropertiesFromJSONArray(jSONArray, 1);
        properties2 = JSONHelper.createPropertiesFromJSONArray(jSONArray, 2);
        int n2 = -1;
        if (jSONArray.size() >= 7 && jSONArray.get(7) != null) {
            n2 = ((Number)jSONArray.get(7)).intValue();
        }
        boolean bl2 = false;
        if ((properties2.containsKey("monitorIdRequired") || properties2.containsKey("supportedKeyTypes")) && Configuration.isJCCPresent__) {
            String string2;
            String string3 = properties2.getProperty("monitorIdRequired");
            if (string3 != null) {
                bl2 = Boolean.parseBoolean(string3);
            }
            if ((string2 = properties2.getProperty("supportedKeyTypes")) != null && string2.contains("1")) {
                bl2 = true;
            }
            if (bl2 && !Configuration.checkIfFunctionalityIsAvailableInJCCVersion(58, 8)) {
                if (clientLogger__.isLoggable(Level.CONFIG)) {
                    DataLogger.lowImpactLogger(clientLogger__, this, "parseLookupReply", "MONITORID is required for monitoring, but JCC version:" + Configuration.JCCVersionAsString__ + " does not support MONITORID.  Ignoring monitor settings", null);
                }
                properties.clear();
                properties2.clear();
            }
        }
        controlDataSourceImpl.init(properties, properties2, n2);
        return controlDataSourceImpl;
    }

    void processCMXProperties(ControlDataSourceImpl controlDataSourceImpl) {
        Profile.DataSource dataSource = null;
        Database database = null;
        Profile.Database database2 = null;
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        int n2 = -1;
        if (clientLogger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(clientLogger__, this, "processCMXProperties", "ENTRY " + Arrays.deepToString(new Object[]{controlDataSourceImpl}));
        }
        if ((database = (dataSource = controlDataSourceImpl.getDataSourceProfile()).getRedirectDatabase()) == null) {
            database = dataSource.getTargetDatabase();
        }
        if (database != null && (database2 = database.getDatabaseProfile()) != null && database2.getCmxDirectives() != null) {
            properties2.putAll((Map<?, ?>)database2.getCmxDirectives());
        }
        boolean bl2 = false;
        if ((properties2.containsKey("monitorIdRequired") || properties2.containsKey("supportedKeyTypes")) && Configuration.isJCCPresent__) {
            String string;
            String string2 = properties2.getProperty("monitorIdRequired");
            if (string2 != null) {
                bl2 = Boolean.parseBoolean(string2);
            }
            if ((string = properties2.getProperty("supportedKeyTypes")) != null && string.contains("1")) {
                bl2 = true;
            }
            if (bl2 && !Configuration.checkIfFunctionalityIsAvailableInJCCVersion(58, 8)) {
                if (clientLogger__.isLoggable(Level.CONFIG)) {
                    DataLogger.lowImpactLogger(clientLogger__, this, "parseLookupReply", "MONITORID is required for monitoring, but JCC version:" + Configuration.JCCVersionAsString__ + " does not support MONITORID.  Ignoring monitor settings", null);
                }
                properties.clear();
                properties2.clear();
            }
        }
        controlDataSourceImpl.init(properties, properties2, n2);
    }

    Message createRegisterRequest(String string, String string2, String string3, String string4, String[] stringArray, String string5, String string6, String[] stringArray2, int n2, int n3, int n4, int n5, boolean bl2, int[] nArray, String[] stringArray3, String string7, int n6, int n7, int n8) {
        JSONArray jSONArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i10 = 0; i10 < stringArray2.length; ++i10) {
            if (i10 > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(stringArray2[i10]);
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("monitorServerName", stringBuilder.toString());
        jSONObject.put("monitorPort", (Object)n2);
        jSONObject.put("monitorEnabled", (Object)n3);
        jSONObject.put("monitorLevel", (Object)n4);
        jSONObject.put("monitorCollectionInterval", (Object)n5);
        jSONObject.put("monitorIdRequired", (Object)bl2);
        jSONObject.put("dispatchToken", (Object)n6);
        jSONObject.put("disableOCMDynamicControl", (Object)n8);
        if (nArray != null && nArray.length > 0) {
            jSONArray = new JSONArray();
            for (int i11 = 0; i11 < nArray.length; ++i11) {
                jSONArray.add((Object)nArray[i11]);
            }
            jSONObject.put("supportedKeyTypes", jSONArray);
        }
        if (stringArray3 != null && stringArray3.length == 4) {
            if (stringArray3[0] != null) {
                jSONObject.put("clientUserMask", stringArray3[0]);
            }
            if (stringArray3[1] != null) {
                jSONObject.put("clientHostnameMask", stringArray3[1]);
            }
            if (stringArray3[2] != null) {
                jSONObject.put("applicationNameMask", stringArray3[2]);
            }
            if (stringArray3[3] != null) {
                jSONObject.put("clientAccountingInformationMask", stringArray3[3]);
            }
        }
        jSONArray = new JSONArray();
        jSONArray.add("2");
        jSONArray.add(string);
        jSONArray.add((Object)null);
        jSONArray.add(jSONObject);
        jSONArray.add(string3);
        jSONArray.add(string5);
        jSONArray.add(string6);
        jSONArray.add(string7);
        if (n7 >= 8) {
            jSONArray.add(string4);
        }
        if (n7 >= 9) {
            JSONArray jSONArray2 = new JSONArray();
            jSONArray2.add(string2);
            if (stringArray != null) {
                for (int i12 = 0; i12 < stringArray.length; ++i12) {
                    jSONArray2.add(stringArray[i12]);
                }
            }
            jSONArray.add(jSONArray2);
        }
        return new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
    }

    Message createDeregisterRequest(String string, String string2, String string3, String string4, String string5, String string6, int n2, int n3) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add("3");
        jSONArray.add(string);
        jSONArray.add(string2);
        jSONArray.add(string4);
        jSONArray.add(string5);
        jSONArray.add(string6);
        jSONArray.add((Object)n2);
        if (n3 >= 8) {
            jSONArray.add(string3);
        }
        return new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
    }

    Message createDeregisterDriverRequest(String string) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add("7");
        jSONArray.add(string);
        return new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
    }

    Message createDeregisterDataSourceRequest(String string) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add("8");
        jSONArray.add(string);
        return new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
    }

    private ProductInformation.Driver.DriverKind getDriverKind(ClientDescriptor.Driver driver) {
        ProductInformation.Client client = null;
        ProductInformation.Driver driver2 = null;
        ProductInformation.Driver.DriverKind driverKind = null;
        if (driver != null && (client = driver.getClientProductInformation()) != null && (driver2 = client.getDriverProductInformation()) != null) {
            driverKind = driver2.DriverKind();
        }
        return driverKind;
    }

    private ProductInformation.Driver.DriverKind getDriverKind(ClientDescriptor.DataSource dataSource) {
        ProductInformation.Driver.DriverKind driverKind = null;
        if (dataSource != null) {
            driverKind = this.getDriverKind(dataSource.getDriverDescriptor());
        }
        return driverKind;
    }

    private JSONArray createDriverProfileArray(Profile.Driver driver, ProductInformation.Driver.DriverKind driverKind, int n2) {
        JSONArray jSONArray = null;
        if (driver != null) {
            jSONArray = new JSONArray();
            jSONArray.add(driver.getName());
            jSONArray.add((Object)driver.getVersion());
            jSONArray.add(JSONHelper.createJSONObjectFromStringMap(driverKind == null || driverKind == ProductInformation.Driver.DriverKind.JCC ? driver.getJccDirectives() : null));
            jSONArray.add(JSONHelper.createJSONObjectFromStringMap(driverKind == null || driverKind == ProductInformation.Driver.DriverKind.CLI ? driver.getCliDirectives() : null));
            jSONArray.add(JSONHelper.createJSONObjectFromStringMap(driverKind == null || driverKind == ProductInformation.Driver.DriverKind.DOTNET ? driver.getDotNetDirectives() : null));
            jSONArray.add(JSONHelper.createJSONObjectFromStringMap(driverKind == null || driverKind == ProductInformation.Driver.DriverKind.JCC ? driver.getWasDirectives() : null));
            jSONArray.add(JSONHelper.createJSONObjectFromStringMap(driver.getCmxDirectives()));
            jSONArray.add((Object)driver.getPollingInterval());
            jSONArray.add((Object)driver.getStatisticsCollectionInterval());
            jSONArray.add((Object)driver.getMaxClientInfoToLogPerDataSource());
            if (n2 >= 9) {
                if (driver.getSpecialRegisters() != null) {
                    jSONArray.add(JSONHelper.createJSONObjectFromProperties(driver.getSpecialRegisters()));
                } else {
                    jSONArray.add((Object)null);
                }
            }
        }
        return jSONArray;
    }

    private JSONArray createServerProductInformationArray() {
        JSONArray jSONArray = null;
        if (Environment.getServerProductInformation() != null) {
            ProductInformation.Basic basic;
            JSONArray jSONArray2 = null;
            JSONArray jSONArray3 = null;
            ProductInformation.Server server = Environment.getServerProductInformation();
            jSONArray = new JSONArray();
            if (server.getOCMServerProductInformation() != null) {
                basic = server.getOCMServerProductInformation();
                jSONArray2 = new JSONArray();
                jSONArray2.add(basic.getComponentName());
                jSONArray2.add((Object)basic.getMajorVersion());
                jSONArray2.add((Object)basic.getMinorVersion());
                jSONArray2.add((Object)basic.getMicroVersion());
                jSONArray2.add(basic.getBuildQualifier());
                jSONArray2.add(basic.getBuildCertification().toString());
            }
            jSONArray.add(jSONArray2);
            if (server.getCMXServerProductInformation() != null) {
                basic = server.getCMXServerProductInformation();
                jSONArray3 = new JSONArray();
                jSONArray3.add(basic.getComponentName());
                jSONArray3.add((Object)basic.getMajorVersion());
                jSONArray3.add((Object)basic.getMinorVersion());
                jSONArray3.add((Object)basic.getMicroVersion());
                jSONArray3.add(basic.getBuildQualifier());
                jSONArray3.add(basic.getBuildCertification().toString());
                jSONArray3.add((Object)((ProductInformation.CMX)basic).getSpecVersion());
            }
            jSONArray.add(jSONArray3);
        }
        return jSONArray;
    }

    public Message createRegisterDriverReply(int n2, String string, Profile.Driver driver, ClientDescriptor.Driver driver2, int n3) {
        Message message = null;
        ProductInformation.Driver.DriverKind driverKind = null;
        JSONArray jSONArray = new JSONArray();
        jSONArray.add((Object)n2);
        jSONArray.add(string);
        driverKind = this.getDriverKind(driver2);
        jSONArray.add(this.createDriverProfileArray(driver, driverKind, n3));
        jSONArray.add(this.createServerProductInformationArray());
        message = new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
        return message;
    }

    public Message createLookupDatabaseReply(int n2, Database database, ClientDescriptor.Driver driver, int n3) {
        Message message = null;
        ProductInformation.Driver.DriverKind driverKind = null;
        JSONArray jSONArray = new JSONArray();
        jSONArray.add((Object)n2);
        driverKind = this.getDriverKind(driver);
        jSONArray.add(this.createDatabaseArray(database, driverKind, n3));
        message = new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
        return message;
    }

    private JSONArray createDatabaseProfileArray(Profile.Database database, ProductInformation.Driver.DriverKind driverKind, int n2) {
        JSONArray jSONArray = null;
        if (database != null) {
            jSONArray = new JSONArray();
            jSONArray.add(database.getName());
            jSONArray.add((Object)database.getVersion());
            jSONArray.add(JSONHelper.createJSONObjectFromStringMap(driverKind == null || driverKind == ProductInformation.Driver.DriverKind.JCC ? database.getJccDirectives() : null));
            jSONArray.add(JSONHelper.createJSONObjectFromStringMap(driverKind == null || driverKind == ProductInformation.Driver.DriverKind.CLI || driverKind == ProductInformation.Driver.DriverKind.DOTNET ? database.getCliDirectives() : null));
            jSONArray.add(JSONHelper.createJSONObjectFromStringMap(driverKind == null || driverKind == ProductInformation.Driver.DriverKind.DOTNET ? database.getDotNetDirectives() : null));
            jSONArray.add(JSONHelper.createJSONObjectFromStringMap(driverKind == null || driverKind == ProductInformation.Driver.DriverKind.JCC ? database.getWasDirectives() : null));
            jSONArray.add(JSONHelper.createJSONObjectFromStringMap(database.getCmxDirectives()));
            jSONArray.add(this.createClientInfoRemappingRulesArray(database.getTransactionRemappingRules(), n2));
            jSONArray.add(this.createClientInfoPenaltyBoxRulesArray(database.getTransactionPenaltyBoxRules(), driverKind, n2));
            if (n2 >= 9) {
                if (database.getSpecialRegisters() != null) {
                    jSONArray.add(JSONHelper.createJSONObjectFromProperties(database.getSpecialRegisters()));
                } else {
                    jSONArray.add((Object)null);
                }
            }
        }
        return jSONArray;
    }

    private JSONArray createDatabaseArray(Database database, ProductInformation.Driver.DriverKind driverKind, int n2) {
        Profile.Database database2 = null;
        JSONArray jSONArray = null;
        if (database != null) {
            jSONArray = new JSONArray();
            jSONArray.add(database.getLogicalName());
            jSONArray.add((Object)database.getVersion());
            jSONArray.add(database.getServerName());
            jSONArray.add((Object)database.getPort());
            jSONArray.add(database.getDatabaseName());
            jSONArray.add((Object)database.getVersionOfLastPhysicalLocationChange());
            database2 = database.getDatabaseProfile();
            jSONArray.add(this.createDatabaseProfileArray(database2, driverKind, n2));
        }
        return jSONArray;
    }

    private JSONArray createFinalClientInfoSubstitutionPatternsArray(String[] stringArray, int n2) {
        JSONArray jSONArray = null;
        if (stringArray != null && stringArray.length > 0) {
            jSONArray = new JSONArray();
            jSONArray.add(stringArray[0]);
            jSONArray.add(stringArray[1]);
            jSONArray.add(stringArray[2]);
            jSONArray.add(stringArray[3]);
            if (n2 >= 10) {
                jSONArray.add(stringArray[4]);
            }
        }
        return jSONArray;
    }

    private JSONArray createConditionsOfSubstitutionArray(int[] nArray, int n2) {
        JSONArray jSONArray = null;
        if (nArray != null && nArray.length > 0) {
            jSONArray = new JSONArray();
            jSONArray.add((Object)nArray[0]);
            jSONArray.add((Object)nArray[1]);
            jSONArray.add((Object)nArray[2]);
            jSONArray.add((Object)nArray[3]);
            if (n2 >= 10) {
                jSONArray.add((Object)nArray[4]);
            }
        }
        return jSONArray;
    }

    private JSONArray createClientInfoRemappingRulesArray(TransactionRule.Remapping[] remappingArray, int n2) {
        JSONArray jSONArray = null;
        if (remappingArray == null || remappingArray.length == 0) {
            return null;
        }
        if (n2 < 6) {
            return this.createClientInfoRemappingArray(remappingArray[0], n2);
        }
        jSONArray = new JSONArray();
        int n3 = remappingArray.length;
        for (int i10 = 0; i10 < n3; ++i10) {
            if (n2 < 8 && remappingArray[i10] != null && (remappingArray[i10].getFlavor() == TransactionRule.Remapping.Flavor.literalSubstitutionWithPreliminaryPatternedSubstringExtraction || remappingArray[i10].getFlavor() == TransactionRule.Remapping.Flavor.literalSubstitutionWithPreliminaryPositionedSubstringExtraction)) continue;
            jSONArray.add(this.createClientInfoRemappingArray(remappingArray[i10], n2));
        }
        return jSONArray;
    }

    private JSONArray createClientInfoRemappingArray(TransactionRule.Remapping remapping, int n2) {
        JSONArray jSONArray = null;
        if (remapping != null) {
            JSONArray jSONArray2;
            Object object;
            jSONArray = new JSONArray();
            HashMap<ClientInfo, ClientInfo> hashMap = remapping.getHashMap();
            JSONArray jSONArray3 = new JSONArray();
            if (hashMap != null && hashMap.size() > 0) {
                for (Map.Entry object22 : hashMap.entrySet()) {
                    object = null;
                    if (object22.getKey() != null) {
                        object = new JSONArray();
                        ((JSONArray)object).add(((ClientInfo)object22.getKey()).getUser());
                        ((JSONArray)object).add(((ClientInfo)object22.getKey()).getWorkstation());
                        ((JSONArray)object).add(((ClientInfo)object22.getKey()).getApplication());
                        ((JSONArray)object).add(((ClientInfo)object22.getKey()).getAccounting());
                        if (n2 >= 10) {
                            ((JSONArray)object).add(((ClientInfo)object22.getKey()).getCorrelationToken());
                        }
                    }
                    jSONArray2 = null;
                    if (object22.getValue() != null) {
                        jSONArray2 = new JSONArray();
                        jSONArray2.add(((ClientInfo)object22.getValue()).getUser());
                        jSONArray2.add(((ClientInfo)object22.getValue()).getWorkstation());
                        jSONArray2.add(((ClientInfo)object22.getValue()).getApplication());
                        jSONArray2.add(((ClientInfo)object22.getValue()).getAccounting());
                        if (n2 >= 10) {
                            jSONArray2.add(((ClientInfo)object22.getValue()).getCorrelationToken());
                        }
                    }
                    jSONArray3.add(object);
                    jSONArray3.add(jSONArray2);
                }
            }
            jSONArray.add(jSONArray3);
            Object object3 = remapping.getClientInfoFieldsToIgnoreInKey();
            JSONArray jSONArray4 = this.createClientInfoFieldsToIgnoreArray((boolean[])object3, n2);
            jSONArray.add(jSONArray4);
            object = remapping.getSubstringExtractionPatternsForClientInfo();
            jSONArray2 = this.createSubstringExtractionPatternsForClientInfoArray((String[])object, n2);
            jSONArray.add(jSONArray2);
            int[][] nArray = remapping.getSubstringExtractionPositionsForClientInfo();
            JSONArray jSONArray5 = this.createSubstringExtractionPositionsForClientInfoArray(nArray);
            jSONArray.add(jSONArray5);
            String[] stringArray = remapping.getFinalClientInfoSubstitutionPatterns();
            JSONArray jSONArray6 = this.createFinalClientInfoSubstitutionPatternsArray(stringArray, n2);
            jSONArray.add(jSONArray6);
            int[] nArray2 = remapping.getConditionsOfSubstitution();
            JSONArray jSONArray7 = this.createConditionsOfSubstitutionArray(nArray2, n2);
            jSONArray.add(jSONArray7);
            if (n2 >= 8) {
                jSONArray.add(remapping.getFlavor().toString());
            }
        }
        return jSONArray;
    }

    private JSONArray createClientInfoFieldsToIgnoreArray(boolean[] blArray, int n2) {
        JSONArray jSONArray = null;
        if (blArray != null && blArray.length > 0) {
            jSONArray = new JSONArray();
            jSONArray.add((Object)blArray[0]);
            jSONArray.add((Object)blArray[1]);
            jSONArray.add((Object)blArray[2]);
            jSONArray.add((Object)blArray[3]);
            if (n2 >= 10) {
                jSONArray.add((Object)blArray[4]);
            }
        }
        return jSONArray;
    }

    private JSONArray createSubstringExtractionPatternsForClientInfoArray(String[] stringArray, int n2) {
        JSONArray jSONArray = null;
        if (stringArray != null && stringArray.length > 0) {
            jSONArray = new JSONArray();
            jSONArray.add(stringArray[0]);
            jSONArray.add(stringArray[1]);
            jSONArray.add(stringArray[2]);
            jSONArray.add(stringArray[3]);
            if (n2 >= 10) {
                jSONArray.add(stringArray[4]);
            }
        }
        return jSONArray;
    }

    private JSONArray createSubstringExtractionPositionsForClientInfoArray(int[][] nArray) {
        JSONArray jSONArray = null;
        if (nArray != null && nArray.length > 0) {
            jSONArray = new JSONArray();
            for (int i10 = 0; i10 < nArray.length; ++i10) {
                int[] nArray2 = nArray[i10];
                JSONArray jSONArray2 = null;
                if (nArray2 != null) {
                    jSONArray2 = new JSONArray();
                    jSONArray2.add((Object)nArray2[0]);
                    jSONArray2.add((Object)nArray2[1]);
                }
                jSONArray.add(jSONArray2);
            }
        }
        return jSONArray;
    }

    private JSONArray createClientInfoPenaltyBoxRulesArray(TransactionRule.PenaltyBox[] penaltyBoxArray, ProductInformation.Driver.DriverKind driverKind, int n2) {
        JSONArray jSONArray = null;
        if (penaltyBoxArray != null) {
            if (n2 < 6) {
                if (penaltyBoxArray.length > 0) {
                    return this.createClientInfoPenaltyBoxRuleArray(penaltyBoxArray[0], driverKind, n2);
                }
            } else {
                jSONArray = new JSONArray();
                for (int i10 = 0; i10 < penaltyBoxArray.length; ++i10) {
                    jSONArray.add(this.createClientInfoPenaltyBoxRuleArray(penaltyBoxArray[i10], driverKind, n2));
                }
            }
        }
        return jSONArray;
    }

    private JSONArray createClientInfoPenaltyBoxRuleArray(TransactionRule.PenaltyBox penaltyBox, ProductInformation.Driver.DriverKind driverKind, int n2) {
        JSONArray jSONArray = null;
        if (penaltyBox != null) {
            JSONArray jSONArray2;
            Object object;
            jSONArray = new JSONArray();
            HashMap<ClientInfo, Database> hashMap = penaltyBox.getHashMap();
            JSONArray jSONArray3 = new JSONArray();
            if (hashMap != null && hashMap.size() > 0) {
                for (Map.Entry object22 : hashMap.entrySet()) {
                    object = null;
                    if (object22.getKey() != null) {
                        object = new JSONArray();
                        ((JSONArray)object).add(((ClientInfo)object22.getKey()).getUser());
                        ((JSONArray)object).add(((ClientInfo)object22.getKey()).getWorkstation());
                        ((JSONArray)object).add(((ClientInfo)object22.getKey()).getApplication());
                        ((JSONArray)object).add(((ClientInfo)object22.getKey()).getAccounting());
                        if (n2 >= 10) {
                            ((JSONArray)object).add(((ClientInfo)object22.getKey()).getCorrelationToken());
                        }
                    }
                    jSONArray2 = this.createDatabaseArray((Database)object22.getValue(), driverKind, n2);
                    jSONArray3.add(object);
                    jSONArray3.add(jSONArray2);
                }
            }
            jSONArray.add(jSONArray3);
            Object object3 = penaltyBox.getClientInfoFieldsToIgnore();
            JSONArray jSONArray4 = this.createClientInfoFieldsToIgnoreArray((boolean[])object3, n2);
            jSONArray.add(jSONArray4);
            object = penaltyBox.getSubstringExtractionPatternsForClientInfo();
            jSONArray2 = this.createSubstringExtractionPatternsForClientInfoArray((String[])object, n2);
            jSONArray.add(jSONArray2);
            int[][] nArray = penaltyBox.getSubstringExtractionPositionsForClientInfo();
            JSONArray jSONArray5 = this.createSubstringExtractionPositionsForClientInfoArray(nArray);
            jSONArray.add(jSONArray5);
            if (n2 >= 8) {
                jSONArray.add(penaltyBox.getFlavor().toString());
            }
        }
        return jSONArray;
    }

    private JSONArray createDataSourceProfileArray(Profile.DataSource dataSource, ProductInformation.Driver.DriverKind driverKind, int n2) {
        JSONArray jSONArray = null;
        if (dataSource != null) {
            jSONArray = new JSONArray();
            jSONArray.add(dataSource.getName());
            jSONArray.add((Object)dataSource.getVersion());
            jSONArray.add(JSONHelper.createJSONObjectFromStringMap(driverKind == null || driverKind == ProductInformation.Driver.DriverKind.JCC ? dataSource.getJccDirectives() : null));
            jSONArray.add(JSONHelper.createJSONObjectFromStringMap(driverKind == null || driverKind == ProductInformation.Driver.DriverKind.CLI ? dataSource.getCliDirectives() : null));
            jSONArray.add(JSONHelper.createJSONObjectFromStringMap(driverKind == null || driverKind == ProductInformation.Driver.DriverKind.DOTNET ? dataSource.getDotNetDirectives() : null));
            jSONArray.add(JSONHelper.createJSONObjectFromStringMap(driverKind == null || driverKind == ProductInformation.Driver.DriverKind.JCC ? dataSource.getWasDirectives() : null));
            jSONArray.add(JSONHelper.createJSONObjectFromStringMap(dataSource.getCmxDirectives()));
            jSONArray.add(this.createClientInfoRemappingRulesArray(dataSource.getTransactionRemappingRules(), n2));
            jSONArray.add(this.createClientInfoPenaltyBoxRulesArray(dataSource.getTransactionPenaltyBoxRules(), driverKind, n2));
            jSONArray.add(this.createDatabaseArray(dataSource.getTargetDatabase(), driverKind, n2));
            jSONArray.add(this.createDatabaseArray(dataSource.getRerouteDatabase(), driverKind, n2));
            jSONArray.add(this.createDatabaseArray(dataSource.getRedirectDatabase(), driverKind, n2));
            if (n2 >= 9) {
                if (dataSource.getSpecialRegisters() != null) {
                    jSONArray.add(JSONHelper.createJSONObjectFromProperties(dataSource.getSpecialRegisters()));
                } else {
                    jSONArray.add((Object)null);
                }
            }
        }
        return jSONArray;
    }

    public Message createRegisterDataSourceReply(int n2, String string, Profile.DataSource dataSource, ClientDescriptor.DataSource dataSource2, int n3) {
        Message message = null;
        ProductInformation.Driver.DriverKind driverKind = null;
        JSONArray jSONArray = new JSONArray();
        jSONArray.add((Object)n2);
        jSONArray.add(string);
        driverKind = this.getDriverKind(dataSource2);
        jSONArray.add(this.createDataSourceProfileArray(dataSource, driverKind, n3));
        message = new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
        return message;
    }

    Message createLookupDatabaseRequest(String string, long l8, int n2) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add("5");
        jSONArray.add(string);
        jSONArray.add((Object)l8);
        return new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
    }

    private Profile.Database parseDatabaseProfile(JSONArray jSONArray, int n2) {
        HashMap<String, String> hashMap = null;
        HashMap<String, String> hashMap2 = null;
        HashMap<String, String> hashMap3 = null;
        HashMap<String, String> hashMap4 = null;
        HashMap<String, String> hashMap5 = null;
        TransactionRule.Remapping[] remappingArray = null;
        TransactionRule.PenaltyBox[] penaltyBoxArray = null;
        String string = null;
        long l8 = -1L;
        Profile.Database database = null;
        Properties properties = null;
        if (jSONArray != null && jSONArray.size() > 0) {
            string = (String)jSONArray.get(0);
            l8 = ((Number)jSONArray.get(1)).longValue();
            hashMap = JSONHelper.createStringHashMapFromJSONArray(jSONArray, 2);
            hashMap2 = JSONHelper.createStringHashMapFromJSONArray(jSONArray, 3);
            hashMap3 = JSONHelper.createStringHashMapFromJSONArray(jSONArray, 4);
            hashMap4 = JSONHelper.createStringHashMapFromJSONArray(jSONArray, 5);
            hashMap5 = JSONHelper.createStringHashMapFromJSONArray(jSONArray, 6);
            remappingArray = this.parseClientInfoRemappingRules((JSONArray)jSONArray.get(7), n2);
            penaltyBoxArray = this.parseClientInfoPenaltyBoxRules((JSONArray)jSONArray.get(8), n2);
            if (n2 >= 9 && jSONArray.size() > 9 && jSONArray.get(9) != null) {
                properties = JSONHelper.createPropertiesFromJSONArray(jSONArray, 9);
            }
            database = new Profile.Database(string, l8, properties, hashMap, hashMap2, hashMap3, hashMap4, hashMap5, remappingArray, penaltyBoxArray);
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Database parseDatabase(JSONArray jSONArray, int n2, boolean bl2) {
        Database database = null;
        Database database2 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        long l8 = -1L;
        long l9 = -1L;
        int n3 = -1;
        Profile.Database database3 = null;
        if (jSONArray != null && jSONArray.size() > 0) {
            Map<String, Database> map = ControlDriver.getInstance().getDatabasesMap();
            string = (String)jSONArray.get(0);
            l8 = ((Number)jSONArray.get(1)).longValue();
            string2 = (String)jSONArray.get(2);
            n3 = ((Number)jSONArray.get(3)).intValue();
            string3 = (String)jSONArray.get(4);
            l9 = ((Number)jSONArray.get(5)).longValue();
            database3 = this.parseDatabaseProfile((JSONArray)jSONArray.get(6), n2);
            database = new Database(string, l8, string2, n3, string3, l9, database3);
            Map<String, Database> map2 = map;
            synchronized (map2) {
                if (bl2 && string != null) {
                    database2 = map.get(string);
                    if (database2 == null) {
                        map.put(string, database);
                    } else {
                        database2.updateToNewVersion(database);
                        database = database2;
                    }
                }
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseLookupDatabaseReply(String string, Message message, int n2) {
        if (clientLogger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(clientLogger__, this, "parseLookupDatabaseReply", "ENTRY " + Arrays.deepToString(new Object[]{string}));
        }
        int n3 = 0;
        Map<String, Database> map = ControlDriver.getInstance().getDatabasesMap();
        JSONArray jSONArray = JSONHelper.convertJSONByteBuffer(message);
        JSONArray jSONArray2 = null;
        n3 = ((Number)jSONArray.get(0)).intValue();
        Map<String, Database> map2 = map;
        synchronized (map2) {
            Database database = map.get(string);
            Database database2 = null;
            if (n3 == 1 && database != null) {
                jSONArray2 = (JSONArray)jSONArray.get(1);
                database2 = this.parseDatabase(jSONArray2, n2, true);
                if (database2 != null) {
                    if (clientLogger__.isLoggable(Level.FINE)) {
                        DataLogger.logConnectedComponents(clientLogger__, this, "parseLookupDatabaseReply", "New database retrieved with logical name " + database2.getLogicalName() + ", database server name " + database2.getServerName() + ", database port  " + database2.getPort() + ", database name " + database2.getDatabaseName());
                    }
                } else {
                    if (clientLogger__.isLoggable(Level.FINE)) {
                        DataLogger.logConnectedComponents(clientLogger__, this, "parseLookupDatabaseReply", "Null database retrieved");
                    }
                    database2 = ControlDataSourceImpl.getEmptyDatabase();
                    map.remove(string);
                }
            }
        }
    }

    Message createRegisterDriverRequest(Map<String, Object> map, String string, String string2, long l8, int n2) {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject = new JSONObject();
        if (map != null) {
            this.setDriverDescriptorProperties(jSONObject, map);
        } else if (string != null) {
            jSONObject.put("driverId", string);
            jSONObject.put("driverProfileName", string2);
            jSONObject.put("driverProfileVersion", (Object)l8);
        } else {
            jSONObject = null;
        }
        jSONArray.add("4");
        jSONArray.add(jSONObject);
        return new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
    }

    private ProductInformation.OCM parseOCMServerProductInformation(JSONArray jSONArray) {
        ProductInformation.OCM oCM = null;
        if (jSONArray != null) {
            oCM = new ProductInformation.OCM((String)jSONArray.get(0), ((Number)jSONArray.get(1)).intValue(), ((Number)jSONArray.get(2)).intValue(), ((Number)jSONArray.get(3)).intValue(), (String)jSONArray.get(4), ProductInformation.Basic.BuildCertification.valueOf((String)jSONArray.get(5)));
        }
        return oCM;
    }

    private ProductInformation.CMX parseCMXServerProductInformation(JSONArray jSONArray) {
        ProductInformation.CMX cMX = null;
        if (jSONArray != null) {
            cMX = new ProductInformation.CMX((String)jSONArray.get(0), ((Number)jSONArray.get(1)).intValue(), ((Number)jSONArray.get(2)).intValue(), ((Number)jSONArray.get(3)).intValue(), (String)jSONArray.get(4), ProductInformation.Basic.BuildCertification.valueOf((String)jSONArray.get(5)), ((Number)jSONArray.get(6)).intValue());
        }
        return cMX;
    }

    private ProductInformation.Server parseServerProductInformation(JSONArray jSONArray) {
        ProductInformation.Server server = null;
        ProductInformation.OCM oCM = null;
        ProductInformation.CMX cMX = null;
        if (jSONArray != null && jSONArray.size() > 0) {
            oCM = this.parseOCMServerProductInformation((JSONArray)jSONArray.get(0));
            cMX = this.parseCMXServerProductInformation((JSONArray)jSONArray.get(1));
            server = new ProductInformation.Server(oCM, cMX);
        }
        return server;
    }

    private Profile.Driver parseDriverProfile(JSONArray jSONArray, int n2) {
        Profile.Driver driver = null;
        String string = null;
        Properties properties = null;
        long l8 = -1L;
        int n3 = 120;
        int n4 = 900;
        int n5 = 1000;
        HashMap<String, String> hashMap = null;
        HashMap<String, String> hashMap2 = null;
        HashMap<String, String> hashMap3 = null;
        HashMap<String, String> hashMap4 = null;
        HashMap<String, String> hashMap5 = null;
        if (jSONArray != null && jSONArray.size() > 0) {
            string = (String)jSONArray.get(0);
            l8 = ((Number)jSONArray.get(1)).longValue();
            hashMap = JSONHelper.createStringHashMapFromJSONArray(jSONArray, 2);
            hashMap2 = JSONHelper.createStringHashMapFromJSONArray(jSONArray, 3);
            hashMap3 = JSONHelper.createStringHashMapFromJSONArray(jSONArray, 4);
            hashMap4 = JSONHelper.createStringHashMapFromJSONArray(jSONArray, 5);
            hashMap5 = JSONHelper.createStringHashMapFromJSONArray(jSONArray, 6);
            n3 = ((Number)jSONArray.get(7)).intValue();
            n4 = ((Number)jSONArray.get(8)).intValue();
            n5 = ((Number)jSONArray.get(9)).intValue();
            if (n2 >= 9 && jSONArray.size() > 10 && jSONArray.get(10) != null) {
                properties = JSONHelper.createPropertiesFromJSONArray(jSONArray, 10);
            }
            driver = new Profile.Driver(string, l8, properties, hashMap, hashMap2, hashMap3, hashMap4, hashMap5, n3, n4, n5);
        }
        return driver;
    }

    void parseRegisterDriverReply(Message message, int n2, String string) {
        if (clientLogger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(clientLogger__, this, "parseRegisterDriverReply", "ENTRY " + Arrays.deepToString(new Object[0]));
        }
        if (message == null && string == null) {
            return;
        }
        int n3 = 0;
        String string2 = null;
        JSONArray jSONArray = null;
        if (string != null) {
            try {
                jSONArray = JSONArray.parse(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            jSONArray = JSONHelper.convertJSONByteBuffer(message);
        }
        Profile.Driver driver = null;
        ProductInformation.Server server = null;
        n3 = ((Number)jSONArray.get(0)).intValue();
        string2 = (String)jSONArray.get(1);
        if (string2 != null) {
            ControlDriver.getInstance().getDriverDescriptorMap().put("driverId", string2);
        }
        if (n3 == 1) {
            driver = this.parseDriverProfile((JSONArray)jSONArray.get(2), n2);
            if (driver != null) {
                if (clientLogger__.isLoggable(Level.FINE)) {
                    DataLogger.logConnectedComponents(clientLogger__, this, "parseRegisterDriverReply", "New driver profile retrieved with profile name " + driver.getName() + ", profile version " + driver.getVersion());
                }
                ControlDriver.getInstance().getDriverProfile().updateToNewVersion(driver);
                ControlDriver.getInstance().setRegisterDriverInterval(driver.getPollingInterval());
                ControlDriver.getInstance().setLogStatisticsInterval(driver.getStatisticsCollectionInterval());
            }
        } else if (n3 == 2) {
            if (clientLogger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(clientLogger__, this, "parseRegisterDriverReply", "Resetting driver profile" + ControlDriver.getInstance().getDriverProfile());
            }
            ControlDriver.getInstance().getDriverDescriptorMap().put("driverId", null);
            driver = ControlDriver.getInstance().getEmptyDriverProfile();
            ControlDriver.getInstance().getDriverProfile().updateToNewVersion(driver);
        }
        ControlDriver.getInstance().setLookupReplyFlag(n3);
        server = this.parseServerProductInformation((JSONArray)jSONArray.get(3));
        ControlDriver.getInstance().setServerProductInformation(server);
    }

    private void setDataSourceProperties(JSONObject jSONObject, Map<String, Object> map, String string, int n2, String string2) {
        JSONObject jSONObject2 = null;
        jSONObject.put("dsDescriptorProfileName", map.get("dsDescriptorProfileName"));
        jSONObject.put("dsDescriptorJDBCDSName", map.get("dsDescriptorJDBCDSName"));
        jSONObject.put("dsDescriptorWASMaxPoolSize", map.get("dsDescriptorWASMaxPoolSize"));
        jSONObject.put("dsDescriptorWASJNDIDSName", map.get("dsDescriptorWASJNDIDSName"));
        jSONObject.put("dsDescriptorDBServer", string);
        jSONObject.put("dsDescriptorDBPort", (Object)n2);
        jSONObject.put("dsDescriptorDBName", string2);
        jSONObject2 = JSONHelper.createJSONObjectFromMap((HashMap)map.get("dsDescriptorClientPropertySettings"));
        jSONObject.put("dsDescriptorClientPropertySettings", jSONObject2);
    }

    Message createRegisterDataSourceRequest(Map<String, Object> map, String string, String string2, long l8, String string3, int n2, String string4, int n3) {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject = new JSONObject();
        if (map != null) {
            this.setDriverDescriptorProperties(jSONObject, ControlDriver.getInstance().getDriverDescriptorMap());
            this.setDataSourceProperties(jSONObject, map, string3, n2, string4);
        } else if (string != null) {
            jSONObject.put("dataSourceId", string);
            jSONObject.put("dataSourceProfileName", string2);
            jSONObject.put("dataSourceProfileVersion", (Object)l8);
        } else {
            jSONObject = null;
        }
        jSONArray.add("6");
        jSONArray.add(jSONObject);
        return new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
    }

    private Profile.DataSource parseDataSourceProfile(JSONArray jSONArray, int n2) {
        Profile.DataSource dataSource = null;
        String string = null;
        long l8 = -1L;
        TransactionRule.Remapping[] remappingArray = null;
        TransactionRule.PenaltyBox[] penaltyBoxArray = null;
        Database database = null;
        Database database2 = null;
        Database database3 = null;
        Properties properties = null;
        if (jSONArray != null && jSONArray.size() > 0) {
            string = (String)jSONArray.get(0);
            l8 = ((Number)jSONArray.get(1)).longValue();
            HashMap<String, String> hashMap = JSONHelper.createStringHashMapFromJSONArray(jSONArray, 2);
            HashMap<String, String> hashMap2 = JSONHelper.createStringHashMapFromJSONArray(jSONArray, 3);
            HashMap<String, String> hashMap3 = JSONHelper.createStringHashMapFromJSONArray(jSONArray, 4);
            HashMap<String, String> hashMap4 = JSONHelper.createStringHashMapFromJSONArray(jSONArray, 5);
            HashMap<String, String> hashMap5 = JSONHelper.createStringHashMapFromJSONArray(jSONArray, 6);
            remappingArray = this.parseClientInfoRemappingRules((JSONArray)jSONArray.get(7), n2);
            penaltyBoxArray = this.parseClientInfoPenaltyBoxRules((JSONArray)jSONArray.get(8), n2);
            database = this.parseDatabase((JSONArray)jSONArray.get(9), n2, true);
            database2 = this.parseDatabase((JSONArray)jSONArray.get(10), n2, false);
            database3 = this.parseDatabase((JSONArray)jSONArray.get(11), n2, true);
            if (n2 >= 9 && jSONArray.size() > 12 && jSONArray.get(12) != null) {
                properties = JSONHelper.createPropertiesFromJSONArray(jSONArray, 12);
            }
            dataSource = new Profile.DataSource(string, l8, properties, hashMap, hashMap2, hashMap3, hashMap4, hashMap5, remappingArray, penaltyBoxArray, database, database2, database3);
        }
        return dataSource;
    }

    void parseRegisterDataSourceReply(Message message, ControlDataSourceImpl controlDataSourceImpl, int n2, String string) {
        if (clientLogger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(clientLogger__, this, "parseRegisterDataSourceReply", "ENTRY " + Arrays.deepToString(new Object[]{controlDataSourceImpl}));
        }
        if (message == null && string == null) {
            return;
        }
        int n3 = 0;
        String string2 = null;
        ControlDriver controlDriver = ControlDriver.getInstance();
        Profile.DataSource dataSource = null;
        JSONArray jSONArray = null;
        if (string != null) {
            try {
                jSONArray = JSONArray.parse(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            jSONArray = JSONHelper.convertJSONByteBuffer(message);
        }
        Profile.DataSource dataSource2 = null;
        n3 = ((Number)jSONArray.get(0)).intValue();
        string2 = (String)jSONArray.get(1);
        if (string2 != null) {
            controlDataSourceImpl.getDataSourceDescriptorMap().put("dataSourceId", string2);
        }
        if (n3 == 1) {
            dataSource = this.parseDataSourceProfile((JSONArray)jSONArray.get(2), n2);
            if (dataSource != null) {
                if (clientLogger__.isLoggable(Level.FINE)) {
                    DataLogger.logConnectedComponents(clientLogger__, this, "parseRegisterDataSourceReply", "New datasource profile retrieved with profile name " + dataSource.getName() + ", profile version " + dataSource.getVersion());
                }
                dataSource2 = controlDataSourceImpl.getDataSourceProfile();
                dataSource2.updateToNewVersion(dataSource);
            }
        } else if (n3 == 2) {
            if (clientLogger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(clientLogger__, this, "parseRegisterDataSourceReply", "Resetting datasource profile " + controlDataSourceImpl.getDataSourceProfile());
            }
            controlDataSourceImpl.getDataSourceDescriptorMap().put("dataSourceId", null);
            dataSource = ControlDataSourceImpl.getEmptyDataSourceProfile();
            dataSource2 = controlDataSourceImpl.getDataSourceProfile();
            dataSource2.updateToNewVersion(dataSource);
        }
        controlDataSourceImpl.setLookupReplyFlag(n3);
        controlDataSourceImpl.getDataSourceDescriptorMap().put("driverId", controlDriver.getDriverDescriptorMap().get("driverId"));
        controlDataSourceImpl.updateVersion();
    }

    Message createLogLookupMessage(String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add("9");
        jSONArray.add(string);
        jSONArray.add(string2);
        jSONArray.add(string3);
        jSONArray.add(string4);
        jSONArray.add(string5);
        jSONArray.add(string6);
        jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray));
        jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray2));
        jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray3));
        jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray4));
        jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray5));
        return new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
    }

    private JSONArray createSQLExceptionCauseArray(SQLException sQLException) {
        JSONArray jSONArray = null;
        if (sQLException.getCause() != null) {
            Throwable throwable = sQLException.getCause();
            jSONArray = new JSONArray();
            do {
                JSONArray jSONArray2 = new JSONArray();
                jSONArray2.add(throwable.getMessage());
                jSONArray.add(jSONArray2);
            } while ((throwable = throwable.getCause()) != null);
        }
        return jSONArray;
    }

    private JSONArray createSQLExceptionArray(SQLException sQLException) {
        JSONArray jSONArray = null;
        if (sQLException != null) {
            jSONArray = new JSONArray();
            do {
                JSONArray jSONArray2 = new JSONArray();
                jSONArray2.add(sQLException.getMessage());
                jSONArray2.add(sQLException.getSQLState());
                jSONArray2.add((Object)sQLException.getErrorCode());
                jSONArray2.add(this.createSQLExceptionCauseArray(sQLException));
                jSONArray.add(jSONArray2);
            } while ((sQLException = sQLException.getNextException()) != null);
        }
        return jSONArray;
    }

    Message createLogApplicationExceptionMessage(String string, String string2, String string3, MonitorInterface.ClientRuntime clientRuntime, SQLException sQLException) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add("10");
        jSONArray.add(string);
        jSONArray.add(string2);
        jSONArray.add(string3);
        jSONArray.add(clientRuntime.toString());
        jSONArray.add(this.createSQLExceptionArray(sQLException));
        return new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
    }

    private JSONArray createPushDownErrorsArray(ArrayList<PushDownError> arrayList) {
        JSONArray jSONArray = null;
        if (arrayList != null) {
            jSONArray = new JSONArray();
            for (PushDownError pushDownError : arrayList) {
                JSONArray jSONArray2 = null;
                if (pushDownError != null) {
                    jSONArray2 = new JSONArray();
                    jSONArray2.add(pushDownError.getErrorType().toString());
                    jSONArray2.add(pushDownError.getPropertyName());
                    jSONArray2.add(pushDownError.getPushDownLevel().toString());
                    if (pushDownError.getErrorType() == PushDownError.ErrorType.sqlException) {
                        SQLException sQLException = ((PushDownError.SQLException)pushDownError).getSQLException();
                        jSONArray2.add(this.createSQLExceptionArray(sQLException));
                    }
                }
                jSONArray.add(jSONArray2);
            }
        }
        return jSONArray;
    }

    public Message createLogPushDownErrorsMessage(String string, String string2, String string3, MonitorInterface.ClientRuntime clientRuntime, ArrayList<PushDownError> arrayList) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add("11");
        jSONArray.add(string);
        jSONArray.add(string2);
        jSONArray.add(string3);
        jSONArray.add(clientRuntime.toString());
        jSONArray.add(this.createPushDownErrorsArray(arrayList));
        return new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
    }

    public HashSet<ClientInfo>[] clientInfoSetsListToArray(ArrayList<HashSet<ClientInfo>> arrayList) {
        HashSet[] hashSetArray = null;
        if (arrayList != null) {
            hashSetArray = new HashSet[arrayList.size()];
            for (int i10 = 0; i10 < arrayList.size(); ++i10) {
                hashSetArray[i10] = arrayList.get(i10);
            }
        }
        return hashSetArray;
    }

    private JSONArray createClientInfoSetsArray(Set<ClientInfo>[] setArray, int n2) {
        JSONArray jSONArray = null;
        if (setArray != null) {
            jSONArray = new JSONArray();
            for (Set<ClientInfo> set : setArray) {
                JSONArray jSONArray2 = null;
                if (set != null) {
                    jSONArray2 = new JSONArray();
                    for (ClientInfo clientInfo : set) {
                        JSONArray jSONArray3 = null;
                        if (clientInfo != null) {
                            jSONArray3 = new JSONArray();
                            jSONArray3.add(clientInfo.getInfoString(0));
                            jSONArray3.add(clientInfo.getInfoString(1));
                            jSONArray3.add(clientInfo.getInfoString(2));
                            jSONArray3.add(clientInfo.getInfoString(3));
                            if (n2 >= 10) {
                                jSONArray3.add(clientInfo.getInfoString(4));
                            }
                        }
                        jSONArray2.add(jSONArray3);
                    }
                }
                jSONArray.add(jSONArray2);
            }
        }
        return jSONArray;
    }

    private JSONArray createMemberAllocationArray(TransportPoolStatistics.MemberAllocation[] memberAllocationArray) {
        JSONArray jSONArray = null;
        if (memberAllocationArray != null) {
            jSONArray = new JSONArray();
            for (int i10 = 0; i10 < memberAllocationArray.length; ++i10) {
                JSONArray jSONArray2 = null;
                if (memberAllocationArray[i10] != null) {
                    jSONArray2 = new JSONArray();
                    jSONArray2.add(memberAllocationArray[i10].getMemberAddress());
                    jSONArray2.add((Object)memberAllocationArray[i10].getMemberPort());
                    jSONArray2.add((Object)memberAllocationArray[i10].getInUseTransports());
                    jSONArray2.add((Object)memberAllocationArray[i10].getFreeTransports());
                }
                jSONArray.add(jSONArray2);
            }
        }
        return jSONArray;
    }

    private JSONObject createTransportPoolStatisticsObject(HashMap<String, TransportPoolStatistics> hashMap) {
        JSONObject jSONObject = null;
        if (hashMap != null) {
            jSONObject = new JSONObject();
            for (Map.Entry<String, TransportPoolStatistics> entry : hashMap.entrySet()) {
                if (entry == null) continue;
                JSONArray jSONArray = null;
                if (entry.getValue() != null) {
                    jSONArray = new JSONArray();
                    jSONArray.add(this.createMemberAllocationArray(entry.getValue().getMemberAllocations()));
                    jSONArray.add((Object)entry.getValue().getAgedOutObjectCount());
                    jSONArray.add((Object)entry.getValue().getCreatedObjectCount());
                    jSONArray.add((Object)entry.getValue().getHeavyWeightReusedObjectCount());
                    jSONArray.add((Object)entry.getValue().getLightWeightReusedObjectCount());
                    jSONArray.add(entry.getValue().getLongestBlockedRequestTime_Precision().toString());
                    jSONArray.add((Object)entry.getValue().getLongestBlockedRequestTime());
                    jSONArray.add((Object)entry.getValue().getNumberOfConnectionReleasesRefused());
                    jSONArray.add((Object)entry.getValue().getNumberOfRequestsBlocked());
                    jSONArray.add((Object)entry.getValue().getNumberOfRequestsBlockedDataSourceMax());
                    jSONArray.add((Object)entry.getValue().getRemovedObjectCount());
                    jSONArray.add(entry.getValue().getShortestBlockedRequestTime_Precision().toString());
                    jSONArray.add((Object)entry.getValue().getShortestBlockedRequestTime());
                    jSONArray.add((Object)entry.getValue().getSuccessfulRequestsFromPool());
                    jSONArray.add((Object)entry.getValue().getTotalPoolObjects());
                    jSONArray.add((Object)entry.getValue().getTotalRequestsToPool());
                    jSONArray.add(entry.getValue().getTotalTimeBlocked_Precision().toString());
                    jSONArray.add((Object)entry.getValue().getTotalTimeBlocked());
                    jSONArray.add((Object)entry.getValue().getHwmForConcurrentlyAllocatedTransports());
                    jSONArray.add((Object)entry.getValue().getNumberOfRequestsBlockedPoolMax());
                }
                jSONObject.put(entry.getKey(), jSONArray);
            }
        }
        return jSONObject;
    }

    Message createLogStatisticsMessage(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, String[] stringArray3, Set<ClientInfo>[] setArray, HashMap<String, TransportPoolStatistics> hashMap, long[][] lArray, Long[] longArray, Object[][] objectArray, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7, long[][] lArray2, int n2) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add("12");
        jSONArray.add(string);
        jSONArray.add(string2);
        jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray));
        jSONArray.add(this.createClientInfoSetsArray(setArray, n2));
        jSONArray.add(this.createTransportPoolStatisticsObject(hashMap));
        if (n2 >= 6) {
            jSONArray.add(string3);
            jSONArray.add(string4);
            jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray2));
            jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray3));
            jSONArray.add(this.createNumberOfTransactionsPenaltyBoxedArray(lArray));
            jSONArray.add(this.createNumberOfTransactionsPenaltyBoxedForDataSourceArray(longArray));
            jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray4));
            jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray5));
            jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray6));
            jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray7));
            jSONArray.add(this.createNumberOfTransactionsPenaltyBoxedArray(lArray2));
            if (n2 >= 8) {
                jSONArray.add(this.createWASPoolStatisticsArray(objectArray));
            }
        }
        return new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
    }

    private JSONArray createNumberOfTransactionsPenaltyBoxedForDataSourceArray(Long[] longArray) {
        JSONArray jSONArray = null;
        int n2 = 0;
        if (longArray != null && longArray.length > 0) {
            jSONArray = new JSONArray();
            for (n2 = 0; n2 < longArray.length; ++n2) {
                jSONArray.add(longArray[n2]);
            }
        }
        return jSONArray;
    }

    private JSONArray createNumberOfTransactionsPenaltyBoxedArray(long[][] lArray) {
        JSONArray jSONArray = null;
        int n2 = 0;
        int n3 = 0;
        if (lArray != null && lArray.length > 0) {
            jSONArray = new JSONArray();
            for (n2 = 0; n2 < lArray.length; ++n2) {
                long[] lArray2 = lArray[n2];
                JSONArray jSONArray2 = null;
                if (lArray2 != null) {
                    jSONArray2 = new JSONArray();
                    for (n3 = 0; n3 < lArray2.length; ++n3) {
                        jSONArray2.add((Object)lArray2[n3]);
                    }
                }
                jSONArray.add(jSONArray2);
            }
        }
        return jSONArray;
    }

    private JSONArray createWASPoolStatisticsArray(Object[][] objectArray) {
        JSONArray jSONArray = null;
        int n2 = 0;
        int n3 = 0;
        if (objectArray != null && objectArray.length > 0) {
            jSONArray = new JSONArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Object[] objectArray2 = objectArray[n2];
                JSONArray jSONArray2 = null;
                if (objectArray2 != null) {
                    jSONArray2 = new JSONArray();
                    for (n3 = 0; n3 < objectArray2.length; ++n3) {
                        jSONArray2.add(objectArray2[n3]);
                    }
                }
                jSONArray.add(jSONArray2);
            }
        }
        return jSONArray;
    }

    Message createLogPushDownApplicationMessage(String string, String string2, Map<String, Object> map, String string3, String string4, String string5, String string6, String[] stringArray, Map<String, Object>[] mapArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, HashMap<String, String>[] hashMapArray, int n2) {
        int n3;
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject = null;
        JSONObject jSONObject2 = null;
        JSONArray jSONArray2 = null;
        JSONObject jSONObject3 = null;
        JSONArray jSONArray3 = null;
        jSONArray.add("13");
        jSONArray.add(string);
        jSONArray.add(string2);
        if (map != null) {
            jSONObject = new JSONObject();
            this.setDriverDescriptorProperties(jSONObject, map);
        }
        jSONArray.add(jSONObject);
        jSONArray.add(string3);
        jSONArray.add(string4);
        jSONArray.add(string5);
        jSONArray.add(string6);
        jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray));
        if (mapArray != null && map != null) {
            jSONArray2 = new JSONArray();
            for (n3 = 0; n3 < mapArray.length; ++n3) {
                if (mapArray[n3] != null) {
                    jSONObject2 = new JSONObject();
                    this.setDriverDescriptorProperties(jSONObject2, map);
                    this.setDataSourceProperties(jSONObject2, mapArray[n3], (String)mapArray[n3].get("dsDescriptorDBServer"), ((Number)mapArray[n3].get("dsDescriptorDBPort")).intValue(), (String)mapArray[n3].get("dsDescriptorDBName"));
                } else {
                    jSONObject2 = null;
                }
                jSONArray2.add(jSONObject2);
            }
        }
        if (hashMapArray != null) {
            jSONArray3 = new JSONArray();
            for (n3 = 0; n3 < hashMapArray.length; ++n3) {
                if (hashMapArray[n3] != null) {
                    jSONObject3 = new JSONObject();
                    jSONObject3.put(ClientProfileUtil.supportedWASDataSourceOrPoolProperties[0], hashMapArray[n3].get(ClientProfileUtil.supportedWASDataSourceOrPoolProperties[0]));
                } else {
                    jSONObject3 = null;
                }
                jSONArray3.add(jSONObject3);
            }
        }
        jSONArray.add(jSONArray2);
        jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray2));
        jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray3));
        jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray4));
        jSONArray.add(JSONHelper.createJSONArrayFromStringArray(stringArray5));
        if (n2 >= 8) {
            jSONArray.add(jSONArray3);
        }
        return new Message("ClientPropertyProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
    }
}

