/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.AzureReachabilityReport;
import com.microsoft.azure.management.network.AzureReachabilityReportItem;
import com.microsoft.azure.management.network.AzureReachabilityReportLocation;
import com.microsoft.azure.management.network.AzureReachabilityReportParameters;
import com.microsoft.azure.management.network.NetworkWatcher;
import com.microsoft.azure.management.network.implementation.AzureReachabilityReportInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NetworkWatcherImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.ExecutableImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class AzureReachabilityReportImpl
extends ExecutableImpl<AzureReachabilityReport>
implements AzureReachabilityReport,
AzureReachabilityReport.Definition {
    private final NetworkWatcherImpl parent;
    private AzureReachabilityReportParameters parameters = new AzureReachabilityReportParameters();
    private AzureReachabilityReportInner inner;

    AzureReachabilityReportImpl(NetworkWatcherImpl parent) {
        this.parent = parent;
    }

    @Override
    public String aggregationLevel() {
        return this.inner.aggregationLevel();
    }

    @Override
    public AzureReachabilityReportLocation providerLocation() {
        return this.inner.providerLocation();
    }

    @Override
    public List<AzureReachabilityReportItem> reachabilityReport() {
        return Collections.unmodifiableList(this.inner.reachabilityReport());
    }

    @Override
    public AzureReachabilityReportParameters azureReachabilityReportParameters() {
        return this.parameters;
    }

    public NetworkWatcher parent() {
        return this.parent;
    }

    public AzureReachabilityReportInner inner() {
        return this.inner;
    }

    public Observable<AzureReachabilityReport> executeWorkAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)((Object)this.parent().manager())).inner())).networkWatchers().getAzureReachabilityReportAsync(this.parent().resourceGroupName(), this.parent().name(), this.parameters).map((Func1)new Func1<AzureReachabilityReportInner, AzureReachabilityReport>(){

            public AzureReachabilityReport call(AzureReachabilityReportInner azureReachabilityReportListInner) {
                AzureReachabilityReportImpl.this.inner = azureReachabilityReportListInner;
                return AzureReachabilityReportImpl.this;
            }
        });
    }

    @Override
    public AzureReachabilityReportImpl withProviderLocation(String country) {
        this.parameters.withProviderLocation(new AzureReachabilityReportLocation().withCountry(country));
        return this;
    }

    @Override
    public AzureReachabilityReportImpl withProviderLocation(String country, String state) {
        this.parameters.withProviderLocation(new AzureReachabilityReportLocation().withCountry(country).withState(state));
        return this;
    }

    @Override
    public AzureReachabilityReportImpl withProviderLocation(String country, String state, String city) {
        this.parameters.withProviderLocation(new AzureReachabilityReportLocation().withCountry(country).withState(state).withCity(city));
        return this;
    }

    @Override
    public AzureReachabilityReportImpl withStartTime(DateTime startTime) {
        this.parameters.withStartTime(startTime);
        return this;
    }

    @Override
    public AzureReachabilityReportImpl withEndTime(DateTime endTime) {
        this.parameters.withEndTime(endTime);
        return this;
    }

    @Override
    public AzureReachabilityReport.DefinitionStages.WithExecute withAzureLocations(String ... azureLocations) {
        this.parameters.withAzureLocations(Arrays.asList(azureLocations));
        return this;
    }

    @Override
    public AzureReachabilityReport.DefinitionStages.WithExecute withProviders(String ... providers) {
        this.parameters.withProviders(Arrays.asList(providers));
        return this;
    }
}

