/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.ClazzInfo;
import soot.ClassMember;
import soot.SootClass;

public class Access {
    public static final String ILLEGAL_ACCESS_ERROR_FIELD = "Attempt to access field %s.%s from class %s";
    public static final String ILLEGAL_ACCESS_ERROR_METHOD = "Attempt to access method %s.%s%s from class %s";
    public static final String ILLEGAL_ACCESS_ERROR_CLASS = "Attempt to access class %s from class %s";

    public static boolean checkClassAccessible(Clazz target, Clazz caller) {
        if (caller == target) {
            return true;
        }
        if (target.getSootClass().isPublic()) {
            return true;
        }
        return target.getSootClass().getPackageName().equals(caller.getSootClass().getPackageName()) && target.isInBootClasspath() == caller.isInBootClasspath();
    }

    public static boolean checkClassAccessible(ClazzInfo target, ClazzInfo caller) {
        if (caller == target) {
            return true;
        }
        if (target.isPublic()) {
            return true;
        }
        if (target.getPackageName().equals(caller.getPackageName())) {
            return target.isPhantom() || caller.isPhantom() || target.getClazz().isInBootClasspath() == caller.getClazz().isInBootClasspath();
        }
        return false;
    }

    public static boolean checkMemberAccessible(ClassMember member, Clazz caller, Clazz target, SootClass runtimeClass) {
        if (caller == target || member.isPublic()) {
            return true;
        }
        if (!member.isPrivate()) {
            if (target.getSootClass().getPackageName().equals(caller.getSootClass().getPackageName()) && target.isInBootClasspath() == caller.isInBootClasspath()) {
                return true;
            }
            if (member.isProtected()) {
                if (member.isStatic()) {
                    if (Access.isSubClassOrSame(target.getSootClass(), caller.getSootClass())) {
                        return true;
                    }
                } else if (Access.isSubClassOrSame(target.getSootClass(), caller.getSootClass())) {
                    if (runtimeClass == null) {
                        return true;
                    }
                    if (Access.isSubClassOrSame(caller.getSootClass(), runtimeClass)) {
                        return true;
                    }
                }
            }
        }
        return (caller.getSootClass().getModifiers() & 0x1000) > 0 && caller.getClassName().startsWith(target.getClassName() + "$$Lambda$");
    }

    public static boolean isSubClassOrSame(SootClass superclass, SootClass clazz) {
        while (clazz != null && !clazz.isPhantom() && clazz.hasSuperclass() && clazz != superclass) {
            clazz = clazz.getSuperclass();
        }
        return clazz == superclass;
    }
}

