/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.tagkit.AnnotationAnnotationElem;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.Host;
import soot.tagkit.Tag;
import soot.tagkit.VisibilityAnnotationTag;
import soot.tagkit.VisibilityParameterAnnotationTag;

public class Annotations {
    public static final String BRIDGE = "Lorg/robovm/rt/bro/annotation/Bridge;";
    public static final String CALLBACK = "Lorg/robovm/rt/bro/annotation/Callback;";
    public static final String STRUCT_MEMBER = "Lorg/robovm/rt/bro/annotation/StructMember;";
    public static final String VECTORISED = "Lorg/robovm/rt/bro/annotation/Vectorised;";
    public static final String STRUCT_PACKED = "Lorg/robovm/rt/bro/annotation/Packed;";
    public static final String GLOBAL_VALUE = "Lorg/robovm/rt/bro/annotation/GlobalValue;";
    public static final String ARRAY = "Lorg/robovm/rt/bro/annotation/Array;";
    public static final String BASE_TYPE = "Lorg/robovm/rt/bro/annotation/BaseType;";
    public static final String STRUCT_RET = "Lorg/robovm/rt/bro/annotation/StructRet;";
    public static final String POINTER = "Lorg/robovm/rt/bro/annotation/Pointer;";
    public static final String MACHINE_SIZED_FLOAT = "Lorg/robovm/rt/bro/annotation/MachineSizedFloat;";
    public static final String MACHINE_SIZED_S_INT = "Lorg/robovm/rt/bro/annotation/MachineSizedSInt;";
    public static final String MACHINE_SIZED_U_INT = "Lorg/robovm/rt/bro/annotation/MachineSizedUInt;";
    public static final String MARSHALER = "Lorg/robovm/rt/bro/annotation/Marshaler;";
    public static final String MARSHALERS = "Lorg/robovm/rt/bro/annotation/Marshalers;";
    public static final String MARSHALS_POINTER = "Lorg/robovm/rt/bro/annotation/MarshalsPointer;";
    public static final String MARSHALS_VALUE = "Lorg/robovm/rt/bro/annotation/MarshalsValue;";
    public static final String MARSHALS_ARRAY = "Lorg/robovm/rt/bro/annotation/MarshalsArray;";
    public static final String AFTER_BRIDGE_CALL = "Lorg/robovm/rt/bro/annotation/AfterBridgeCall;";
    public static final String AFTER_CALLBACK_CALL = "Lorg/robovm/rt/bro/annotation/AfterCallbackCall;";
    public static final String BY_VAL = "Lorg/robovm/rt/bro/annotation/ByVal;";
    public static final String BY_REF = "Lorg/robovm/rt/bro/annotation/ByRef;";
    public static final String VARIADIC = "Lorg/robovm/rt/bro/annotation/Variadic;";
    public static final String WEAKLY_LINKED = "Lorg/robovm/rt/annotation/WeaklyLinked;";
    public static final String STRONGLY_LINKED = "Lorg/robovm/rt/annotation/StronglyLinked;";

    public static boolean hasAnnotation(Host host, String annotationType) {
        return Annotations.getAnnotation(host, annotationType) != null;
    }

    public static boolean hasParameterAnnotation(SootMethod method, int paramIndex, String annotationType) {
        return Annotations.getParameterAnnotation(method, paramIndex, annotationType) != null;
    }

    public static List<AnnotationTag> getAnnotations(Host host, Visibility visibility) {
        if (host instanceof SootClass) {
            SootResolver.v().bringToHierarchy((SootClass)host);
        }
        ArrayList<AnnotationTag> result = new ArrayList<AnnotationTag>();
        for (Tag tag : host.getTags()) {
            if (!(tag instanceof VisibilityAnnotationTag) || visibility != Visibility.Any && ((VisibilityAnnotationTag)tag).getVisibility() != visibility.ordinal()) continue;
            result.addAll(((VisibilityAnnotationTag)tag).getAnnotations());
        }
        return result;
    }

    public static AnnotationTag getAnnotation(Host host, String annotationType) {
        for (AnnotationTag tag : Annotations.getAnnotations(host, Visibility.Any)) {
            if (!annotationType.equals(tag.getType())) continue;
            return tag;
        }
        return null;
    }

    public static List<AnnotationTag> getParameterAnnotations(SootMethod method, int paramIndex, Visibility visibility) {
        ArrayList<AnnotationTag> result = new ArrayList<AnnotationTag>();
        for (Tag tag : method.getTags()) {
            ArrayList annotations;
            ArrayList l;
            if (!(tag instanceof VisibilityParameterAnnotationTag) || visibility != Visibility.Any && ((VisibilityParameterAnnotationTag)tag).getKind() != visibility.ordinal() || (l = ((VisibilityParameterAnnotationTag)tag).getVisibilityAnnotations()) == null || paramIndex >= l.size() || (annotations = ((VisibilityAnnotationTag)l.get(paramIndex)).getAnnotations()) == null) continue;
            result.addAll(annotations);
        }
        return result;
    }

    public static List<AnnotationTag>[] getParameterAnnotations(SootMethod method, Visibility visibility) {
        ArrayList[] result = new ArrayList[method.getParameterCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new ArrayList();
        }
        for (Tag tag : method.getTags()) {
            ArrayList l;
            if (!(tag instanceof VisibilityParameterAnnotationTag) || visibility != Visibility.Any && ((VisibilityParameterAnnotationTag)tag).getKind() != visibility.ordinal() || (l = ((VisibilityParameterAnnotationTag)tag).getVisibilityAnnotations()) == null) continue;
            int i = 0;
            for (VisibilityAnnotationTag t : l) {
                ArrayList annotations = t.getAnnotations();
                if (annotations != null) {
                    result[i].addAll(annotations);
                }
                ++i;
            }
        }
        return result;
    }

    public static AnnotationTag getParameterAnnotation(SootMethod method, int paramIndex, String annotationType) {
        for (AnnotationTag tag : Annotations.getParameterAnnotations(method, paramIndex, Visibility.Any)) {
            if (!annotationType.equals(tag.getType())) continue;
            return tag;
        }
        return null;
    }

    public static boolean hasBridgeAnnotation(SootMethod method) {
        return Annotations.hasAnnotation((Host)method, BRIDGE);
    }

    public static boolean hasCallbackAnnotation(SootMethod method) {
        return Annotations.hasAnnotation((Host)method, CALLBACK);
    }

    public static boolean hasStructMemberAnnotation(SootMethod method) {
        return Annotations.hasAnnotation((Host)method, STRUCT_MEMBER);
    }

    public static boolean hasGlobalValueAnnotation(SootMethod method) {
        return Annotations.hasAnnotation((Host)method, GLOBAL_VALUE);
    }

    public static boolean hasArrayAnnotation(SootMethod method) {
        return Annotations.hasAnnotation((Host)method, ARRAY);
    }

    public static boolean hasArrayAnnotation(SootMethod method, int paramIndex) {
        return Annotations.hasParameterAnnotation(method, paramIndex, ARRAY);
    }

    public static boolean hasPointerAnnotation(SootMethod method) {
        return Annotations.hasAnnotation((Host)method, POINTER);
    }

    public static boolean hasMachineSizedFloatAnnotation(SootMethod method) {
        return Annotations.hasAnnotation((Host)method, MACHINE_SIZED_FLOAT);
    }

    public static boolean hasMachineSizedSIntAnnotation(SootMethod method) {
        return Annotations.hasAnnotation((Host)method, MACHINE_SIZED_S_INT);
    }

    public static boolean hasMachineSizedUIntAnnotation(SootMethod method) {
        return Annotations.hasAnnotation((Host)method, MACHINE_SIZED_U_INT);
    }

    public static boolean hasByValAnnotation(SootMethod method) {
        return Annotations.hasAnnotation((Host)method, BY_VAL);
    }

    public static boolean hasByRefAnnotation(SootMethod method) {
        return Annotations.hasAnnotation((Host)method, BY_REF);
    }

    public static boolean hasStructRetAnnotation(SootMethod method, int paramIndex) {
        return Annotations.hasParameterAnnotation(method, paramIndex, STRUCT_RET);
    }

    public static boolean hasPointerAnnotation(SootMethod method, int paramIndex) {
        return Annotations.hasParameterAnnotation(method, paramIndex, POINTER);
    }

    public static boolean hasMachineSizedFloatAnnotation(SootMethod method, int paramIndex) {
        return Annotations.hasParameterAnnotation(method, paramIndex, MACHINE_SIZED_FLOAT);
    }

    public static boolean hasMachineSizedSIntAnnotation(SootMethod method, int paramIndex) {
        return Annotations.hasParameterAnnotation(method, paramIndex, MACHINE_SIZED_S_INT);
    }

    public static boolean hasMachineSizedUIntAnnotation(SootMethod method, int paramIndex) {
        return Annotations.hasParameterAnnotation(method, paramIndex, MACHINE_SIZED_U_INT);
    }

    public static boolean hasByValAnnotation(SootMethod method, int paramIndex) {
        return Annotations.hasParameterAnnotation(method, paramIndex, BY_VAL);
    }

    public static boolean hasByRefAnnotation(SootMethod method, int paramIndex) {
        return Annotations.hasParameterAnnotation(method, paramIndex, BY_REF);
    }

    public static boolean hasVariadicAnnotation(SootMethod method) {
        return Annotations.hasAnnotation((Host)method, VARIADIC);
    }

    public static boolean hasWeaklyLinkedAnnotation(Host host) {
        return Annotations.hasAnnotation(host, WEAKLY_LINKED);
    }

    public static boolean hasStronglyLinkedAnnotation(Host host) {
        return Annotations.hasAnnotation(host, STRONGLY_LINKED);
    }

    public static int getVariadicParameterIndex(SootMethod method) {
        AnnotationTag annotation = Annotations.getAnnotation((Host)method, VARIADIC);
        return Annotations.readIntElem(annotation, "value", 0);
    }

    public static boolean hasAfterBridgeCallAnnotation(SootMethod method) {
        return Annotations.hasAnnotation((Host)method, AFTER_BRIDGE_CALL);
    }

    public static boolean hasAfterCallbackCallAnnotation(SootMethod method) {
        return Annotations.hasAnnotation((Host)method, AFTER_CALLBACK_CALL);
    }

    public static AnnotationTag getMarshalerAnnotation(SootMethod method, int paramIndex) {
        return Annotations.getParameterAnnotation(method, paramIndex, MARSHALER);
    }

    public static AnnotationTag getMarshalerAnnotation(SootMethod method) {
        return Annotations.getAnnotation((Host)method, MARSHALER);
    }

    public static List<AnnotationTag> getMarshalerAnnotations(SootClass clazz) {
        ArrayList<AnnotationTag> tags = new ArrayList<AnnotationTag>();
        AnnotationTag marshaler = Annotations.getAnnotation((Host)clazz, MARSHALER);
        if (marshaler != null) {
            tags.add(marshaler);
        } else {
            AnnotationTag marshalers = Annotations.getAnnotation((Host)clazz, MARSHALERS);
            if (marshalers != null) {
                for (AnnotationElem e : ((AnnotationArrayElem)marshalers.getElemAt(0)).getValues()) {
                    AnnotationAnnotationElem elem = (AnnotationAnnotationElem)e;
                    tags.add(elem.getValue());
                }
            }
        }
        return tags;
    }

    public static AnnotationTag getMarshalsPointerAnnotation(SootMethod method) {
        return Annotations.getAnnotation((Host)method, MARSHALS_POINTER);
    }

    public static AnnotationTag getMarshalsValueAnnotation(SootMethod method) {
        return Annotations.getAnnotation((Host)method, MARSHALS_VALUE);
    }

    public static AnnotationTag getMarshalsArrayAnnotation(SootMethod method) {
        return Annotations.getAnnotation((Host)method, MARSHALS_ARRAY);
    }

    public static AnnotationTag getStructMemberAnnotation(SootMethod method) {
        return Annotations.getAnnotation((Host)method, STRUCT_MEMBER);
    }

    public static AnnotationTag getStructVectorisedAnnotation(SootClass clazz) {
        return Annotations.getAnnotation((Host)clazz, VECTORISED);
    }

    public static AnnotationTag getStructPackedAnnotation(SootClass clazz) {
        return Annotations.getAnnotation((Host)clazz, STRUCT_PACKED);
    }

    public static AnnotationTag getArrayAnnotation(SootMethod method) {
        return Annotations.getAnnotation((Host)method, ARRAY);
    }

    public static AnnotationTag getArrayAnnotation(SootMethod method, int paramIndex) {
        return Annotations.getParameterAnnotation(method, paramIndex, ARRAY);
    }

    public static AnnotationTag getBaseTypeAnnotation(SootMethod method) {
        return Annotations.getAnnotation((Host)method, BASE_TYPE);
    }

    public static boolean hasByValAnnotation(SootClass clazz) {
        while (!clazz.isPhantom() && clazz.hasSuperclass()) {
            if (Annotations.hasAnnotation((Host)clazz, BY_VAL)) {
                return true;
            }
            if (Annotations.hasAnnotation((Host)clazz, BY_REF)) {
                return false;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static boolean hasByRefAnnotation(SootClass clazz) {
        while (!clazz.isPhantom() && clazz.hasSuperclass()) {
            if (Annotations.hasAnnotation((Host)clazz, BY_REF)) {
                return true;
            }
            if (Annotations.hasAnnotation((Host)clazz, BY_VAL)) {
                return false;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static AnnotationElem getElemByName(AnnotationTag annotation, String name) {
        for (int i = 0; i < annotation.getNumElems(); ++i) {
            AnnotationElem elem = annotation.getElemAt(i);
            if (!name.equals(elem.getName())) continue;
            return elem;
        }
        return null;
    }

    public static String readStringElem(AnnotationTag annotation, String name, String def) {
        AnnotationStringElem elem = (AnnotationStringElem)Annotations.getElemByName(annotation, name);
        return elem != null ? elem.getValue() : def;
    }

    public static boolean readBooleanElem(AnnotationTag annotation, String name, boolean def) {
        AnnotationIntElem elem = (AnnotationIntElem)Annotations.getElemByName(annotation, name);
        return elem != null ? elem.getValue() == 1 : def;
    }

    public static int readIntElem(AnnotationTag annotation, String name, int def) {
        AnnotationIntElem elem = (AnnotationIntElem)Annotations.getElemByName(annotation, name);
        return elem != null ? elem.getValue() : def;
    }

    public static VisibilityAnnotationTag getOrCreateRuntimeVisibilityAnnotationTag(Host host) {
        for (Tag tag : host.getTags()) {
            if (!(tag instanceof VisibilityAnnotationTag) || ((VisibilityAnnotationTag)tag).getVisibility() != 0) continue;
            return (VisibilityAnnotationTag)tag;
        }
        VisibilityAnnotationTag tag = new VisibilityAnnotationTag(0);
        host.addTag((Tag)tag);
        return tag;
    }

    public static void addRuntimeVisibleAnnotation(Host host, String annotationType) {
        if (!Annotations.hasAnnotation(host, annotationType)) {
            VisibilityAnnotationTag tag = Annotations.getOrCreateRuntimeVisibilityAnnotationTag(host);
            tag.addAnnotation(new AnnotationTag(annotationType, 0));
        }
    }

    public static void addRuntimeVisibleAnnotation(Host host, AnnotationTag annoTag) {
        Annotations.removeAnnotation(host, annoTag.getType());
        VisibilityAnnotationTag tag = Annotations.getOrCreateRuntimeVisibilityAnnotationTag(host);
        tag.addAnnotation(annoTag);
    }

    public static void removeAnnotation(Host host, String annotationType) {
        for (Tag tag : host.getTags()) {
            if (!(tag instanceof VisibilityAnnotationTag)) continue;
            ArrayList l = ((VisibilityAnnotationTag)tag).getAnnotations();
            Iterator it = l.iterator();
            while (it.hasNext()) {
                AnnotationTag annoTag = (AnnotationTag)it.next();
                if (!annoTag.getType().equals(annotationType)) continue;
                it.remove();
            }
        }
    }

    public static void removeParameterAnnotation(SootMethod method, int paramIndex, String annotationType) {
        for (Tag tag : method.getTags()) {
            ArrayList annotations;
            ArrayList l;
            if (!(tag instanceof VisibilityParameterAnnotationTag) || (l = ((VisibilityParameterAnnotationTag)tag).getVisibilityAnnotations()) == null || paramIndex >= l.size() || (annotations = ((VisibilityAnnotationTag)l.get(paramIndex)).getAnnotations()) == null) continue;
            Iterator it = annotations.iterator();
            while (it.hasNext()) {
                AnnotationTag annoTag = (AnnotationTag)it.next();
                if (!annoTag.getType().equals(annotationType)) continue;
                it.remove();
            }
        }
    }

    private static void copyAnnotations(SootMethod fromMethod, SootMethod toMethod, int visibility) {
        for (Tag tag : fromMethod.getTags()) {
            if (!(tag instanceof VisibilityAnnotationTag) || ((VisibilityAnnotationTag)tag).getVisibility() != visibility) continue;
            VisibilityAnnotationTag copy = new VisibilityAnnotationTag(visibility);
            for (AnnotationTag annoTag : ((VisibilityAnnotationTag)tag).getAnnotations()) {
                copy.addAnnotation(annoTag);
            }
            toMethod.addTag((Tag)copy);
        }
    }

    public static void copyAnnotations(SootMethod fromMethod, SootMethod toMethod, Visibility visibility) {
        if (visibility == Visibility.Any) {
            Annotations.copyAnnotations(fromMethod, toMethod, 0);
            Annotations.copyAnnotations(fromMethod, toMethod, 1);
            Annotations.copyAnnotations(fromMethod, toMethod, 2);
        } else {
            Annotations.copyAnnotations(fromMethod, toMethod, visibility.ordinal());
        }
    }

    private static void copyParameterAnnotations(SootMethod fromMethod, SootMethod toMethod, int start, int end, int shift, int visibility) {
        List<AnnotationTag>[] fromAnnos = Annotations.getParameterAnnotations(fromMethod, Visibility.values()[visibility]);
        List<AnnotationTag>[] toAnnos = Annotations.getParameterAnnotations(toMethod, Visibility.values()[visibility]);
        for (int i = start; i < end; ++i) {
            toAnnos[i + shift].addAll(fromAnnos[i]);
        }
        Iterator it = toMethod.getTags().iterator();
        while (it.hasNext()) {
            Tag tag = (Tag)it.next();
            if (!(tag instanceof VisibilityParameterAnnotationTag) || ((VisibilityParameterAnnotationTag)tag).getKind() != visibility) continue;
            it.remove();
        }
        VisibilityParameterAnnotationTag vpaTag = new VisibilityParameterAnnotationTag(toAnnos.length, visibility);
        for (List<AnnotationTag> annos : toAnnos) {
            VisibilityAnnotationTag vaTag = new VisibilityAnnotationTag(visibility);
            for (AnnotationTag anno : annos) {
                vaTag.addAnnotation(anno);
            }
            vpaTag.addVisibilityAnnotation(vaTag);
        }
        toMethod.addTag((Tag)vpaTag);
    }

    public static void copyParameterAnnotations(SootMethod fromMethod, SootMethod toMethod, int start, int end, int shift, Visibility visibility) {
        if (visibility == Visibility.Any) {
            Annotations.copyParameterAnnotations(fromMethod, toMethod, start, end, shift, 0);
            Annotations.copyParameterAnnotations(fromMethod, toMethod, start, end, shift, 1);
            Annotations.copyParameterAnnotations(fromMethod, toMethod, start, end, shift, 2);
        } else {
            Annotations.copyParameterAnnotations(fromMethod, toMethod, start, end, shift, visibility.ordinal());
        }
    }

    public static VisibilityAnnotationTag getOrCreateRuntimeVisibilityAnnotationTag(SootMethod method, int paramIndex) {
        for (Tag tag : method.getTags()) {
            ArrayList l;
            if (!(tag instanceof VisibilityParameterAnnotationTag) || (l = ((VisibilityParameterAnnotationTag)tag).getVisibilityAnnotations()) == null || paramIndex >= l.size() || ((VisibilityAnnotationTag)l.get(paramIndex)).getVisibility() != 0) continue;
            return (VisibilityAnnotationTag)l.get(paramIndex);
        }
        VisibilityParameterAnnotationTag ptag = new VisibilityParameterAnnotationTag(method.getParameterCount(), 0);
        for (int i = 0; i < method.getParameterCount(); ++i) {
            ptag.addVisibilityAnnotation(new VisibilityAnnotationTag(0));
        }
        method.addTag((Tag)ptag);
        return (VisibilityAnnotationTag)ptag.getVisibilityAnnotations().get(paramIndex);
    }

    public static void addRuntimeVisibleParameterAnnotation(SootMethod method, int paramIndex, String annotationType) {
        if (!Annotations.hasParameterAnnotation(method, paramIndex, annotationType)) {
            VisibilityAnnotationTag tag = Annotations.getOrCreateRuntimeVisibilityAnnotationTag(method, paramIndex);
            tag.addAnnotation(new AnnotationTag(annotationType, 0));
        }
    }

    public static void addRuntimeVisibleParameterAnnotation(SootMethod method, int paramIndex, AnnotationTag annoTag) {
        Annotations.removeParameterAnnotation(method, paramIndex, annoTag.getType());
        VisibilityAnnotationTag tag = Annotations.getOrCreateRuntimeVisibilityAnnotationTag(method, paramIndex);
        tag.addAnnotation(annoTag);
    }

    public static enum Visibility {
        RuntimeVisible,
        RuntimeInvisible,
        SourceVisible,
        Any;

    }
}

