/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.ClazzInfo;
import org.robovm.compiler.clazz.MethodInfo;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionAttribute;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.trampoline.Trampoline;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;

public class FunctionBuilder {
    private FunctionType type;
    private String name;
    private Linkage linkage = null;
    private List<FunctionAttribute> attributes = new ArrayList<FunctionAttribute>();
    private String section = null;
    private List<String> parameterNames = new ArrayList<String>();

    public FunctionBuilder(Trampoline t) {
        this(t.getFunctionRef());
    }

    public FunctionBuilder(FunctionRef ref) {
        this(ref.getName(), ref.getType());
    }

    public FunctionBuilder(String name, FunctionRef ref) {
        this(name, ref.getType());
    }

    public FunctionBuilder(String name, FunctionType type) {
        this.name = name;
        this.type = type;
        this.attributes.add(FunctionAttribute.nounwind);
    }

    public FunctionBuilder name(String name) {
        this.name = name;
        return this;
    }

    public FunctionBuilder type(FunctionType type) {
        this.type = type;
        return this;
    }

    public FunctionBuilder attrib(FunctionAttribute a) {
        this.attributes.add(a);
        return this;
    }

    public FunctionBuilder attribs(FunctionAttribute ... a) {
        this.attributes.addAll(Arrays.asList(a));
        return this;
    }

    public FunctionBuilder paramName(String p) {
        this.parameterNames.add(p);
        return this;
    }

    public FunctionBuilder paramNames(String ... p) {
        this.parameterNames.addAll(Arrays.asList(p));
        return this;
    }

    public FunctionBuilder linkage(Linkage linkage) {
        this.linkage = linkage;
        return this;
    }

    public FunctionBuilder section(String section) {
        this.section = section;
        return this;
    }

    public Function build() {
        Type[] ptypes = this.type.getParameterTypes();
        for (int i = this.parameterNames.size(); i < ptypes.length; ++i) {
            this.parameterNames.add("p" + i);
        }
        return new Function(this.linkage, this.attributes.toArray(new FunctionAttribute[this.attributes.size()]), this.section, this.name, this.type, this.parameterNames.toArray(new String[this.parameterNames.size()]));
    }

    public static Function allocator(SootClass sootClass) {
        return new FunctionBuilder(Symbols.allocatorSymbol(Types.getInternalName(sootClass)), new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR)).linkage(Linkage._private).attribs(FunctionAttribute.alwaysinline, FunctionAttribute.optsize).build();
    }

    public static Function instanceOf(Clazz clazz) {
        return FunctionBuilder.instanceOf(clazz.getInternalName());
    }

    public static Function instanceOf(SootClass sootClass) {
        return FunctionBuilder.instanceOf(Types.getInternalName(sootClass));
    }

    public static Function instanceOf(String internalName) {
        return new FunctionBuilder(Symbols.instanceofSymbol(internalName), new FunctionType((Type)Type.I32, Types.ENV_PTR, Types.OBJECT_PTR)).linkage(Linkage.external).attribs(FunctionAttribute.alwaysinline, FunctionAttribute.optsize).build();
    }

    public static Function checkcast(Clazz clazz) {
        return FunctionBuilder.checkcast(clazz.getInternalName());
    }

    public static Function checkcast(SootClass sootClass) {
        return FunctionBuilder.checkcast(Types.getInternalName(sootClass));
    }

    public static Function checkcast(String internalName) {
        return new FunctionBuilder(Symbols.checkcastSymbol(internalName), new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR, Types.OBJECT_PTR)).linkage(Linkage.external).attribs(FunctionAttribute.alwaysinline, FunctionAttribute.optsize).build();
    }

    public static Function trycatchEnter(SootClass sootClass) {
        return new FunctionBuilder(Symbols.trycatchenterSymbol(Types.getInternalName(sootClass)), new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR)).linkage(Linkage.external).attribs(FunctionAttribute.alwaysinline, FunctionAttribute.optsize).build();
    }

    public static Function ldcInternal(String internalName) {
        return new FunctionBuilder(Symbols.ldcInternalSymbol(internalName), new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR)).linkage(Linkage._private).attribs(FunctionAttribute.alwaysinline, FunctionAttribute.optsize).build();
    }

    public static Function ldcInternal(SootClass sootClass) {
        return FunctionBuilder.ldcInternal(Types.getInternalName(sootClass));
    }

    public static Function ldcExternal(SootClass sootClass) {
        return new FunctionBuilder(Symbols.ldcExternalSymbol(Types.getInternalName(sootClass)), new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR)).linkage(Linkage.external).attribs(FunctionAttribute.noinline, FunctionAttribute.optsize).build();
    }

    public static Function getter(SootField field) {
        String name = Symbols.getterSymbol(field);
        if (field.isStatic()) {
            return new FunctionBuilder(name, new FunctionType(Types.getType(field.getType()), Types.ENV_PTR)).linkage(Linkage._private).attribs(FunctionAttribute.alwaysinline, FunctionAttribute.optsize).build();
        }
        return new FunctionBuilder(name, new FunctionType(Types.getType(field.getType()), Types.ENV_PTR, Types.OBJECT_PTR)).linkage(field.isPrivate() ? Linkage._private : Linkage.external).attribs(FunctionAttribute.alwaysinline, FunctionAttribute.optsize).build();
    }

    public static Function setter(SootField field) {
        String name = Symbols.setterSymbol(field);
        if (field.isStatic()) {
            return new FunctionBuilder(name, new FunctionType((Type)Type.VOID, Types.ENV_PTR, Types.getType(field.getType()))).linkage(Linkage._private).attribs(FunctionAttribute.alwaysinline, FunctionAttribute.optsize).build();
        }
        return new FunctionBuilder(name, new FunctionType((Type)Type.VOID, Types.ENV_PTR, Types.OBJECT_PTR, Types.getType(field.getType()))).linkage(field.isPrivate() || field.isFinal() ? Linkage._private : Linkage.external).attribs(FunctionAttribute.alwaysinline, FunctionAttribute.optsize).build();
    }

    public static Function clinitWrapper(FunctionRef targetFn) {
        return new FunctionBuilder(Symbols.clinitWrapperSymbol(targetFn.getName()), targetFn).linkage(Linkage.external).attribs(FunctionAttribute.noinline, FunctionAttribute.optsize).build();
    }

    public static Function lookup(SootMethod method, boolean isWeak) {
        return new FunctionBuilder(Symbols.lookupWrapperSymbol(method), Types.getFunctionType(method)).linkage(isWeak ? Linkage.weak : Linkage.external).build();
    }

    public static Function lookup(ClazzInfo ci, MethodInfo mi, boolean isWeak) {
        return new FunctionBuilder(Symbols.lookupWrapperSymbol(ci.getInternalName(), mi.getName(), mi.getDesc()), Types.getFunctionType(mi.getDesc(), mi.isStatic())).linkage(isWeak ? Linkage.weak : Linkage.external).build();
    }

    public static Function synchronizedWrapper(SootMethod method) {
        return new FunctionBuilder(Symbols.synchronizedWrapperSymbol(method), Types.getFunctionType(method)).linkage(Linkage.external).attribs(FunctionAttribute.noinline, FunctionAttribute.optsize).build();
    }

    public static Function method(SootMethod method, boolean weak) {
        return new FunctionBuilder(Symbols.methodSymbol(method), Types.getFunctionType(method)).linkage(weak ? Linkage.weak : Linkage.external).attribs(FunctionAttribute.noinline, FunctionAttribute.optsize).build();
    }

    public static Function info(String internalName) {
        return new FunctionBuilder(Symbols.infoSymbol(internalName), new FunctionType((Type)Type.I8_PTR_PTR, new Type[0])).linkage(Linkage.external).attribs(FunctionAttribute.alwaysinline, FunctionAttribute.optsize).build();
    }

    public static Function infoStruct(SootClass sootClass) {
        return FunctionBuilder.info(Types.getInternalName(sootClass));
    }

    public static Function callback(SootMethod method, FunctionType functionType) {
        return new FunctionBuilder(Symbols.callbackSymbol(method), functionType).linkage(Linkage.internal).attribs(FunctionAttribute.noinline, FunctionAttribute.optsize).build();
    }
}

