/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.clazz;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.robovm.compiler.clazz.AbstractPath;
import org.robovm.compiler.clazz.ClazzInfo;
import org.robovm.compiler.clazz.Clazzes;
import org.robovm.compiler.clazz.Path;
import soot.SootClass;

public abstract class Clazz
implements Comparable<Clazz> {
    final Clazzes clazzes;
    private final String fileName;
    private final String className;
    private final String internalName;
    private final AbstractPath path;
    private ClazzInfo clazzInfo = null;
    private SootClass sootClass = null;
    private transient List<Object> attachments;

    Clazz(Clazzes clazzes, String fileName, AbstractPath path) {
        this.clazzes = clazzes;
        this.fileName = fileName;
        this.className = fileName.replace('/', '.').replace('\\', '.').substring(0, fileName.lastIndexOf(".class"));
        this.internalName = this.className.replace('.', '/');
        this.path = path;
    }

    public boolean isInBootClasspath() {
        return this.path.isInBootClasspath();
    }

    public Path getPath() {
        return this.path;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getInternalName() {
        return this.internalName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClazzInfo getClazzInfo() {
        File infoFile;
        if (this.clazzInfo == null && (infoFile = this.clazzes.getConfig().getInfoFile(this)).exists()) {
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(infoFile)));
                this.clazzInfo = (ClazzInfo)ois.readObject();
                this.clazzInfo.setClazz(this);
            }
            catch (IOException iOException) {
                IOUtils.closeQuietly(ois);
            }
            catch (ClassNotFoundException classNotFoundException) {
                IOUtils.closeQuietly(ois);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)ois);
        }
        return this.clazzInfo;
    }

    public ClazzInfo resetClazzInfo() {
        this.clazzInfo = new ClazzInfo(this, this.getSootClass());
        return this.clazzInfo;
    }

    public void saveClazzInfo() throws IOException {
        if (this.clazzInfo == null) {
            throw new IllegalStateException();
        }
        File infoFile = this.clazzes.getConfig().getInfoFile(this);
        infoFile.getParentFile().mkdirs();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(infoFile)));
            oos.writeObject(this.clazzInfo);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(oos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)oos);
    }

    public SootClass getSootClass() {
        if (this.sootClass == null) {
            this.sootClass = this.clazzes.getSootClass(this);
        }
        return this.sootClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Clazz other = (Clazz)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public void attach(Object o) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Object>();
        }
        this.attachments.add(o);
    }

    public boolean removeAttachement(Object o) {
        if (this.attachments == null) {
            return false;
        }
        return this.attachments.remove(o);
    }

    public List<Object> getAttachments() {
        return this.attachments == null ? Collections.emptyList() : this.attachments;
    }

    public <T> T getAttachment(Class<T> cls) {
        for (Object o : this.getAttachments()) {
            if (!cls.isInstance(o)) continue;
            return (T)o;
        }
        return null;
    }

    public abstract byte[] getBytes() throws IOException;

    public abstract long lastModified();

    @Override
    public int compareTo(Clazz o) {
        return this.className.compareTo(o.className);
    }

    public String toString() {
        return this.className;
    }
}

