/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import org.robovm.compiler.llvm.AliasRef;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.Type;

public class Alias {
    private final String name;
    private final Linkage linkage;
    private final Constant value;

    public Alias(String name, Constant aliasee) {
        this(name, null, aliasee);
    }

    public Alias(String name, Linkage linkage, Constant aliasee) {
        this.name = name;
        this.linkage = linkage;
        this.value = aliasee;
    }

    public AliasRef ref() {
        return new AliasRef(this);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.value.getType();
    }

    public String getDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("@\"");
        sb.append(this.name);
        sb.append("\" = ");
        if (this.linkage != null) {
            sb.append((Object)this.linkage);
            sb.append(' ');
        }
        sb.append("alias ");
        sb.append(this.value.getType());
        sb.append(' ');
        sb.append(this.value);
        return sb.toString();
    }

    public String toString() {
        return this.name;
    }
}

