/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.util.Arrays;
import org.robovm.compiler.llvm.ParameterAttribute;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;

public class Argument {
    private final Value value;
    private final ParameterAttribute[] attributes;

    public Argument(Value value, ParameterAttribute ... attributes) {
        this.value = value;
        this.attributes = attributes;
    }

    public Value getValue() {
        return this.value;
    }

    public Type getType() {
        return this.value.getType();
    }

    public ParameterAttribute[] getAttributes() {
        return (ParameterAttribute[])this.attributes.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode((Object[])this.attributes);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Argument other = (Argument)obj;
        if (!Arrays.equals((Object[])this.attributes, (Object[])other.attributes)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ParameterAttribute attribute : this.attributes) {
            sb.append((Object)attribute);
            sb.append(' ');
        }
        sb.append(this.value);
        return sb.toString();
    }
}

