/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import org.robovm.compiler.llvm.ArrayType;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.Type;

public class ByteArrayConstant
extends Constant {
    private final ArrayType type;
    private final byte[] values;

    public ByteArrayConstant(byte ... values) {
        this.type = new ArrayType(values.length, Type.I8);
        this.values = values;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("i8 ");
            sb.append(this.values[i]);
        }
        sb.append(']');
        return sb.toString();
    }
}

