/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.Type;

public class FunctionDeclaration {
    private final String name;
    private final FunctionType type;

    public FunctionDeclaration(String name, FunctionType type) {
        this.name = name;
        this.type = type;
    }

    public FunctionDeclaration(FunctionRef ref) {
        this(ref.getName(), ref.getType());
    }

    public String getName() {
        return this.name;
    }

    public FunctionType getType() {
        return this.type;
    }

    public FunctionRef ref() {
        return new FunctionRef(this.name, this.type);
    }

    public String toString() {
        Type returnType = this.type.getReturnType();
        Type[] parameterTypes = this.type.getParameterTypes();
        StringBuilder sb = new StringBuilder();
        sb.append("declare ");
        sb.append(returnType.toString());
        sb.append(" @\"");
        sb.append(this.name);
        sb.append("\"(");
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(parameterTypes[i].toString());
        }
        if (this.type.isVarargs()) {
            sb.append(", ...");
        }
        sb.append(")");
        return sb.toString();
    }
}

