/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.IntegerType;
import org.robovm.compiler.llvm.Type;

public class IntegerConstant
extends Constant
implements Comparable<IntegerConstant> {
    private final IntegerType type;
    private final Object value;

    private IntegerConstant(Object value, IntegerType type) {
        this.value = value;
        this.type = type;
    }

    public IntegerConstant(long value, IntegerType type) {
        this(new Long(value), type);
    }

    public IntegerConstant(byte value) {
        this(new Byte(value), Type.I8);
    }

    public IntegerConstant(short value) {
        this(new Short(value), Type.I16);
    }

    public IntegerConstant(char value) {
        this(new Integer(value), Type.I16);
    }

    public IntegerConstant(int value) {
        this(new Integer(value), Type.I32);
    }

    public IntegerConstant(long value) {
        this(new Long(value), Type.I64);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerConstant other = (IntegerConstant)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(IntegerConstant o) {
        return ((Comparable)this.value).compareTo(o.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

