/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import org.robovm.compiler.llvm.ArrayType;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.Type;

public class StringConstant
extends Constant {
    private final ArrayType type;
    private final byte[] bytes;

    public StringConstant(byte[] bytes) {
        this.bytes = bytes;
        this.type = new ArrayType(bytes.length, Type.I8);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("c\"");
        StringConstant.escape(sb, this.bytes);
        sb.append('\"');
        return sb.toString();
    }

    static void escape(StringBuilder sb, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            if (b < 32 || b > 126 || b == 34 || b == 92) {
                sb.append(String.format("\\%02X", b));
                continue;
            }
            sb.append((char)b);
        }
    }
}

