/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import org.robovm.compiler.llvm.FloatingPointType;
import org.robovm.compiler.llvm.IntegerType;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.VariableRef;

public class Variable {
    private final String name;
    private final Type type;

    public Variable(VariableRef ref) {
        this(ref.getName(), ref.getType());
    }

    public Variable(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    public VariableRef ref() {
        return new VariableRef(this);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isInteger() {
        return this.getType() instanceof IntegerType;
    }

    public boolean isFloatingPoint() {
        return this.getType() instanceof FloatingPointType;
    }

    public boolean isPointer() {
        return this.getType() instanceof PointerType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Variable other = (Variable)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "%" + this.name;
    }
}

