/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm.debug.dwarf;

import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.llvm.MetadataNode;
import org.robovm.compiler.llvm.MetadataNodeBuilder;
import org.robovm.compiler.llvm.debug.dwarf.DIBaseItem;
import org.robovm.compiler.llvm.debug.dwarf.DIHeader;

public class DIDerivedType
extends DIBaseItem {
    private final int typeTag;
    private final String name;
    private final int defLineNo;
    private final long sizeBits;
    private final long alignmentBits;
    private final DIBaseItem file;
    private final DIBaseItem context;

    public DIDerivedType(ModuleBuilder builder, int typeTag, String name, int defLineNo, long sizeBits, long alignmentBits, DIBaseItem file, DIBaseItem context) {
        super(builder);
        this.typeTag = typeTag;
        this.name = name;
        this.defLineNo = defLineNo;
        this.sizeBits = sizeBits;
        this.alignmentBits = alignmentBits;
        this.file = file;
        this.context = context;
    }

    public String name() {
        return this.name;
    }

    public int defLineNo() {
        return this.defLineNo;
    }

    public long sizeBits() {
        return this.sizeBits;
    }

    public long alignmentBits() {
        return this.alignmentBits;
    }

    public DIBaseItem file() {
        return this.file;
    }

    public DIBaseItem getContext() {
        return this.context;
    }

    private MetadataNode build() {
        MetadataNodeBuilder builder = new MetadataNodeBuilder();
        builder.add(new DIHeader().add(this.typeTag).add(this.name).add(this.defLineNo).add(this.sizeBits).add(this.alignmentBits).add(0L).add(0));
        builder.add(this.file.get());
        builder.add(this.context != null ? this.context.get() : null);
        builder.add(null);
        builder.add(null);
        return builder.build();
    }

    public String toString() {
        return this.build().toString();
    }
}

