/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm.debug.dwarf;

import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.llvm.MetadataNode;
import org.robovm.compiler.llvm.MetadataNodeBuilder;
import org.robovm.compiler.llvm.debug.dwarf.DIBaseItem;
import org.robovm.compiler.llvm.debug.dwarf.DIHeader;

public class DILocalVariable
extends DIBaseItem {
    private final String name;
    private final int defLineNo;
    private final int argNo;
    private final DIBaseItem file;
    private final DIBaseItem context;
    private final DIBaseItem type;

    public DILocalVariable(ModuleBuilder builder, String name, int defLineNo, int argNo, DIBaseItem file, DIBaseItem context, DIBaseItem type) {
        super(builder);
        this.name = name;
        this.defLineNo = defLineNo;
        this.argNo = argNo;
        this.file = file;
        this.context = context;
        this.type = type;
    }

    public DILocalVariable(ModuleBuilder builder, String name, int defLineNo, DIBaseItem file, DIBaseItem context, DIBaseItem type) {
        super(builder);
        this.name = name;
        this.defLineNo = defLineNo;
        this.argNo = 0;
        this.file = file;
        this.context = context;
        this.type = type;
    }

    public String name() {
        return this.name;
    }

    public int defLineNo() {
        return this.defLineNo;
    }

    public int argNo() {
        return this.argNo;
    }

    public DIBaseItem file() {
        return this.file;
    }

    public DIBaseItem context() {
        return this.context;
    }

    public DIBaseItem type() {
        return this.type;
    }

    private MetadataNode build() {
        MetadataNodeBuilder builder = new MetadataNodeBuilder();
        builder.add(new DIHeader().add(this.argNo <= 0 ? 256 : 257).add(this.name).add((this.argNo << 24) + this.defLineNo).add(0));
        builder.add(this.context.get());
        builder.add(this.file.get());
        builder.add(this.type.get());
        return builder.build();
    }

    public String toString() {
        return this.build().toString();
    }
}

