/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.robovm.compiler.plugin.PluginArgument;

public class PluginArguments {
    private final String prefix;
    private final List<PluginArgument> arguments;
    private final Set<String> lookup;

    public PluginArguments(String prefix, List<PluginArgument> arguments) {
        this.prefix = Objects.requireNonNull(prefix, "Prefix must not be null");
        this.arguments = Objects.requireNonNull(arguments, "arguments must not be null");
        this.lookup = new HashSet<String>();
        for (PluginArgument arg : arguments) {
            this.lookup.add(arg.getName());
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public List<PluginArgument> getArguments() {
        return this.arguments;
    }

    public boolean hasArgument(String argWithPrefix) {
        return this.lookup.contains(argWithPrefix);
    }
}

