/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.debug;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.robovm.compiler.Annotations;
import org.robovm.compiler.Functions;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.llvm.Alloca;
import org.robovm.compiler.llvm.ArrayType;
import org.robovm.compiler.llvm.BasicBlock;
import org.robovm.compiler.llvm.Call;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.ConstantBitcast;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionDeclaration;
import org.robovm.compiler.llvm.Global;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.MetadataString;
import org.robovm.compiler.llvm.MetadataValue;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;
import org.robovm.compiler.llvm.ZeroInitializer;
import org.robovm.compiler.llvm.debug.dwarf.DIBaseItem;
import org.robovm.compiler.llvm.debug.dwarf.DICompileUnit;
import org.robovm.compiler.llvm.debug.dwarf.DICompositeType;
import org.robovm.compiler.llvm.debug.dwarf.DIDerivedType;
import org.robovm.compiler.llvm.debug.dwarf.DIFileDescriptor;
import org.robovm.compiler.llvm.debug.dwarf.DIItemList;
import org.robovm.compiler.llvm.debug.dwarf.DILineNumber;
import org.robovm.compiler.llvm.debug.dwarf.DILocalVariable;
import org.robovm.compiler.llvm.debug.dwarf.DIMutableItemList;
import org.robovm.compiler.llvm.debug.dwarf.DISubprogram;
import org.robovm.compiler.plugin.AbstractCompilerPlugin;
import org.robovm.compiler.plugin.PluginArguments;
import org.robovm.compiler.plugin.debug.DebuggerDebugMethodInfo;
import org.robovm.compiler.plugin.debug.DebuggerDebugObjectFileInfo;
import org.robovm.compiler.plugin.debug.DebuggerDebugVariableInfo;
import org.robovm.compiler.plugin.debug.DebuggerDebugVariableSlicer;
import org.robovm.compiler.plugin.debug.kotlin.KotlinTools;
import org.robovm.llvm.LineInfo;
import org.robovm.llvm.ObjectFile;
import org.robovm.llvm.Symbol;
import org.robovm.llvm.debuginfo.DwarfDebugMethodInfo;
import org.robovm.llvm.debuginfo.DwarfDebugObjectFileInfo;
import org.robovm.llvm.debuginfo.DwarfDebugVariableInfo;
import soot.Local;
import soot.LocalVariable;
import soot.PatchingChain;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.IdentityStmt;
import soot.jimple.ParameterRef;
import soot.tagkit.GenericAttribute;
import soot.tagkit.LineNumberTag;
import soot.tagkit.SourceFileTag;

public class DebugInformationPlugin
extends AbstractCompilerPlugin {
    @Override
    public PluginArguments getArguments() {
        return new PluginArguments("debug", Collections.emptyList());
    }

    @Override
    public void helloClass(Config config, Clazz clazz) {
        super.helloClass(config, clazz);
        ClassDataBundle classBundle = clazz.getAttachment(ClassDataBundle.class);
        if (classBundle != null) {
            clazz.removeAttachement(classBundle);
        }
        classBundle = new ClassDataBundle();
        clazz.attach(classBundle);
        if (config.isDebug()) {
            classBundle.methodsBeforeCompile = new HashSet<String>();
            for (SootMethod m : clazz.getSootClass().getMethods()) {
                if (m.isAbstract() || m.isNative()) continue;
                classBundle.methodsBeforeCompile.add(m.getSignature());
            }
        }
    }

    @Override
    public void beforeClass(Config config, Clazz clazz, ModuleBuilder mb) throws IOException {
        GenericAttribute smap;
        super.beforeClass(config, clazz, mb);
        ClassDataBundle classBundle = clazz.getAttachment(ClassDataBundle.class);
        classBundle.diFile = new DIItemList(mb, this.v(this.getDwarfSourceFile(clazz)), this.v(this.getDwarfSourceFilePath(clazz)));
        classBundle.diFileDescriptor = new DIFileDescriptor(mb, classBundle.diFile);
        classBundle.diMethods = new DIMutableItemList(mb);
        classBundle.diCompileUnit = new DICompileUnit(mb, "llvm.dbg.cu", classBundle.diFile, classBundle.diMethods);
        DIItemList dwarfVersion = new DIItemList(this.v(2), this.v("Dwarf Version"), this.v(2));
        DIItemList debugInfoVersion = new DIItemList(this.v(2), this.v("Debug Info Version"), this.v(2));
        classBundle.flags = new DIItemList(mb, "llvm.module.flags", dwarfVersion.get(), debugInfoVersion.get());
        if (config.isDebug()) {
            classBundle.dummyJavaVariableType = new DIDerivedType(mb, 15, "DummyType", 0, 32L, 32L, classBundle.diFile, null);
            classBundle.methods = new ArrayList<MethodDataBundle>();
            mb.addFunctionDeclaration(new FunctionDeclaration(Functions.LLVM_DBG_DECLARE));
            if (config.getTarget().getArch().isArm()) {
                mb.addGlobal(new Global("robovm.emitSpFpOffsets", Type.I8));
            }
        }
        LineNumberMapper lineNumberMapper = LineNumberMapper.DIRECT;
        SourceFileTag sourceFileTag = (SourceFileTag)clazz.getSootClass().getTag("SourceFileTag");
        if (sourceFileTag != null && sourceFileTag.getSourceFile() != null && sourceFileTag.getSourceFile().endsWith(".kt") && (smap = (GenericAttribute)clazz.getSootClass().getTag("SourceDebugExtension")) != null) {
            lineNumberMapper = KotlinTools.parseSMAP(smap.getValue(), clazz.getInternalName());
        }
        clazz.attach(lineNumberMapper);
    }

    @Override
    public void afterMethod(Config config, Clazz clazz, SootMethod method, ModuleBuilder mb, Function function) throws IOException {
        Instruction instruction;
        super.afterMethod(config, clazz, method, mb, function);
        ClassDataBundle classBundle = clazz.getAttachment(ClassDataBundle.class);
        if (method.isNative() || method.isAbstract() || !method.hasActiveBody()) {
            return;
        }
        BasicBlock entryBlock = function.getBasicBlocks().get(0);
        if (entryBlock.getInstructions().size() == 1) {
            return;
        }
        DICompositeType diSubprogramType = new DICompositeType(mb);
        diSubprogramType.setTypeTag(21);
        diSubprogramType.setFile(classBundle.diFile);
        diSubprogramType.setFileContext(classBundle.diFileDescriptor);
        DISubprogram diSubprogram = new DISubprogram(mb);
        diSubprogram.setSubrotineType(diSubprogramType);
        diSubprogram.setSignature(function.getName());
        diSubprogram.setFile(classBundle.diFile);
        diSubprogram.setFileContext(classBundle.diFileDescriptor);
        diSubprogram.setLlvmFunction(function.ref());
        boolean includeDebuggerInfo = config.isDebug() && !Annotations.hasCallbackAnnotation(method) && !Annotations.hasBridgeAnnotation(method) && classBundle.methodsBeforeCompile.contains(method.getSignature());
        DebuggerDebugVariableSlicer localsDebugInfo = null;
        if (includeDebuggerInfo) {
            localsDebugInfo = new DebuggerDebugVariableSlicer(config, method);
        }
        HashMap<Instruction, Integer> instructionToLineNo = new HashMap<Instruction, Integer>();
        HashMap<Instruction, Integer> instructionToDebugInfoIdx = new HashMap<Instruction, Integer>();
        HashMap<Unit, Instruction> unitToInstruction = new HashMap<Unit, Instruction>();
        LineNumberMapper lineNumberMapper = clazz.getAttachment(LineNumberMapper.class);
        int methodLineNumber = Integer.MAX_VALUE;
        int methodEndLineNumber = Integer.MIN_VALUE;
        for (BasicBlock basicBlock : function.getBasicBlocks()) {
            for (Instruction instruction2 : basicBlock.getInstructions()) {
                int lineNumber = -1;
                int columnAsDebugInfoIdx = 0;
                List<Object> units = instruction2.getAttachments();
                Iterator<Object> iterator = units.iterator();
                while (iterator.hasNext()) {
                    int idx;
                    Object object = iterator.next();
                    if (!(object instanceof Unit)) continue;
                    Unit unit = (Unit)object;
                    LineNumberTag tag = (LineNumberTag)unit.getTag("LineNumberTag");
                    if (tag != null) {
                        lineNumber = lineNumberMapper.map(tag.getLineNumber());
                        methodLineNumber = Math.min(methodLineNumber, lineNumber);
                        methodEndLineNumber = Math.max(methodEndLineNumber, lineNumber);
                    }
                    if (localsDebugInfo != null && localsDebugInfo.containsVariableSliceForUnit(unit) && (idx = localsDebugInfo.getVariableSliceIndexForUnit(unit)) >= 0) {
                        columnAsDebugInfoIdx = idx + 1;
                    }
                    unitToInstruction.put(unit, instruction2);
                }
                if (lineNumber == -1) continue;
                instruction2.addMetadata(new DILineNumber(lineNumber, columnAsDebugInfoIdx, diSubprogram).get());
                instructionToLineNo.put(instruction2, lineNumber);
                if (columnAsDebugInfoIdx == 0) continue;
                instructionToDebugInfoIdx.put(instruction2, columnAsDebugInfoIdx);
            }
        }
        classBundle.diMethods.add(diSubprogram);
        if (methodLineNumber == Integer.MAX_VALUE) {
            return;
        }
        diSubprogram.setScopeLineNo(methodLineNumber);
        diSubprogram.setDefLineNo(methodLineNumber);
        if (!includeDebuggerInfo) {
            return;
        }
        Unit firstHooksUnit = null;
        for (Unit unit : method.getActiveBody().getUnits()) {
            if (unit instanceof IdentityStmt) continue;
            firstHooksUnit = unit;
            break;
        }
        Instruction instruction3 = instruction = firstHooksUnit != null ? (Instruction)unitToInstruction.get(firstHooksUnit) : null;
        if (instruction == null) {
            return;
        }
        boolean startInstrumenting = false;
        HashMap<Integer, Instruction> hookInstructionLines = new HashMap<Integer, Instruction>();
        for (BasicBlock bb : function.getBasicBlocks()) {
            for (Instruction instruction4 : bb.getInstructions()) {
                if (!startInstrumenting && instruction != instruction4) continue;
                startInstrumenting = true;
                Integer n = (Integer)instructionToLineNo.get(instruction4);
                if (n == null || hookInstructionLines.containsKey(n)) continue;
                hookInstructionLines.put(n, instruction4);
            }
        }
        int arraySize = (methodEndLineNumber - methodLineNumber + 1 + 7) / 8;
        Global bpTable = new Global(Symbols.bptableSymbol(method), Linkage.internal, new ZeroInitializer(new ArrayType(arraySize, Type.I8)));
        mb.addGlobal(bpTable);
        ConstantBitcast bpTableRef = new ConstantBitcast(bpTable.ref(), Type.I8_PTR);
        for (Map.Entry entry : hookInstructionLines.entrySet()) {
            Instruction instruction5 = (Instruction)entry.getValue();
            int lineNo = (Integer)entry.getKey();
            int debugInfoIdx = instructionToDebugInfoIdx.getOrDefault(instruction5, 0);
            this.injectHookInstrumented(diSubprogram, lineNo, debugInfoIdx, lineNo - methodLineNumber, function, bpTableRef, instruction5);
        }
        HashMap<Local, Alloca> hashMap = new HashMap<Local, Alloca>();
        for (BasicBlock basicBlock : function.getBasicBlocks()) {
            for (Instruction instruction32 : basicBlock.getInstructions()) {
                if (!(instruction32 instanceof Alloca)) continue;
                Alloca alloca = (Alloca)instruction32;
                for (Object o : alloca.getAttachments()) {
                    Local local;
                    if (!(o instanceof Local) || (local = (Local)o).getIndex() < 0) continue;
                    hashMap.put(local, alloca);
                }
            }
        }
        HashSet<Local> hashSet = new HashSet<Local>();
        for (Unit u : method.getActiveBody().getUnits()) {
            if (!(u instanceof IdentityStmt) || !(((IdentityStmt)u).getRightOp() instanceof ParameterRef) || !(((IdentityStmt)u).getLeftOpBox().getValue() instanceof Local)) continue;
            Local l = (Local)((IdentityStmt)u).getLeftOpBox().getValue();
            hashSet.add(l);
        }
        int n = method.isStatic() ? 3 : 2;
        DIMutableItemList<DILocalVariable> diVariableList = new DIMutableItemList<DILocalVariable>(mb);
        for (Map.Entry e : hashMap.entrySet()) {
            Local local = (Local)e.getKey();
            Alloca alloca = (Alloca)e.getValue();
            int argIdx = 0;
            if (local.getIndex() < method.getParameterCount() && hashSet.contains(local)) {
                argIdx = n + local.getIndex();
            }
            int varStartLine = methodLineNumber;
            DILocalVariable diLocalVariable = new DILocalVariable(mb, local.getName(), varStartLine, argIdx, classBundle.diFile, diSubprogram, classBundle.dummyJavaVariableType);
            Call call = new Call((Value)Functions.LLVM_DBG_DECLARE, new MetadataValue(new VariableRef(alloca.getResult().getName(), new PointerType(alloca.getResult().getType()))), diLocalVariable.get());
            call.addMetadata(new DILineNumber(varStartLine, 0, diSubprogram).get());
            instruction.getBasicBlock().insertBefore(instruction, call);
            diVariableList.add(diLocalVariable);
        }
        diSubprogram.setVariables(diVariableList);
        classBundle.methods.add(new MethodDataBundle(function.getName(), methodLineNumber, methodEndLineNumber, localsDebugInfo));
    }

    @Override
    public void afterObjectFile(Config config, Clazz clazz, File objectFile, ObjectFile objectFileData) throws IOException {
        DwarfDebugObjectFileInfo debugInfo;
        super.afterObjectFile(config, clazz, objectFile, objectFileData);
        ClassDataBundle classBundle = clazz.getAttachment(ClassDataBundle.class);
        if (config.isDebug() && (debugInfo = objectFileData.getDebugInfo()) != null) {
            this.processDebugInformation(config, clazz, debugInfo, classBundle, objectFileData);
        }
        clazz.removeAttachement(classBundle);
    }

    private void processDebugInformation(Config config, Clazz clazz, DwarfDebugObjectFileInfo debugInfo, ClassDataBundle classBundle, ObjectFile objectFileData) {
        String symbolPrefix = config.getOs().getFamily() == OS.Family.darwin ? "_" : "";
        Map<String, Symbol> symbols = objectFileData.getSymbols().stream().filter(s -> s.getName().startsWith(symbolPrefix + "[J]")).collect(Collectors.toMap(Symbol::getName, e -> e));
        ArrayList<DebuggerDebugMethodInfo.RawData> methods = new ArrayList<DebuggerDebugMethodInfo.RawData>();
        for (MethodDataBundle methodBundle : classBundle.methods) {
            DwarfDebugMethodInfo dbgMethodInfo = debugInfo.methodBySignature(methodBundle.signature);
            List lineInfos = null;
            Symbol symbol = symbols.get(symbolPrefix + methodBundle.signature);
            if (symbol != null) {
                lineInfos = objectFileData.getLineInfos(symbol);
            }
            if (dbgMethodInfo == null || lineInfos == null) {
                config.getLogger().warn("Failed to get debug information for method %s in class %s", methodBundle.signature, clazz.getClassName());
                continue;
            }
            if (lineInfos.size() == 0) continue;
            DebuggerDebugMethodInfo.RawData debuggerMethodInfo = this.buildDebuggerMethodInfo(config, clazz, symbol, dbgMethodInfo, methodBundle, lineInfos);
            methods.add(debuggerMethodInfo);
        }
        DebuggerDebugObjectFileInfo.RawData finalDebugInfo = clazz.getAttachment(DebuggerDebugObjectFileInfo.RawData.class);
        if (finalDebugInfo != null) {
            clazz.removeAttachement(finalDebugInfo);
        }
        finalDebugInfo = new DebuggerDebugObjectFileInfo.RawData(this.getJdwpSourceFile(clazz), methods.toArray(new DebuggerDebugMethodInfo.RawData[0]));
        clazz.attach(finalDebugInfo);
    }

    private DebuggerDebugMethodInfo.RawData buildDebuggerMethodInfo(Config config, Clazz clazz, Symbol symbol, DwarfDebugMethodInfo dbgMethodInfo, MethodDataBundle methodBundle, List<LineInfo> lineInfos) {
        lineInfos.sort(Comparator.comparingLong(LineInfo::getAddress));
        int last = -1;
        Iterator<LineInfo> it = lineInfos.iterator();
        while (it.hasNext()) {
            LineInfo l = it.next();
            if (l.getColumnNumber() == last) {
                it.remove();
                continue;
            }
            last = l.getColumnNumber();
        }
        LineNumberMapper lineNumberMapper = clazz.getAttachment(LineNumberMapper.class);
        DebuggerDebugVariableSlicer localsDebugInfo = methodBundle.variablesInfo;
        HashMap<LocalVariable, DebuggerDebugVariableInfo> localVariableToDebugVariable = new HashMap<LocalVariable, DebuggerDebugVariableInfo>();
        HashMap<DebuggerDebugVariableInfo, Integer> usedVariables = new HashMap<DebuggerDebugVariableInfo, Integer>();
        HashMap<DwarfDebugVariableInfo, Integer> usedAllocas = new HashMap<DwarfDebugVariableInfo, Integer>();
        TreeMap<Integer, Object> slices = new TreeMap<Integer, Object>();
        TreeMap<Integer, Integer> offsetToSlice = new TreeMap<Integer, Integer>();
        for (LineInfo li : lineInfos) {
            int sliceIdx = li.getColumnNumber();
            int offset = (int)(li.getAddress() - symbol.getAddress());
            offsetToSlice.put(offset, sliceIdx);
            if (slices.containsKey(sliceIdx)) continue;
            if (sliceIdx == 0) {
                slices.put(sliceIdx, new int[0]);
                continue;
            }
            DebuggerDebugVariableSlicer.UnitVariableSlice slice = localsDebugInfo.getVariableSlice(sliceIdx - 1);
            PatchingChain units = localsDebugInfo.getMethod().getActiveBody().getUnits();
            Object sliceData = new int[slice.variables.size() * 2];
            int written = 0;
            for (int idx2 = 0; idx2 < slice.variables.size(); ++idx2) {
                int allocaIdx;
                int varIdx;
                Local local;
                DwarfDebugVariableInfo alloca2;
                LocalVariable v = (LocalVariable)slice.variables.get(idx2);
                DebuggerDebugVariableInfo var = (DebuggerDebugVariableInfo)localVariableToDebugVariable.get(v);
                if (var == null) {
                    int finalLine;
                    LineNumberTag tag;
                    int startLine = v.getStartUnit() == null ? methodBundle.startLine : ((tag = (LineNumberTag)v.getStartUnit().getTag("LineNumberTag")) != null ? lineNumberMapper.map(tag.getLineNumber()) : methodBundle.startLine);
                    if (v.getEndUnit() == null) {
                        finalLine = methodBundle.finalLine;
                    } else {
                        Unit endUnit = (Unit)units.getPredOf((Object)v.getEndUnit());
                        LineNumberTag tag2 = null;
                        if (endUnit != null) {
                            tag2 = (LineNumberTag)endUnit.getTag("LineNumberTag");
                        }
                        finalLine = tag2 != null ? lineNumberMapper.map(tag2.getLineNumber()) : methodBundle.startLine;
                    }
                    var = new DebuggerDebugVariableInfo(v.getName(), v.getDescriptor(), v.getIndex() < localsDebugInfo.getMethod().getParameterCount(), startLine, finalLine);
                    localVariableToDebugVariable.put(v, var);
                }
                if ((alloca2 = dbgMethodInfo.variableByName((local = (Local)slice.locals.get(idx2)).getName())) == null) {
                    if (config == null || !config.getHome().isDev()) continue;
                    config.getLogger().error("Alloca not found for variable " + local.getName(), new Object[0]);
                    continue;
                }
                if (usedVariables.containsKey(var)) {
                    varIdx = (Integer)usedVariables.get(var);
                } else {
                    varIdx = usedVariables.size();
                    usedVariables.put(var, varIdx);
                }
                if (usedAllocas.containsKey(alloca2)) {
                    allocaIdx = (Integer)usedAllocas.get(alloca2);
                } else {
                    allocaIdx = usedAllocas.size();
                    usedAllocas.put(alloca2, allocaIdx);
                }
                sliceData[written++] = varIdx;
                sliceData[written++] = allocaIdx;
            }
            if (written < ((Object)sliceData).length) {
                sliceData = Arrays.copyOf((int[])sliceData, written);
            }
            slices.put(sliceIdx, sliceData);
        }
        int[][] rawSlices = (int[][])slices.values().toArray((T[])new int[0][]);
        DwarfDebugVariableInfo[] rawAllocas = new DwarfDebugVariableInfo[usedAllocas.size()];
        usedAllocas.forEach((alloca, idx) -> {
            rawAllocas[idx.intValue()] = alloca;
        });
        DebuggerDebugVariableInfo[] rawVariables = new DebuggerDebugVariableInfo[usedVariables.size()];
        usedVariables.forEach((variable, idx) -> {
            rawVariables[idx.intValue()] = variable;
        });
        int[] rawOffsets = new int[offsetToSlice.size()];
        int[] rawOffsetSliceIndexes = new int[offsetToSlice.size()];
        int idx3 = 0;
        for (Map.Entry e : offsetToSlice.entrySet()) {
            rawOffsets[idx3] = (Integer)e.getKey();
            rawOffsetSliceIndexes[idx3] = (Integer)e.getValue();
            ++idx3;
        }
        String methodName = dbgMethodInfo.signature();
        if (methodName.startsWith("[J]" + clazz.getClassName() + ".")) {
            methodName = methodName.substring(clazz.getClassName().length() + 4);
        }
        DebuggerDebugMethodInfo.RawData mi = new DebuggerDebugMethodInfo.RawData(methodName, methodBundle.startLine, methodBundle.finalLine, rawVariables, rawAllocas, rawOffsets, rawOffsetSliceIndexes, rawSlices);
        return mi;
    }

    private void injectHookInstrumented(DISubprogram diSubprogram, int lineNo, int debugeInfoIdx, int lineNumberOffset, Function function, Constant bpTableRef, Instruction instruction) {
        BasicBlock block = instruction.getBasicBlock();
        VariableRef debugEnv = function.getParameterRef(0);
        Variable pc = function.newVariable(Type.I8_PTR);
        Call getPcCall = new Call(pc, (Value)Functions.GETPC, new Value[0]);
        block.insertBefore(instruction, getPcCall);
        Call bcHookInstrumented = new Call((Value)Functions.BC_HOOK_INSTRUMENTED, debugEnv, new IntegerConstant(lineNo), new IntegerConstant(lineNumberOffset), bpTableRef, pc.ref());
        block.insertBefore(instruction, bcHookInstrumented);
        bcHookInstrumented.addMetadata(new DILineNumber(lineNo, debugeInfoIdx, diSubprogram).get());
    }

    private String getDwarfSourceFile(Clazz clazz) {
        String tagSourceFile;
        int extIdx;
        String ext = ".java";
        String className = clazz.getInternalName();
        SourceFileTag sourceFileTag = (SourceFileTag)clazz.getSootClass().getTag("SourceFileTag");
        if (sourceFileTag != null && (extIdx = (tagSourceFile = sourceFileTag.getSourceFile()).lastIndexOf(46)) > 0) {
            ext = tagSourceFile.substring(extIdx);
        }
        String sourceFile = className.contains("/") ? className.substring(clazz.getInternalName().lastIndexOf("/") + 1) + ext : className + ext;
        return sourceFile;
    }

    private String getDwarfSourceFilePath(Clazz clazz) {
        String className;
        String sourcePath = clazz.getPath().toString();
        if (!sourcePath.endsWith("/")) {
            sourcePath = sourcePath + "/";
        }
        if (!sourcePath.startsWith("/")) {
            sourcePath = "/" + sourcePath;
        }
        if ((className = clazz.getInternalName()).contains("/")) {
            sourcePath = sourcePath + className.substring(0, clazz.getInternalName().lastIndexOf("/") + 1);
        }
        return sourcePath;
    }

    private String getJdwpSourceFile(Clazz clazz) {
        String sourceFile;
        SourceFileTag sourceFileTag = (SourceFileTag)clazz.getSootClass().getTag("SourceFileTag");
        if (sourceFileTag != null) {
            sourceFile = sourceFileTag.getSourceFile();
        } else {
            sourceFile = clazz.getInternalName();
            int sepIdx = sourceFile.lastIndexOf(47);
            if (sepIdx > 0) {
                sourceFile = sourceFile.substring(sepIdx + 1);
            }
            if ((sepIdx = sourceFile.indexOf(36)) > 0) {
                sourceFile = sourceFile.substring(0, sepIdx);
            }
            sourceFile = sourceFile + ".java";
        }
        return sourceFile;
    }

    private IntegerConstant v(int i) {
        return new IntegerConstant(i);
    }

    private MetadataString v(String s) {
        return new MetadataString(s);
    }

    private static class MethodDataBundle {
        final String signature;
        final int startLine;
        final int finalLine;
        final DebuggerDebugVariableSlicer variablesInfo;

        MethodDataBundle(String signature, int startLine, int finalLine, DebuggerDebugVariableSlicer variablesInfo) {
            this.signature = signature;
            this.startLine = startLine;
            this.finalLine = finalLine;
            this.variablesInfo = variablesInfo;
        }
    }

    public static interface LineNumberMapper {
        public static final LineNumberMapper DIRECT = l -> l;

        public int map(int var1);
    }

    private static class ClassDataBundle {
        DIBaseItem diFile;
        DIBaseItem diFileDescriptor;
        DIMutableItemList<DISubprogram> diMethods;
        DIBaseItem diCompileUnit;
        DIBaseItem flags;
        DIBaseItem dummyJavaVariableType;
        List<MethodDataBundle> methods;
        Set<String> methodsBeforeCompile;

        private ClassDataBundle() {
        }
    }
}

