/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.debug;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.robovm.compiler.plugin.debug.DebuggerDebugVariableInfo;
import org.robovm.llvm.debuginfo.DwarfDebugVariableInfo;

public class DebuggerDebugMethodInfo {
    private final String name;
    private final int startLine;
    private final int finalLine;
    private final DebuggerDebugVariableInfo[] localvariables;
    private final DebuggerDebugVariableInfo[][] sliceVariables;
    private final DwarfDebugVariableInfo[][] sliceAllocas;
    private final int[] offsets;
    private final int[] offsetSliceIndexes;

    DebuggerDebugMethodInfo(RawData rawData) {
        this.name = rawData.signature;
        this.startLine = rawData.startLine;
        this.finalLine = rawData.finalLine;
        this.localvariables = rawData.variables;
        this.offsets = rawData.offsets;
        this.offsetSliceIndexes = rawData.offsetSliceIndexes;
        int sliceCount = rawData.slices.length;
        this.sliceVariables = new DebuggerDebugVariableInfo[sliceCount][];
        this.sliceAllocas = new DwarfDebugVariableInfo[sliceCount][];
        for (int sliceIdx = 0; sliceIdx < sliceCount; ++sliceIdx) {
            int[] sliceData = rawData.slices[sliceIdx];
            int varCount = sliceData.length / 2;
            this.sliceVariables[sliceIdx] = new DebuggerDebugVariableInfo[varCount];
            DebuggerDebugVariableInfo[] variables = this.sliceVariables[sliceIdx];
            this.sliceAllocas[sliceIdx] = new DwarfDebugVariableInfo[varCount];
            DwarfDebugVariableInfo[] allocas = this.sliceAllocas[sliceIdx];
            for (int idx = 0; idx < varCount; ++idx) {
                int varIdx = sliceData[idx * 2];
                int allocaIdx = sliceData[idx * 2 + 1];
                variables[idx] = this.localvariables[varIdx];
                allocas[idx] = rawData.allocas[allocaIdx];
            }
        }
    }

    public String signature() {
        return this.name;
    }

    public DebuggerDebugVariableInfo[] localvariables() {
        return this.localvariables;
    }

    public int startLine() {
        return this.startLine;
    }

    public int finalLine() {
        return this.finalLine;
    }

    public Pair<DebuggerDebugVariableInfo[], DwarfDebugVariableInfo[]> getVisibleVariables(int offset) {
        int offsetIdx = DebuggerDebugMethodInfo.binarySearchOffset(this.offsets, offset);
        if (offsetIdx < 0) {
            return null;
        }
        int sliceIdx = this.offsetSliceIndexes[offsetIdx];
        return new ImmutablePair((Object)this.sliceVariables[sliceIdx], (Object)this.sliceAllocas[sliceIdx]);
    }

    private static int binarySearchOffset(int[] array, int value) {
        if (array == null || array.length == 0) {
            return -1;
        }
        if (array[0] > value) {
            return -1;
        }
        int leftIdx = 0;
        int rightIdx = array.length - 1;
        while (leftIdx < rightIdx) {
            int centerIdx = (leftIdx + rightIdx + 1) / 2;
            int cv = array[centerIdx];
            if (cv <= value) {
                leftIdx = centerIdx;
                continue;
            }
            rightIdx = centerIdx - 1;
        }
        return leftIdx;
    }

    static class RawData {
        final String signature;
        final DebuggerDebugVariableInfo[] variables;
        final DwarfDebugVariableInfo[] allocas;
        final int[] offsets;
        final int[] offsetSliceIndexes;
        final int[][] slices;
        final int startLine;
        final int finalLine;

        RawData(String methodName, int startLine, int finalLine, DebuggerDebugVariableInfo[] variables, DwarfDebugVariableInfo[] allocas, int[] offsets, int[] offsetSliceIndexes, int[][] slices) {
            this.signature = methodName;
            this.startLine = startLine;
            this.finalLine = finalLine;
            this.variables = variables;
            this.allocas = allocas;
            this.offsets = offsets;
            this.offsetSliceIndexes = offsetSliceIndexes;
            this.slices = slices;
        }
    }
}

