/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.debug;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.robovm.compiler.plugin.debug.DebuggerDebugMethodInfo;
import org.robovm.compiler.plugin.debug.DebuggerDebugVariableInfo;
import org.robovm.llvm.debuginfo.DwarfDebugVariableInfo;

public class DebuggerDebugObjectFileInfo {
    private final String sourceFile;
    private final DebuggerDebugMethodInfo[] methods;
    private Map<String, DebuggerDebugMethodInfo> methodBySignature;

    private DebuggerDebugObjectFileInfo(String sourceFile, DebuggerDebugMethodInfo.RawData[] rawMethods) {
        this.sourceFile = sourceFile;
        this.methods = new DebuggerDebugMethodInfo[rawMethods.length];
        for (int idx = 0; idx < this.methods.length; ++idx) {
            this.methods[idx] = new DebuggerDebugMethodInfo(rawMethods[idx]);
        }
    }

    public String sourceFile() {
        return this.sourceFile;
    }

    public DebuggerDebugMethodInfo[] methods() {
        return this.methods;
    }

    public DebuggerDebugMethodInfo methodBySignature(String signature) {
        if (this.methodBySignature == null) {
            this.methodBySignature = new HashMap<String, DebuggerDebugMethodInfo>();
            for (DebuggerDebugMethodInfo methodInfo : this.methods()) {
                this.methodBySignature.put(methodInfo.signature(), methodInfo);
            }
        }
        return this.methodBySignature.get(signature);
    }

    /*
     * Could not resolve type clashes
     */
    public static byte[] dumpDebugInfo(RawData debugInfo) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream stream = new DataOutputStream(baos);){
            DebuggerDebugObjectFileInfo.putStringWithLen(stream, debugInfo.sourceFile);
            stream.writeInt(debugInfo.methods.length);
            for (DebuggerDebugMethodInfo.RawData methodInfo : debugInfo.methods) {
                stream.writeInt(methodInfo.startLine);
                stream.writeInt(methodInfo.finalLine);
                DebuggerDebugObjectFileInfo.putStringWithLen(stream, methodInfo.signature);
                stream.writeInt(methodInfo.variables.length);
                for (DebuggerDebugVariableInfo varInfo : methodInfo.variables) {
                    DebuggerDebugObjectFileInfo.putStringWithLen(stream, varInfo.name());
                    DebuggerDebugObjectFileInfo.putStringWithLen(stream, varInfo.typeSignature());
                    stream.writeByte(varInfo.isArgument() ? 1 : 0);
                    stream.writeInt(varInfo.startLine());
                    stream.writeInt(varInfo.finalLine());
                }
                stream.writeInt(methodInfo.allocas.length);
                for (DebuggerDebugVariableInfo alloca : methodInfo.allocas) {
                    stream.writeInt(alloca.register());
                    stream.writeInt(alloca.offset());
                }
                stream.writeInt(methodInfo.slices.length);
                for (DebuggerDebugVariableInfo slice : (DebuggerDebugVariableInfo[])methodInfo.slices) {
                    stream.writeInt(((DebuggerDebugVariableInfo)slice).length);
                    for (DebuggerDebugVariableInfo v : slice) {
                        stream.writeInt((int)v);
                    }
                }
                stream.writeInt(methodInfo.offsets.length);
                for (DebuggerDebugVariableInfo v : (DebuggerDebugVariableInfo[])methodInfo.offsets) {
                    stream.writeInt((int)v);
                }
                for (DebuggerDebugVariableInfo v : (DebuggerDebugVariableInfo[])methodInfo.offsetSliceIndexes) {
                    stream.writeInt((int)v);
                }
            }
        }
        return baos.toByteArray();
    }

    public static DebuggerDebugObjectFileInfo readDebugInfo(ByteBuffer buffer) {
        buffer.order(ByteOrder.BIG_ENDIAN);
        String sourceFile = DebuggerDebugObjectFileInfo.getStringWithLen(buffer);
        int methodCount = buffer.getInt();
        DebuggerDebugMethodInfo.RawData[] methods = new DebuggerDebugMethodInfo.RawData[methodCount];
        for (int methodIdx = 0; methodIdx < methodCount; ++methodIdx) {
            int idx;
            int methodStartLine = buffer.getInt();
            int methodEndLine = buffer.getInt();
            String methodSignature = DebuggerDebugObjectFileInfo.getStringWithLen(buffer);
            int count = buffer.getInt();
            DebuggerDebugVariableInfo[] variables = new DebuggerDebugVariableInfo[count];
            for (int idx2 = 0; idx2 < count; ++idx2) {
                String varName = DebuggerDebugObjectFileInfo.getStringWithLen(buffer);
                String varSignature = DebuggerDebugObjectFileInfo.getStringWithLen(buffer);
                int flags = buffer.get() & 0xFF;
                int varStartLine = buffer.getInt();
                int varEndLine = buffer.getInt();
                variables[idx2] = new DebuggerDebugVariableInfo(varName, varSignature, (flags & 1) == 1, varStartLine, varEndLine);
            }
            count = buffer.getInt();
            DwarfDebugVariableInfo[] allocas = new DwarfDebugVariableInfo[count];
            for (int idx3 = 0; idx3 < count; ++idx3) {
                int register = buffer.getInt();
                int offset = buffer.getInt();
                allocas[idx3] = new DwarfDebugVariableInfo(register, offset);
            }
            count = buffer.getInt();
            int[][] slices = new int[count][];
            for (int idx4 = 0; idx4 < count; ++idx4) {
                int sliceSize = buffer.getInt();
                int[] slice = new int[sliceSize];
                slices[idx4] = slice;
                for (int i = 0; i < sliceSize; ++i) {
                    slice[i] = buffer.getInt();
                }
            }
            count = buffer.getInt();
            int[] offsets = new int[count];
            int[] offsetSliceIndexes = new int[count];
            for (idx = 0; idx < count; ++idx) {
                offsets[idx] = buffer.getInt();
            }
            for (idx = 0; idx < count; ++idx) {
                offsetSliceIndexes[idx] = buffer.getInt();
            }
            methods[methodIdx] = new DebuggerDebugMethodInfo.RawData(methodSignature, methodStartLine, methodEndLine, variables, allocas, offsets, offsetSliceIndexes, slices);
        }
        return new DebuggerDebugObjectFileInfo(sourceFile, methods);
    }

    public static void dumpDebugInfoAsText(RawData debugInfo, File file) {
        try (PrintWriter pw = new PrintWriter(file);){
            for (DebuggerDebugMethodInfo.RawData methodInfo : debugInfo.methods) {
                pw.println(methodInfo.signature + " @(" + methodInfo.startLine + ":" + methodInfo.finalLine + ")");
                for (DebuggerDebugVariableInfo variableInfo : methodInfo.variables) {
                    pw.println(variableInfo.name() + "/" + variableInfo.typeSignature() + " @(" + variableInfo.startLine() + ":" + variableInfo.finalLine() + ")");
                }
                pw.println();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static String getStringWithLen(ByteBuffer buffer) {
        int strLen = buffer.getInt();
        if (strLen == 0) {
            return "";
        }
        String str = null;
        try {
            if (buffer.hasArray()) {
                str = new String(buffer.array(), buffer.position(), strLen, "UTF-8");
                buffer.position(buffer.position() + strLen);
            } else {
                byte[] buff = new byte[strLen];
                buffer.get(buff);
                str = new String(buff, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    private static void putStringWithLen(DataOutputStream stream, String str) throws IOException {
        stream.writeInt(str.length());
        if (!str.isEmpty()) {
            stream.write(str.getBytes());
        }
    }

    public static class RawData {
        private final String sourceFile;
        private final DebuggerDebugMethodInfo.RawData[] methods;

        RawData(String sourceFile, DebuggerDebugMethodInfo.RawData[] methods) {
            this.sourceFile = sourceFile;
            this.methods = methods;
        }
    }
}

