/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target.framework;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.robovm.compiler.clazz.Path;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.target.AbstractTarget;
import org.robovm.compiler.target.ios.SDK;
import org.robovm.compiler.util.Executor;

public class FrameworkTarget
extends AbstractTarget {
    public static final String TYPE = "framework";
    private OS os;
    private Arch arch;
    private SDK sdk;

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public OS getOs() {
        return this.os;
    }

    @Override
    public Arch getArch() {
        return this.arch;
    }

    @Override
    public boolean canLaunch() {
        return false;
    }

    public static boolean isSimulatorArch(Arch arch) {
        return arch == Arch.x86 || arch == Arch.x86_64;
    }

    public static boolean isDeviceArch(Arch arch) {
        return arch == Arch.thumbv7 || arch == Arch.arm64;
    }

    public List<SDK> getSDKs() {
        if (FrameworkTarget.isSimulatorArch(this.arch)) {
            return SDK.listSimulatorSDKs();
        }
        return SDK.listDeviceSDKs();
    }

    @Override
    public void init(Config paramConfig) {
        super.init(paramConfig);
        this.os = this.config.getOs();
        if (this.os == null) {
            this.os = OS.getDefaultOS();
        }
        this.arch = this.config.getArch();
        if (this.arch == null) {
            this.arch = Arch.getDefaultArch();
        }
        if (this.os.getFamily() != OS.Family.darwin) {
            throw new IllegalArgumentException("Frameworks can only be built for Darwin platforms");
        }
        if (paramConfig.getInfoPList() == null) {
            throw new IllegalArgumentException("Frameworks must have a Info.plist file");
        }
        paramConfig.getIosInfoPList().parse(paramConfig.getProperties());
        String sdkVersion = this.config.getIosSdkVersion();
        List<SDK> sdks = this.getSDKs();
        if (sdkVersion == null) {
            if (sdks.isEmpty()) {
                throw new IllegalArgumentException("No " + (FrameworkTarget.isDeviceArch(this.arch) ? "device" : "simulator") + " SDKs installed");
            }
            Collections.sort(sdks);
            this.sdk = sdks.get(sdks.size() - 1);
        } else {
            for (SDK sdk : sdks) {
                if (!sdk.getVersion().equals(sdkVersion)) continue;
                this.sdk = sdk;
                break;
            }
            if (this.sdk == null) {
                throw new IllegalArgumentException("No SDK found matching version string " + sdkVersion);
            }
        }
    }

    @Override
    public String getInstallRelativeArchivePath(Path path) {
        return this.config.getImageName() + ".bundle/Resources/" + super.getInstallRelativeArchivePath(path);
    }

    @Override
    protected List<String> getTargetExportedSymbols() {
        return Arrays.asList("JNI_*", "rvmInstantiateFramework");
    }

    private String getMinimumOSVersion() {
        String minimumOSVersion = this.config.getInfoPList().getMinimumOSVersion();
        if (minimumOSVersion != null) {
            return minimumOSVersion;
        }
        return this.config.getOs().getMinVersion();
    }

    @Override
    protected List<String> getTargetCcArgs() {
        ArrayList<String> ccArgs = new ArrayList<String>();
        ccArgs.add("-stdlib=libc++");
        if (FrameworkTarget.isDeviceArch(this.arch)) {
            ccArgs.add("-miphoneos-version-min=" + this.getMinimumOSVersion());
        } else {
            ccArgs.add("-mios-simulator-version-min=" + this.getMinimumOSVersion());
        }
        ccArgs.add("-isysroot");
        ccArgs.add(this.sdk.getRoot().getAbsolutePath());
        ccArgs.add("-dynamiclib");
        ccArgs.add("-single_module");
        ccArgs.add("-compatibility_version");
        ccArgs.add("1");
        ccArgs.add("-current_version");
        ccArgs.add("1");
        if (this.config.getArch() == Arch.x86) {
            ccArgs.add("-read_only_relocs");
            ccArgs.add("suppress");
        }
        ccArgs.add("-install_name");
        ccArgs.add(String.format("@rpath/%s.framework/%s", this.config.getImageName(), this.config.getImageName()));
        return ccArgs;
    }

    @Override
    protected List<String> getTargetLibs() {
        String libSuffix = this.config.isUseDebugLibs() ? "-dbg" : "";
        return Collections.singletonList("-lrobovm-frameworksupport" + libSuffix);
    }

    @Override
    protected void doInstall(File installDir, String image, File resourcesDir) throws IOException {
        NSDictionary infoPlist;
        File frameworkDir = new File(installDir, image + ".framework");
        this.config.getLogger().info("Creating framework: %s", frameworkDir);
        if (frameworkDir.exists()) {
            FileUtils.deleteDirectory((File)frameworkDir);
        }
        frameworkDir.mkdirs();
        File bundleDir = new File(frameworkDir, image + ".bundle");
        bundleDir.mkdirs();
        File bundleResourcesDir = new File(bundleDir, "Resources");
        bundleResourcesDir.mkdirs();
        super.doInstall(frameworkDir, image, bundleResourcesDir);
        File frameworkBinaryFile = new File(frameworkDir, image);
        File dsymDir = new File(installDir, image + ".dSYM");
        this.config.getLogger().info("Creating framework symbol directory: %s", dsymDir);
        if (dsymDir.exists()) {
            FileUtils.deleteDirectory((File)dsymDir);
        }
        dsymDir.mkdirs();
        new Executor(this.config.getLogger(), "xcrun").args("dsymutil", "-o", dsymDir, frameworkBinaryFile).exec();
        if (!this.config.isDebug()) {
            this.config.getLogger().info("Striping framework binary: %s", frameworkBinaryFile);
            new Executor(this.config.getLogger(), "xcrun").args("strip", "-x", frameworkBinaryFile).exec();
        }
        if ((infoPlist = this.config.getInfoPList().getDictionary()).objectForKey("MinimumOSVersion") == null) {
            infoPlist.put("MinimumOSVersion", (Object)this.config.getOs().getMinVersion());
        }
        File infoPlistBin = new File(frameworkDir, "Info.plist");
        this.config.getLogger().info("Installing Info.plist to: %s", infoPlistBin);
        PropertyListParser.saveAsBinary((NSObject)infoPlist, (File)infoPlistBin);
    }
}

