/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target.ios;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.exec.util.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.util.Executor;

public class DeviceType
implements Comparable<DeviceType> {
    public static final String IOS_VERSION_PREFIX = "com.apple.CoreSimulator.SimRuntime.iOS-";
    public static final String PREFERRED_IPHONE_SIM_NAME = "iPhone 6";
    public static final String PREFERRED_IPAD_SIM_NAME = "iPad Air";
    public static final String[] ONLY_32BIT_DEVICES = new String[]{"iPhone 4", "iPhone 4s", "iPhone 5", "iPhone 5c", "iPad 2"};
    private final String deviceName;
    private final String udid;
    private final String state;
    private final Version version;
    private final Set<Arch> archs;

    DeviceType(String deviceName, String udid, String state, Version version, Set<Arch> archs) {
        this.deviceName = deviceName;
        this.udid = udid;
        this.state = state;
        this.version = version;
        this.archs = archs;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public Version getVersion() {
        return this.version;
    }

    public Set<Arch> getArchs() {
        return Collections.unmodifiableSet(this.archs);
    }

    public String getSimpleDeviceTypeId() {
        return this.getSimpleDeviceName() + ", " + this.getVersion();
    }

    public String getSimpleDeviceName() {
        return this.deviceName + " (" + this.udid + ")";
    }

    public DeviceFamily getFamily() {
        if (this.deviceName.contains("iPhone")) {
            return DeviceFamily.iPhone;
        }
        return DeviceFamily.iPad;
    }

    public String getUdid() {
        return this.udid;
    }

    public String getState() {
        return this.getState(false);
    }

    public String getState(boolean fresh) {
        if (fresh) {
            for (DeviceType t : DeviceType.listDeviceTypes()) {
                if (!this.udid.equals(t.udid)) continue;
                return t.state;
            }
        }
        return this.state;
    }

    public static List<DeviceType> listDeviceTypes() {
        try {
            String capture = new Executor(Logger.NULL_LOGGER, "xcrun").args("simctl", "list", "devices", "-j").execCapture();
            ArrayList<DeviceType> types = new ArrayList<DeviceType>();
            JSONParser parser = new JSONParser();
            JSONObject deviceList = (JSONObject)((JSONObject)parser.parse(capture)).get((Object)"devices");
            for (Object value : deviceList.entrySet()) {
                Map.Entry entry = (Map.Entry)value;
                String versionKey = entry.getKey().toString();
                if (versionKey.startsWith(IOS_VERSION_PREFIX)) {
                    versionKey = versionKey.replace(IOS_VERSION_PREFIX, "").replace('-', '.');
                } else {
                    if (!versionKey.startsWith("iOS ")) continue;
                    versionKey = versionKey.replace("iOS ", "");
                }
                JSONArray devices = (JSONArray)entry.getValue();
                for (Object obj : devices) {
                    JSONObject device = (JSONObject)obj;
                    boolean isAvailable = false;
                    if (device.containsKey((Object)"isAvailable")) {
                        Object o = device.get((Object)"isAvailable");
                        isAvailable = o instanceof Boolean ? ((Boolean)o).booleanValue() : "true".equals(o.toString());
                    } else if (device.containsKey((Object)"availability")) {
                        boolean bl = isAvailable = !device.get((Object)"availability").toString().contains("unavailable");
                    }
                    if (!isAvailable) continue;
                    String deviceName = device.get((Object)"name").toString();
                    HashSet<Arch> archs = new HashSet<Arch>();
                    archs.add(Arch.x86);
                    if (!Arrays.asList(ONLY_32BIT_DEVICES).contains(deviceName)) {
                        archs.add(Arch.x86_64);
                    }
                    types.add(new DeviceType(deviceName, device.get((Object)"udid").toString(), device.get((Object)"state").toString(), Version.parse(versionKey), archs));
                }
            }
            Collections.sort(types);
            return types;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(DeviceType that) {
        int c = this.version.compareTo(that.version);
        if (c == 0 && (c = this.getFamily().compareTo(that.getFamily())) == 0) {
            c = this.deviceName.compareToIgnoreCase(that.deviceName);
        }
        return c;
    }

    private static List<DeviceType> filter(List<DeviceType> deviceTypes, Arch arch, DeviceFamily family, String deviceName, Version simVersion) {
        deviceName = deviceName == null ? null : deviceName.toLowerCase();
        ArrayList<DeviceType> result = new ArrayList<DeviceType>();
        for (DeviceType type : deviceTypes) {
            if (arch != null && !type.getArchs().contains((Object)arch) || family != null && family != type.getFamily() || deviceName != null && !type.getDeviceName().toLowerCase().contains(deviceName) || simVersion != null && !type.version.isSameOrBetter(simVersion)) continue;
            result.add(type);
        }
        return result;
    }

    public static List<String> getSimpleDeviceTypeIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (DeviceType type : DeviceType.listDeviceTypes()) {
            result.add(type.getSimpleDeviceTypeId());
        }
        return result;
    }

    public static DeviceType getDeviceType(String displayName) {
        List<DeviceType> types = DeviceType.listDeviceTypes();
        if (displayName == null) {
            return null;
        }
        for (DeviceType type : types) {
            if (!displayName.equals(type.getSimpleDeviceTypeId())) continue;
            return type;
        }
        return null;
    }

    public static DeviceType getBestDeviceType() {
        return DeviceType.getBestDeviceType(null, null, null, null);
    }

    public static DeviceType getBestDeviceType(DeviceFamily family) {
        return DeviceType.getBestDeviceType(null, family, null, null);
    }

    public static DeviceType getBestDeviceType(Arch arch, DeviceFamily family, String deviceName, String deviceVersion) {
        if (deviceName == null && family == null) {
            family = DeviceFamily.iPhone;
        }
        String preferredDeciveName = PREFERRED_IPHONE_SIM_NAME;
        if (family == DeviceFamily.iPad) {
            preferredDeciveName = PREFERRED_IPAD_SIM_NAME;
        }
        DeviceType exact = null;
        DeviceType bestDefault = null;
        DeviceType bestAny = null;
        Version version = deviceVersion != null ? Version.parse(deviceVersion) : null;
        List<DeviceType> devices = DeviceType.filter(DeviceType.listDeviceTypes(), arch, family, deviceName, version);
        for (DeviceType type : devices) {
            if (type.getDeviceName().equals(deviceName)) {
                if (exact != null && (version != null || type.version.versionCode <= exact.version.versionCode)) continue;
                exact = type;
                continue;
            }
            if (deviceName == null && type.getDeviceName().equals(preferredDeciveName)) {
                if (bestDefault != null && (version != null || type.version.versionCode <= bestDefault.version.versionCode)) continue;
                bestDefault = type;
                continue;
            }
            if (bestAny != null && (version != null || type.version.versionCode <= bestAny.version.versionCode)) continue;
            bestAny = type;
        }
        DeviceType best = exact;
        if (best == null) {
            DeviceType deviceType = best = bestDefault != null ? bestDefault : bestAny;
        }
        if (best == null) {
            throw new IllegalArgumentException("Unable to find a matching device [arch=" + (Object)((Object)arch) + ", family=" + (Object)((Object)family) + ", name=" + deviceName + ", version=" + version + "]");
        }
        return best;
    }

    public String toString() {
        return "DeviceType [deviceName=" + this.deviceName + ", version=" + this.version + ", archs=" + this.archs + "]";
    }

    public static class Version {
        public final int major;
        public final int minor;
        public final int revision;
        public final int versionCode;

        public Version(int major, int minor, int revision, int versionCode) {
            this.major = major;
            this.minor = minor;
            this.revision = revision;
            this.versionCode = versionCode;
        }

        static Version parse(String v) {
            String[] parts = StringUtils.split((String)v, (String)".");
            int major = Integer.parseInt(parts[0]);
            int minor = parts.length >= 2 ? Integer.parseInt(parts[1]) : 0;
            int revision = parts.length >= 3 ? Integer.parseInt(parts[2]) : 0;
            int versionCode = major << 16 | minor << 8 | revision;
            return new Version(major, minor, revision, versionCode);
        }

        public String toString() {
            return this.major + "." + this.minor + (this.revision != 0 ? "." + this.revision : "");
        }

        public int compareTo(Version other) {
            return this.versionCode - other.versionCode;
        }

        public boolean isSameOrBetter(Version other) {
            return this.versionCode >= other.versionCode;
        }
    }

    public static enum DeviceFamily {
        iPhone,
        iPad;

    }
}

